/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XAdESSigProperties
implements SignatureProperties<XAdESAttribute> {
    private static final long serialVersionUID = -8950099614582666431L;
    private final Element signaturePropertiesDom;
    private final XAdESPaths xadesPaths;

    XAdESSigProperties(Element signatureProperties, XAdESPaths xadesPaths) {
        this.signaturePropertiesDom = signatureProperties;
        this.xadesPaths = xadesPaths;
    }

    @Override
    public boolean isExist() {
        return this.signaturePropertiesDom != null;
    }

    @Override
    public List<XAdESAttribute> getAttributes() {
        ArrayList<XAdESAttribute> unsignedAttributes = new ArrayList<XAdESAttribute>();
        if (this.signaturePropertiesDom != null && this.signaturePropertiesDom.hasChildNodes()) {
            NodeList unsignedProperties = this.signaturePropertiesDom.getChildNodes();
            for (int ii = 0; ii < unsignedProperties.getLength(); ++ii) {
                Node node = unsignedProperties.item(ii);
                if (!this.isElementNode(node)) continue;
                XAdESAttribute unsignedAttribute = new XAdESAttribute((Element)node, this.xadesPaths);
                unsignedAttributes.add(unsignedAttribute);
            }
        }
        return unsignedAttributes;
    }

    private boolean isElementNode(Node node) {
        return node.getNodeType() == 1;
    }
}

