/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.model.SerializableCounterSignatureParameters;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;

public class XAdESCounterSignatureParameters
extends XAdESSignatureParameters
implements SerializableCounterSignatureParameters {
    private static final long serialVersionUID = -1443369404631708953L;
    private String signatureIdToCounterSign;
    private String counterSignatureCanonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";

    @Override
    public String getSignatureIdToCounterSign() {
        return this.signatureIdToCounterSign;
    }

    @Override
    public void setSignatureIdToCounterSign(String signatureId) {
        this.signatureIdToCounterSign = signatureId;
    }

    public String getCounterSignatureCanonicalizationMethod() {
        return this.counterSignatureCanonicalizationMethod;
    }

    public void setCounterSignatureCanonicalizationMethod(String counterSignatureCanonicalizationMethod) {
        this.counterSignatureCanonicalizationMethod = counterSignatureCanonicalizationMethod;
    }

    @Override
    public String getDeterministicId() {
        String deterministicId = this.getContext().getDeterministicId();
        if (deterministicId == null) {
            TokenIdentifier identifier = this.getSigningCertificate() == null ? null : this.getSigningCertificate().getDSSId();
            deterministicId = DSSUtils.getCounterSignatureDeterministicId(this.bLevel().getSigningDate(), identifier, this.signatureIdToCounterSign);
            this.getContext().setDeterministicId(deterministicId);
        }
        return deterministicId;
    }
}

