/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Attribute;
import eu.europa.esig.dss.xades.definition.xades141.XAdES141Element;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESSignaturePolicy;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import eu.europa.esig.dss.xades.validation.policy.XMLSignaturePolicyValidator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignaturePolicyStoreBuilder
extends ExtensionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SignaturePolicyStoreBuilder.class);

    public DSSDocument addSignaturePolicyStore(DSSDocument signatureDocument, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(signatureDocument, "Signature document must be provided!");
        this.assertConfigurationValid(signaturePolicyStore);
        XMLDocumentValidator documentValidator = this.initDocumentValidator(signatureDocument);
        boolean signaturePolicyStoreAdded = false;
        for (AdvancedSignature signature : documentValidator.getSignatures()) {
            boolean added = this.addSignaturePolicyStoreIfDigestMatch((XAdESSignature)signature, this.documentDom, signaturePolicyStore);
            signaturePolicyStoreAdded = signaturePolicyStoreAdded || added;
        }
        if (!signaturePolicyStoreAdded) {
            throw new IllegalInputException("The process did not find a signature to add SignaturePolicyStore!");
        }
        return this.createXmlDocument();
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument signatureDocument, SignaturePolicyStore signaturePolicyStore, String signatureId) {
        Objects.requireNonNull(signatureDocument, "Signature document must be provided!");
        this.assertConfigurationValid(signaturePolicyStore);
        XMLDocumentValidator documentValidator = this.initDocumentValidator(signatureDocument);
        AdvancedSignature signature = documentValidator.getSignatureById(signatureId);
        if (signature == null) {
            throw new IllegalInputException(String.format("Unable to find a signature with Id : %s!", signatureId));
        }
        boolean added = this.addSignaturePolicyStoreIfDigestMatch((XAdESSignature)signature, this.documentDom, signaturePolicyStore);
        if (!added) {
            throw new IllegalInputException(String.format("The process was not able to add SignaturePolicyStore to a signature with Id : %s!", signatureId));
        }
        return this.createXmlDocument();
    }

    private XMLDocumentValidator initDocumentValidator(DSSDocument document) {
        this.params = new XAdESSignatureParameters();
        this.documentValidator = new XMLDocumentValidator(document);
        this.documentDom = this.documentValidator.getRootElement();
        return this.documentValidator;
    }

    protected boolean addSignaturePolicyStoreIfDigestMatch(XAdESSignature xadesSignature, Document documentDom, SignaturePolicyStore signaturePolicyStore) {
        xadesSignature = this.initializeSignatureBuilder(xadesSignature);
        this.ensureUnsignedProperties();
        this.ensureUnsignedSignatureProperties();
        if (this.checkDigest(xadesSignature, signaturePolicyStore)) {
            String sigPolDocLocalURI;
            Element signaturePolicyStoreElement = DomUtils.addElement(documentDom, this.unsignedSignaturePropertiesDom, this.getXades141Namespace(), XAdES141Element.SIGNATURE_POLICY_STORE);
            if (signaturePolicyStore.getId() != null) {
                signaturePolicyStoreElement.setAttribute(XAdES141Attribute.ID.getAttributeName(), signaturePolicyStore.getId());
            }
            SpDocSpecification spDocSpecification = signaturePolicyStore.getSpDocSpecification();
            this.incorporateSPDocSpecification(signaturePolicyStoreElement, spDocSpecification);
            DSSDocument signaturePolicyContent = signaturePolicyStore.getSignaturePolicyContent();
            if (signaturePolicyContent != null) {
                Element policyDocElement = DomUtils.addElement(documentDom, signaturePolicyStoreElement, this.getXades141Namespace(), XAdES141Element.SIGNATURE_POLICY_DOCUMENT);
                DomUtils.setTextNode(documentDom, policyDocElement, Utils.toBase64(DSSUtils.toByteArray(signaturePolicyContent)));
            }
            if (Utils.isStringNotEmpty(sigPolDocLocalURI = signaturePolicyStore.getSigPolDocLocalURI())) {
                DomUtils.addTextElement(documentDom, signaturePolicyStoreElement, this.getXades141Namespace(), XAdES141Element.SIG_POL_DOC_LOCAL_URI, sigPolDocLocalURI);
            }
            return true;
        }
        return false;
    }

    protected boolean checkDigest(XAdESSignature xadesSignature, SignaturePolicyStore signaturePolicyStore) {
        Digest computedDigest;
        String currentSignatureId = xadesSignature.getDAIdentifier();
        XAdESSignaturePolicy signaturePolicy = xadesSignature.getSignaturePolicy();
        if (signaturePolicy == null) {
            LOG.warn("No defined SignaturePolicyIdentifier for signature with Id : {}", (Object)currentSignatureId);
            return false;
        }
        Digest digest = signaturePolicy.getDigest();
        if (digest == null) {
            LOG.warn("No defined digest for signature with Id : {}", (Object)currentSignatureId);
            return false;
        }
        DSSDocument signaturePolicyContent = signaturePolicyStore.getSignaturePolicyContent();
        if (signaturePolicyContent == null) {
            LOG.info("No policy document has been provided. Digests are not checked!");
            return true;
        }
        signaturePolicy.setPolicyContent(signaturePolicyContent);
        try {
            SignaturePolicyValidator validator = this.documentValidator.getSignaturePolicyValidatorLoader().loadValidator(signaturePolicy);
            if (validator instanceof XMLSignaturePolicyValidator) {
                XMLSignaturePolicyValidator xmlSignaturePolicyValidator = (XMLSignaturePolicyValidator)validator;
                computedDigest = xmlSignaturePolicyValidator.getDigestAfterTransforms(signaturePolicyContent, digest.getAlgorithm(), signaturePolicy.getTransforms());
            } else {
                computedDigest = validator.getComputedDigest(signaturePolicyStore.getSignaturePolicyContent(), digest.getAlgorithm());
            }
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to compute digest for a SignaturePolicyStore. Reason : %s", e.getMessage()), e);
        }
        boolean digestMatch = digest.equals(computedDigest);
        if (!digestMatch) {
            LOG.warn("Signature policy's digest {} doesn't match the digest extracted from document {} for signature with Id : {}", computedDigest, digest, currentSignatureId);
        }
        return digestMatch;
    }

    private void assertConfigurationValid(SignaturePolicyStore signaturePolicyStore) {
        boolean sigPolDocLocalURIPresent;
        Objects.requireNonNull(signaturePolicyStore, "SignaturePolicyStore must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification(), "SpDocSpecification must be provided");
        Objects.requireNonNull(signaturePolicyStore.getSpDocSpecification().getId(), "ID (OID or URI) for SpDocSpecification must be provided");
        boolean signaturePolicyContentPresent = signaturePolicyStore.getSignaturePolicyContent() != null;
        boolean bl = sigPolDocLocalURIPresent = signaturePolicyStore.getSigPolDocLocalURI() != null;
        if (!(signaturePolicyContentPresent ^ sigPolDocLocalURIPresent)) {
            throw new IllegalArgumentException("SignaturePolicyStore shall contain either SignaturePolicyContent document or sigPolDocLocalURI!");
        }
    }
}

