/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.utils.Utils;

public class XAdESTimestampParameters
extends TimestampParameters {
    private String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public XAdESTimestampParameters() {
    }

    public XAdESTimestampParameters(DigestAlgorithm digestAlgorithm) {
        super(digestAlgorithm);
    }

    public XAdESTimestampParameters(DigestAlgorithm digestAlgorithm, String canonicalizationMethod) {
        super(digestAlgorithm);
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        if (Utils.isStringEmpty(canonicalizationMethod)) {
            throw new IllegalArgumentException("Canonicalization cannot be empty! See EN 319 132-1: 4.5 Managing canonicalization of XML nodesets.");
        }
        this.canonicalizationMethod = canonicalizationMethod;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.canonicalizationMethod == null ? 0 : this.canonicalizationMethod.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        XAdESTimestampParameters other = (XAdESTimestampParameters)obj;
        return !(this.canonicalizationMethod == null ? other.canonicalizationMethod != null : !this.canonicalizationMethod.equals(other.canonicalizationMethod));
    }

    @Override
    public String toString() {
        return "TimestampParameters {digestAlgorithm=" + this.digestAlgorithm.getName() + ", canonicalizationMethod=" + this.canonicalizationMethod + "}";
    }
}

