/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.AbstractPaths;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.SantuarioInitializer;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Paths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Element;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Paths;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.reference.ReferenceOutputType;
import eu.europa.esig.dss.xades.signature.PrettyPrintTransformer;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.xmldsig.XSDAbstractUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DSSXMLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DSSXMLUtils.class);
    private static final Set<String> transforms;
    private static final Set<String> canonicalizers;
    private static final Set<String> transformsWithNodeSetOutput;
    private static final String TRANSFORMATION_EXCLUDE_SIGNATURE = "not(ancestor-or-self::ds:Signature)";
    private static final String TRANSFORMATION_XPATH_NODE_NAME = "XPath";
    public static final String DEFAULT_DSS_C14N_METHOD = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String DEFAULT_XMLDSIG_C14N_METHOD = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String SP_DOC_DIGEST_AS_IN_SPECIFICATION_ALGORITHM_URI = "http://uri.etsi.org/01903/v1.3.2/SignaturePolicy/SPDocDigestAsInSpecification";

    private static void registerDefaultTransforms() {
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#base64");
        DSSXMLUtils.registerTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DSSXMLUtils.registerTransform("http://www.w3.org/2002/06/xmldsig-filter2");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/2001/WD-xptr-20010108");
        DSSXMLUtils.registerTransform("http://www.w3.org/TR/1999/REC-xslt-19991116");
    }

    private static void registerDefaultCanonicalizers() {
        DSSXMLUtils.registerCanonicalizer(DEFAULT_XMLDSIG_C14N_METHOD);
        DSSXMLUtils.registerCanonicalizer(DEFAULT_DSS_C14N_METHOD);
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11");
        DSSXMLUtils.registerCanonicalizer("http://santuario.apache.org/c14n/physical");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        DSSXMLUtils.registerCanonicalizer("http://www.w3.org/2006/12/xml-c14n11#WithComments");
    }

    private static void registerTransformsWithNodeSetOutput() {
        DSSXMLUtils.registerTransformWithNodeSetOutput("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DSSXMLUtils.registerTransformWithNodeSetOutput("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DSSXMLUtils.registerTransformWithNodeSetOutput("http://www.w3.org/2002/06/xmldsig-filter2");
    }

    private DSSXMLUtils() {
    }

    public static boolean registerTransform(String transformURI) {
        return transforms.add(transformURI);
    }

    public static boolean registerCanonicalizer(String c14nAlgorithmURI) {
        return canonicalizers.add(c14nAlgorithmURI);
    }

    public static boolean registerTransformWithNodeSetOutput(String transformURI) {
        return transformsWithNodeSetOutput.add(transformURI);
    }

    public static Node indentAndReplace(Document document, Node node) {
        Node indentedNode = DSSXMLUtils.getIndentedNode(document, node);
        Node importedNode = document.importNode(indentedNode, true);
        node.getParentNode().replaceChild(importedNode, node);
        return importedNode;
    }

    public static Node indentAndExtend(Document document, Node newNode, Node oldNode) {
        Node indentedNode = DSSXMLUtils.getIndentedNode(document, newNode);
        indentedNode = DSSXMLUtils.alignChildrenIndents(indentedNode);
        Node importedNode = document.importNode(indentedNode, true);
        NodeList nodeList = importedNode.getChildNodes();
        for (int i = DSSXMLUtils.getPositionToStartExtension(oldNode, importedNode); i < nodeList.getLength(); ++i) {
            Node nodeToAppend = nodeList.item(i).cloneNode(true);
            if (1 == nodeToAppend.getNodeType() && DSSXMLUtils.checkIfExists(oldNode, nodeToAppend)) continue;
            oldNode.appendChild(nodeToAppend);
        }
        newNode.getParentNode().replaceChild(oldNode, newNode);
        return oldNode;
    }

    private static int getPositionToStartExtension(Node oldNode, Node indentedNode) {
        NodeList nodeList = oldNode.getChildNodes();
        int startPosition = nodeList.getLength();
        Node child = null;
        while (oldNode.hasChildNodes() && 3 == (child = oldNode.getLastChild()).getNodeType()) {
            oldNode.removeChild(child);
        }
        Integer position = DSSXMLUtils.getPosition(indentedNode, child);
        if (position != null) {
            return position;
        }
        return startPosition;
    }

    private static boolean checkIfExists(Node parentNode, Node childToCheck) {
        return DSSXMLUtils.getPosition(parentNode, childToCheck) != null;
    }

    private static Integer getPosition(Node parentNode, Node childToCheck) {
        if (parentNode != null && childToCheck != null) {
            String nodeName = childToCheck.getLocalName();
            NodeList newNodeChildList = parentNode.getChildNodes();
            for (int i = 0; i < newNodeChildList.getLength(); ++i) {
                String idIdentifier;
                Node newChildNode = newNodeChildList.item(i);
                if (!nodeName.equals(newChildNode.getLocalName()) || (idIdentifier = DSSXMLUtils.getIDIdentifier(childToCheck)) != null && !idIdentifier.equals(DSSXMLUtils.getIDIdentifier(newChildNode))) continue;
                return i + 1;
            }
        }
        return null;
    }

    public static Document getDocWithIndentedSignature(Document documentDom, String signatureId, List<String> noIndentObjectIds) {
        NodeList signatures = DomUtils.getNodeList(documentDom, XMLDSigPaths.ALL_SIGNATURES_PATH);
        for (int i = 0; i < signatures.getLength(); ++i) {
            Element signature = (Element)signatures.item(i);
            String signatureAttrIdValue = DSSXMLUtils.getIDIdentifier(signature);
            if (!Utils.isStringNotEmpty(signatureAttrIdValue) || !signatureAttrIdValue.contains(signatureId)) continue;
            Node unsignedSignatureProperties = DomUtils.getNode(signature, AbstractPaths.allFromCurrentPosition(XAdES132Element.UNSIGNED_SIGNATURE_PROPERTIES));
            Node indentedSignature = DSSXMLUtils.getIndentedSignature(signature, noIndentObjectIds);
            Node importedSignature = documentDom.importNode(indentedSignature, true);
            signature.getParentNode().replaceChild(importedSignature, signature);
            if (unsignedSignatureProperties == null) continue;
            Node newUnsignedSignatureProperties = DomUtils.getNode(signature, AbstractPaths.allFromCurrentPosition(XAdES132Element.UNSIGNED_SIGNATURE_PROPERTIES));
            newUnsignedSignatureProperties.getParentNode().replaceChild(unsignedSignatureProperties, newUnsignedSignatureProperties);
        }
        return documentDom;
    }

    private static Node getIndentedSignature(Node signature, List<String> noIndentObjectIds) {
        Node indentedSignature = DSSXMLUtils.getIndentedNode(signature);
        NodeList sigChildNodes = signature.getChildNodes();
        for (int i = 0; i < sigChildNodes.getLength(); ++i) {
            Element sigChild;
            String idAttribute;
            Node childNode = sigChildNodes.item(i);
            if (childNode.getNodeType() != 1 || !noIndentObjectIds.contains(idAttribute = DSSXMLUtils.getIDIdentifier(sigChild = (Element)childNode))) continue;
            Element nodeToReplace = DomUtils.getElementById(indentedSignature, idAttribute);
            Node importedNode = indentedSignature.getOwnerDocument().importNode(sigChild, true);
            indentedSignature.replaceChild(importedNode, nodeToReplace);
        }
        return indentedSignature;
    }

    public static Node getIndentedNode(Node documentDom, Node xmlNode) {
        NodeList signatures = DomUtils.getNodeList(documentDom, XMLDSigPaths.ALL_SIGNATURES_PATH);
        DSSElement element = XAdES132Element.fromTagName(xmlNode.getLocalName());
        String pathAllFromCurrentPosition = element != null ? AbstractPaths.allFromCurrentPosition(element) : ".//" + xmlNode.getNodeName();
        for (int i = 0; i < signatures.getLength(); ++i) {
            Node signature = signatures.item(i);
            String idAttribute = DSSXMLUtils.getIDIdentifier(xmlNode);
            NodeList candidateList = idAttribute != null ? DomUtils.getNodeList(signature, ".//*" + DomUtils.getXPathByIdAttribute(idAttribute)) : DomUtils.getNodeList(signature, pathAllFromCurrentPosition);
            if (!DSSXMLUtils.isNodeListContains(candidateList, xmlNode)) continue;
            Node indentedSignature = DSSXMLUtils.getIndentedNode(signature);
            Node indentedXmlNode = idAttribute != null ? DomUtils.getElementById(indentedSignature, idAttribute) : DomUtils.getNode(indentedSignature, pathAllFromCurrentPosition);
            if (indentedXmlNode == null) continue;
            return indentedXmlNode;
        }
        return xmlNode;
    }

    private static Node getIndentedNode(Node xmlNode) {
        PrettyPrintTransformer prettyPrintTransformer = new PrettyPrintTransformer();
        return prettyPrintTransformer.transform(xmlNode);
    }

    private static boolean isNodeListContains(NodeList nodeList, Node node) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child != node) continue;
            return true;
        }
        return false;
    }

    public static Node alignChildrenIndents(Node parentNode) {
        NodeList nodeChildren;
        String targetIndent;
        if (parentNode.hasChildNodes() && (targetIndent = DSSXMLUtils.getTargetIndent(nodeChildren = parentNode.getChildNodes())) != null) {
            for (int i = 0; i < nodeChildren.getLength() - 1; ++i) {
                Node node = nodeChildren.item(i);
                if (3 != node.getNodeType()) continue;
                node.setNodeValue(targetIndent);
            }
            Node lastChild = parentNode.getLastChild();
            targetIndent = targetIndent.substring(0, targetIndent.length() - 4);
            switch (lastChild.getNodeType()) {
                case 1: {
                    DomUtils.setTextNode(parentNode.getOwnerDocument(), (Element)parentNode, targetIndent);
                    break;
                }
                case 3: {
                    lastChild.setNodeValue(targetIndent);
                    break;
                }
            }
        }
        return parentNode;
    }

    private static String getTargetIndent(NodeList nodeChildren) {
        for (int i = 0; i < nodeChildren.getLength() - 1; ++i) {
            Node node = nodeChildren.item(i);
            if (3 != node.getNodeType()) continue;
            return node.getNodeValue();
        }
        return null;
    }

    public static byte[] serializeNode(Node xmlNode) {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            String xmlEncoding;
            Transformer transformer = DomUtils.getSecureTransformer();
            Document document = 9 == xmlNode.getNodeType() ? (Document)xmlNode : xmlNode.getOwnerDocument();
            if (document != null && Utils.isStringNotBlank(xmlEncoding = document.getXmlEncoding())) {
                transformer.setOutputProperty("encoding", xmlEncoding);
            }
            StreamResult result = new StreamResult(bos);
            DOMSource source = new DOMSource(xmlNode);
            transformer.transform(source, result);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DSSException("An error occurred during a node serialization.", e);
            }
        }
        bos.close();
        return byArray;
    }

    public static boolean canCanonicalize(String canonicalizationMethod) {
        return canonicalizers.contains(canonicalizationMethod);
    }

    public static byte[] canonicalize(String canonicalizationMethod, byte[] toCanonicalizeBytes) throws DSSException {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Canonicalizer c14n = Canonicalizer.getInstance(DSSXMLUtils.getCanonicalizationMethod(canonicalizationMethod));
            c14n.canonicalize(toCanonicalizeBytes, baos, true);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DSSException("Cannot canonicalize the binaries", e);
            }
        }
        baos.close();
        return byArray;
    }

    public static byte[] canonicalizeSubtree(String canonicalizationMethod, Node node) {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Canonicalizer c14n = Canonicalizer.getInstance(DSSXMLUtils.getCanonicalizationMethod(canonicalizationMethod));
            c14n.canonicalizeSubtree(node, baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DSSException("Cannot canonicalize the subtree", e);
            }
        }
        baos.close();
        return byArray;
    }

    public static String getCanonicalizationMethod(String canonicalizationMethod) {
        if (Utils.isStringEmpty(canonicalizationMethod)) {
            LOG.warn("Canonicalization method is not defined. An inclusive canonicalization '{}' will be used (see XMLDSIG 4.4.3.2).", (Object)DEFAULT_XMLDSIG_C14N_METHOD);
            return DEFAULT_XMLDSIG_C14N_METHOD;
        }
        return canonicalizationMethod;
    }

    public static void recursiveIdBrowse(Element element) {
        for (int ii = 0; ii < element.getChildNodes().getLength(); ++ii) {
            Node node = element.getChildNodes().item(ii);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            DSSXMLUtils.setIDIdentifier(childElement);
            DSSXMLUtils.recursiveIdBrowse(childElement);
        }
    }

    public static String getIDIdentifier(Node node) {
        return DSSXMLUtils.getAttribute(node, XMLDSigAttribute.ID.getAttributeName());
    }

    public static String getAttribute(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            String localName;
            Node item = attributes.item(jj);
            String string = localName = item.getLocalName() != null ? item.getLocalName() : item.getNodeName();
            if (!Utils.areStringsEqualIgnoreCase(attributeName, localName)) continue;
            return item.getTextContent();
        }
        return null;
    }

    public static void setIDIdentifier(Element childElement) {
        NamedNodeMap attributes = childElement.getAttributes();
        for (int jj = 0; jj < attributes.getLength(); ++jj) {
            Node item = attributes.item(jj);
            String localName = item.getLocalName();
            String nodeName = item.getNodeName();
            if (localName == null || !Utils.areStringsEqualIgnoreCase(XMLDSigAttribute.ID.getAttributeName(), localName)) continue;
            childElement.setIdAttribute(nodeName, true);
            break;
        }
    }

    public static List<String> validateAgainstXSD(XSDAbstractUtils xsdUtils, Source source) {
        return xsdUtils.validateAgainstXSD(source);
    }

    public static boolean isDuplicateIdsDetected(DSSDocument doc) {
        try {
            Document dom = DomUtils.buildDOM(doc);
            Element root = dom.getDocumentElement();
            DSSXMLUtils.recursiveIdBrowse(root);
            XPathExpression xPathExpression = DomUtils.createXPathExpression("//*/@*");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(root, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XPathExpression xpathAllById;
                NodeList nodeListById;
                Attr attr = (Attr)nodeList.item(i);
                if (!Utils.areStringsEqualIgnoreCase(XMLDSigAttribute.ID.getAttributeName(), attr.getName()) || (nodeListById = (NodeList)(xpathAllById = DomUtils.createXPathExpression("//*[@" + attr.getName() + "='" + attr.getValue() + "']")).evaluate(root, XPathConstants.NODESET)).getLength() == 1) continue;
                LOG.warn("Problem detected with Id '{}', nb occurences = {}", (Object)attr.getValue(), (Object)nodeListById.getLength());
                return true;
            }
        }
        catch (XPathExpressionException e) {
            throw new DSSException("Unable to check if duplicate ids are present", e);
        }
        return false;
    }

    public static byte[] getNodeBytes(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 9: {
                byte[] bytes = DSSXMLUtils.serializeNode(node);
                String str = new String(bytes);
                if (str.startsWith("<?")) {
                    str = str.substring(str.indexOf("?>") + 2);
                }
                return str.getBytes();
            }
            case 3: {
                String textContent = node.getTextContent();
                if (Utils.isBase64Encoded(textContent)) {
                    return Utils.fromBase64(node.getTextContent());
                }
                return textContent.getBytes();
            }
        }
        return null;
    }

    public static byte[] getReferenceOriginalContentBytes(Reference reference) {
        try {
            Element transformsElement;
            NodeList transformChildNodes;
            Transforms transforms = reference.getTransforms();
            if (transforms != null && (transformChildNodes = (transformsElement = transforms.getElement()).getChildNodes()) != null && transformChildNodes.getLength() > 0) {
                for (int i = 0; i < transformChildNodes.getLength(); ++i) {
                    Node transformation = transformChildNodes.item(i);
                    if (!DSSXMLUtils.isEnvelopedTransform(transformation)) continue;
                    return reference.getReferencedBytes();
                }
            }
        }
        catch (XMLSecurityException e) {
            LOG.warn("Signature reference with id [{}] is corrupted or has an invalid format. Original data cannot be obtained. Reason: [{}]", (Object)reference.getId(), (Object)e.getMessage());
        }
        return DSSXMLUtils.getBytesBeforeTransformation(reference);
    }

    private static boolean isEnvelopedTransform(Node transformation) {
        String algorithm = DomUtils.getValue(transformation, "@Algorithm");
        if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(algorithm)) {
            return true;
        }
        if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(algorithm) || "http://www.w3.org/2002/06/xmldsig-filter2".equals(algorithm)) {
            NodeList childNodes = transformation.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node item = childNodes.item(j);
                if (1 != item.getNodeType() || !TRANSFORMATION_XPATH_NODE_NAME.equals(item.getLocalName()) || !TRANSFORMATION_EXCLUDE_SIGNATURE.equals(item.getTextContent())) continue;
                return true;
            }
        }
        return false;
    }

    private static byte[] getBytesBeforeTransformation(Reference reference) {
        try {
            return reference.getContentsBeforeTransformation().getBytes();
        }
        catch (ReferenceNotInitializedException e) {
            LOG.warn("Original data is not provided for the reference with id [{}]. Reason: [{}]", (Object)reference.getId(), (Object)e.getMessage());
        }
        catch (IOException | CanonicalizationException e) {
            LOG.error("Unable to retrieve the content of reference with id [{}].", (Object)reference.getId(), (Object)e);
        }
        return null;
    }

    public static Digest getDigestAndValue(Element element) {
        String digestValueBase64;
        String digestAlgorithmUri;
        if (element == null) {
            return null;
        }
        if (XAdESNamespaces.XADES_111.isSameUri(element.getNamespaceURI())) {
            digestAlgorithmUri = DomUtils.getValue(element, XAdES111Paths.DIGEST_METHOD_ALGORITHM_PATH);
            digestValueBase64 = DomUtils.getValue(element, XAdES111Paths.DIGEST_VALUE_PATH);
        } else {
            digestAlgorithmUri = DomUtils.getValue(element, XMLDSigPaths.DIGEST_METHOD_ALGORITHM_PATH);
            digestValueBase64 = DomUtils.getValue(element, XMLDSigPaths.DIGEST_VALUE_PATH);
        }
        DigestAlgorithm digestAlgorithm = DSSXMLUtils.getDigestAlgorithm(digestAlgorithmUri);
        byte[] digestValue = DSSXMLUtils.getDigestValue(digestValueBase64);
        if (digestAlgorithm == null || Utils.isArrayEmpty(digestValue)) {
            LOG.warn("Unable to read object DigestAlgAndValueType (XMLDSig or XAdES 1.1.1)");
            return null;
        }
        return new Digest(digestAlgorithm, digestValue);
    }

    private static byte[] getDigestValue(String digestValueBase64) {
        byte[] result = null;
        if (Utils.isStringEmpty(digestValueBase64)) {
            LOG.error("An empty DigestValue obtained!");
        } else if (!Utils.isBase64Encoded(digestValueBase64)) {
            LOG.error("The DigestValue is not base64 encoded! Obtained string : {}", (Object)digestValueBase64);
        } else {
            result = Utils.fromBase64(digestValueBase64);
        }
        return result;
    }

    private static DigestAlgorithm getDigestAlgorithm(String digestAlgorithmUri) {
        DigestAlgorithm result = null;
        if (Utils.isStringNotEmpty(digestAlgorithmUri)) {
            try {
                result = DigestAlgorithm.forXML(digestAlgorithmUri);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to retrieve the used digest algorithm", e);
            }
        }
        return result;
    }

    public static boolean isSignedProperties(Reference reference, XAdESPaths xadesPaths) {
        return xadesPaths.getSignedPropertiesUri().equals(reference.getType());
    }

    public static boolean isCounterSignature(Reference reference, XAdESPaths xadesPaths) {
        return xadesPaths.getCounterSignatureUri().equals(reference.getType());
    }

    public static boolean isKeyInfoReference(Reference reference, Element signature) {
        String uri = reference.getURI();
        uri = DomUtils.getId(uri);
        Element keyInfoElement = DomUtils.getElement(signature, XMLDSigPaths.KEY_INFO_PATH + DomUtils.getXPathByIdAttribute(uri));
        return keyInfoElement != null;
    }

    public static boolean isSignaturePropertiesReference(Reference reference, Element signature) {
        String uri = reference.getURI();
        uri = DomUtils.getId(uri);
        Element signaturePropertiesElement = DomUtils.getElement(signature, XMLDSigPaths.SIGNATURE_PROPERTIES_PATH + DomUtils.getXPathByIdAttribute(uri));
        Element signaturePropertyElement = DomUtils.getElement(signature, XMLDSigPaths.SIGNATURE_PROPERTY_PATH + DomUtils.getXPathByIdAttribute(uri));
        return signaturePropertiesElement != null || signaturePropertyElement != null;
    }

    public static boolean isObjectReferenceType(String referenceType) {
        return "http://www.w3.org/2000/09/xmldsig#Object".equals(referenceType);
    }

    public static boolean isManifestReferenceType(String referenceType) {
        return "http://www.w3.org/2000/09/xmldsig#Manifest".equals(referenceType);
    }

    public static boolean isCounterSignatureReferenceType(String referenceType) {
        return "http://uri.etsi.org/01903#CountersignedSignature".equals(referenceType);
    }

    public static boolean isSameDocumentReference(String referenceUri) {
        return "".equals(referenceUri) || DomUtils.startsFromHash(referenceUri);
    }

    public static PublicKey getKeyInfoSigningCertificatePublicKey(Element signatureElement) {
        Element keyInfoElement = DomUtils.getElement(signatureElement, XMLDSigPaths.KEY_INFO_PATH);
        if (keyInfoElement != null) {
            try {
                KeyInfo keyInfo = new KeyInfo(keyInfoElement, "");
                return keyInfo.getPublicKey();
            }
            catch (XMLSecurityException e) {
                LOG.warn("Unable to extract signing certificate's public key. Reason : {}", (Object)e.getMessage(), (Object)e);
            }
        }
        LOG.warn("Unable to extract the public key. Reason : KeyInfo element is null");
        return null;
    }

    public static XAdESSignature createCounterSignature(Element counterSignatureElement, XAdESSignature masterSignature) {
        try {
            Node counterSignatureNode = DomUtils.getNode(counterSignatureElement, XMLDSigPaths.SIGNATURE_PATH);
            XAdESSignature xadesCounterSignature = new XAdESSignature((Element)counterSignatureNode, masterSignature.getXAdESPathsHolders());
            xadesCounterSignature.setSignatureFilename(masterSignature.getSignatureFilename());
            xadesCounterSignature.setDetachedContents(masterSignature.getDetachedContents());
            if (DSSXMLUtils.isCounterSignature(xadesCounterSignature)) {
                xadesCounterSignature.setMasterSignature(masterSignature);
                return xadesCounterSignature;
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred during counter signature extraction. The element entry is skipped. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            }
            LOG.warn(errorMessage, (Object)e.getMessage());
        }
        return null;
    }

    private static boolean isCounterSignature(XAdESSignature xadesCounterSignature) {
        List<Reference> references = xadesCounterSignature.getReferences();
        for (Reference reference : references) {
            if (!DSSXMLUtils.isCounterSignature(reference, xadesCounterSignature.getXAdESPaths())) continue;
            return true;
        }
        return false;
    }

    public static NodeList getAllSignaturesExceptCounterSignatures(Node documentNode) {
        return DomUtils.getNodeList(documentNode, XAdES132Paths.ALL_SIGNATURE_WITH_NO_COUNTERSIGNATURE_AS_PARENT_PATH);
    }

    public static NodeList getReferenceNodeList(Node signatureElement) {
        return DomUtils.getNodeList(signatureElement, XMLDSigPaths.SIGNED_INFO_REFERENCE_PATH);
    }

    public static ReferenceOutputType getReferenceOutputType(DSSReference reference) {
        ReferenceOutputType outputType = DSSXMLUtils.getDereferenceOutputType(reference.getUri());
        if (Utils.isCollectionNotEmpty(reference.getTransforms())) {
            for (DSSTransform transform : reference.getTransforms()) {
                String algorithmUri = transform.getAlgorithm();
                outputType = DSSXMLUtils.getTransformOutputType(algorithmUri);
            }
        }
        return outputType;
    }

    public static ReferenceOutputType getReferenceOutputType(Reference reference) throws XMLSecurityException {
        ReferenceOutputType outputType = DSSXMLUtils.getDereferenceOutputType(reference.getURI());
        Transforms transforms = reference.getTransforms();
        if (transforms != null) {
            for (int ii = 0; ii < transforms.getLength(); ++ii) {
                Transform transform = transforms.item(ii);
                outputType = DSSXMLUtils.getTransformOutputType(transform.getURI());
            }
        }
        return outputType;
    }

    private static ReferenceOutputType getDereferenceOutputType(String referenceUri) {
        return DSSXMLUtils.isSameDocumentReference(referenceUri) ? ReferenceOutputType.NODE_SET : ReferenceOutputType.OCTET_STREAM;
    }

    private static ReferenceOutputType getTransformOutputType(String algorithmUri) {
        return transformsWithNodeSetOutput.contains(algorithmUri) ? ReferenceOutputType.NODE_SET : ReferenceOutputType.OCTET_STREAM;
    }

    public static byte[] applyTransforms(Node node, List<DSSTransform> transforms) {
        Node nodeToTransform = node;
        if (Utils.isCollectionNotEmpty(transforms)) {
            byte[] transformedReferenceBytes = null;
            Iterator<DSSTransform> iterator = transforms.iterator();
            while (iterator.hasNext()) {
                DSSTransform transform = iterator.next();
                transformedReferenceBytes = transform.getBytesAfterTransformation(nodeToTransform);
                if (!iterator.hasNext()) continue;
                if (Utils.isArrayEmpty(transformedReferenceBytes)) {
                    throw new IllegalInputException(String.format("Unable to perform the next transform. The %s produced an empty output!", transform));
                }
                nodeToTransform = DomUtils.buildDOM(transformedReferenceBytes);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reference bytes after transforms: ");
                LOG.debug(new String(transformedReferenceBytes));
            }
            if (Utils.isArrayEmpty(transformedReferenceBytes)) {
                LOG.warn("The output of reference transforms processing is an empty byte array!");
            }
            return transformedReferenceBytes;
        }
        return DSSXMLUtils.getNodeBytes(nodeToTransform);
    }

    public static byte[] applyTransforms(DSSDocument document, List<DSSTransform> transforms) {
        return DSSXMLUtils.applyTransforms(DomUtils.buildDOM(document), transforms);
    }

    public static List<DigestAlgorithm> getReferenceDigestAlgos(Element referenceContainer) {
        ArrayList<DigestAlgorithm> digestAlgorithms = new ArrayList<DigestAlgorithm>();
        NodeList referenceNodeList = DomUtils.getNodeList(referenceContainer, XMLDSigPaths.REFERENCE_PATH);
        for (int ii = 0; ii < referenceNodeList.getLength(); ++ii) {
            Element referenceElement = (Element)referenceNodeList.item(ii);
            Digest digest = DSSXMLUtils.getDigestAndValue(referenceElement);
            if (digest == null) continue;
            digestAlgorithms.add(digest.getAlgorithm());
        }
        return digestAlgorithms;
    }

    public static List<String> getReferenceTypes(Element referenceContainer) {
        ArrayList<String> referenceTypes = new ArrayList<String>();
        NodeList referenceNodeList = DomUtils.getNodeList(referenceContainer, XMLDSigPaths.REFERENCE_PATH);
        for (int ii = 0; ii < referenceNodeList.getLength(); ++ii) {
            Element referenceElement = (Element)referenceNodeList.item(ii);
            String type = referenceElement.getAttribute(XMLDSigAttribute.TYPE.getAttributeName());
            if (!Utils.isStringNotEmpty(type)) continue;
            referenceTypes.add(type);
        }
        return referenceTypes;
    }

    public static List<Reference> extractReferences(Manifest manifest) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        int numberOfReferences = manifest.getLength();
        for (int ii = 0; ii < numberOfReferences; ++ii) {
            try {
                Reference reference = manifest.item(ii);
                references.add(reference);
                continue;
            }
            catch (XMLSecurityException e) {
                LOG.warn("Unable to retrieve reference #{} : {}", (Object)ii, (Object)e.getMessage());
            }
        }
        return references;
    }

    public static Digest getReferenceDigest(Reference reference) {
        try {
            Digest digest = new Digest();
            digest.setValue(reference.getDigestValue());
            digest.setAlgorithm(DigestAlgorithm.forXML(reference.getMessageDigestAlgorithm().getAlgorithmURI()));
            return digest;
        }
        catch (XMLSecurityException e) {
            LOG.warn("Unable to extract Digest from a reference with Id [{}] : {}", reference.getId(), e.getMessage(), e);
            return null;
        }
    }

    public static String getReferenceURI(Reference reference) {
        Element element;
        if (reference != null && (element = reference.getElement()) != null) {
            return DSSXMLUtils.getAttribute(element, XMLDSigAttribute.URI.getAttributeName());
        }
        return null;
    }

    public static boolean isAbleToDeReferenceContent(Reference reference) {
        try {
            return reference.getContentsBeforeTransformation() != null;
        }
        catch (ReferenceNotInitializedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Cannot get the pointed bytes by a reference with uri='%s'. Reason : [%s]", reference.getURI(), e.getMessage()));
            }
            return false;
        }
    }

    public static boolean isReferencedContentAmbiguous(Document document, String uri) {
        if (Utils.isStringNotEmpty(uri)) {
            return !XMLUtils.protectAgainstWrappingAttack(document, DomUtils.getId(uri));
        }
        return false;
    }

    public static void incorporateTransforms(Element parentElement, List<DSSTransform> transforms, DSSNamespace namespace) {
        if (Utils.isCollectionNotEmpty(transforms)) {
            Document documentDom = parentElement.getOwnerDocument();
            Element transformsDom = DomUtils.createElementNS(documentDom, namespace, XMLDSigElement.TRANSFORMS);
            parentElement.appendChild(transformsDom);
            for (DSSTransform dssTransform : transforms) {
                dssTransform.createTransform(documentDom, transformsDom);
            }
        }
    }

    public static void incorporateDigestMethod(Element parentElement, DigestAlgorithm digestAlgorithm, DSSNamespace namespace) {
        Document documentDom = parentElement.getOwnerDocument();
        Element digestMethodDom = DomUtils.addElement(documentDom, parentElement, namespace, XMLDSigElement.DIGEST_METHOD);
        digestMethodDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), digestAlgorithm.getUri());
    }

    public static void incorporateDigestValue(Element parentDom, String base64EncodedDigestBytes, DSSNamespace namespace) {
        Document documentDom = parentDom.getOwnerDocument();
        Element digestValueDom = DomUtils.createElementNS(documentDom, namespace, XMLDSigElement.DIGEST_VALUE);
        Text textNode = documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        parentDom.appendChild(digestValueDom);
    }

    static {
        SantuarioInitializer.init();
        transforms = new HashSet<String>();
        DSSXMLUtils.registerDefaultTransforms();
        canonicalizers = new HashSet<String>();
        DSSXMLUtils.registerDefaultCanonicalizers();
        transformsWithNodeSetOutput = new HashSet<String>();
        DSSXMLUtils.registerTransformsWithNodeSetOutput();
    }
}

