/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.dto.parameters;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampContainerForm;
import java.io.Serializable;
import java.util.Objects;

public class RemoteTimestampParameters
implements Serializable {
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA256;
    private String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private TimestampContainerForm timestampContainerForm;

    public RemoteTimestampParameters() {
    }

    public RemoteTimestampParameters(TimestampContainerForm timestampForm, DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        this.timestampContainerForm = timestampForm;
    }

    public RemoteTimestampParameters(TimestampContainerForm timestampForm, DigestAlgorithm digestAlgorithm, String canonicalizationMethod) {
        this(timestampForm, digestAlgorithm);
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "digestAlgorithm must be specified!");
        this.digestAlgorithm = digestAlgorithm;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public TimestampContainerForm getTimestampContainerForm() {
        return this.timestampContainerForm;
    }

    public void setTimestampContainerForm(TimestampContainerForm timestampForm) {
        this.timestampContainerForm = timestampForm;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.digestAlgorithm == null ? 0 : this.digestAlgorithm.hashCode());
        result = 31 * result + (this.timestampContainerForm == null ? 0 : this.timestampContainerForm.hashCode());
        result = 31 * result + (this.canonicalizationMethod == null ? 0 : this.canonicalizationMethod.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteTimestampParameters other = (RemoteTimestampParameters)obj;
        if (this.canonicalizationMethod == null ? other.canonicalizationMethod != null : !this.canonicalizationMethod.equals(other.canonicalizationMethod)) {
            return false;
        }
        if (this.digestAlgorithm != other.digestAlgorithm) {
            return false;
        }
        return !(this.timestampContainerForm == null ? other.timestampContainerForm != null : this.timestampContainerForm != other.timestampContainerForm);
    }

    public String toString() {
        return "RemoteTimestampParameters{digestAlgorithm='" + this.digestAlgorithm + "', canonicalizationMethod='" + this.canonicalizationMethod + "', timestampContainerForm=" + (Object)((Object)this.timestampContainerForm) + '}';
    }
}

