/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteCertificateConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.signature.common.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.ws.signature.common.RemoteTrustedListSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteTrustedListSignatureParameters;
import eu.europa.esig.dss.xades.TrustedListSignatureParametersBuilder;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTrustedListSignatureServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteTrustedListSignatureService {
    private static final long serialVersionUID = 1029264702356172700L;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteTrustedListSignatureServiceImpl.class);
    private XAdESService xadesService;

    public void setXadesService(XAdESService xadesService) {
        this.xadesService = xadesService;
    }

    @Override
    public ToBeSignedDTO getDataToSign(RemoteDocument trustedList, RemoteTrustedListSignatureParameters parameters) throws DSSException {
        Objects.requireNonNull(this.xadesService, "XAdESService must be defined!");
        Objects.requireNonNull(trustedList, "Trusted List must be defined!");
        Objects.requireNonNull(parameters, "Parameters must be defined!");
        Objects.requireNonNull(parameters.getSigningCertificate(), "Signing Certificate must be defined!");
        LOG.info("GetDataToSign in process...");
        DSSDocument tlDocument = RemoteDocumentConverter.toDSSDocument(trustedList);
        XAdESSignatureParameters signatureParameters = this.createParameters(tlDocument, parameters);
        ToBeSigned dataToSign = this.xadesService.getDataToSign(tlDocument, signatureParameters);
        LOG.info("GetDataToSign is finished");
        return DTOConverter.toToBeSignedDTO(dataToSign);
    }

    @Override
    public RemoteDocument signDocument(RemoteDocument trustedList, RemoteTrustedListSignatureParameters parameters, SignatureValueDTO signatureValue) throws DSSException {
        Objects.requireNonNull(this.xadesService, "XAdESService must be defined!");
        Objects.requireNonNull(trustedList, "Trusted List must be defined!");
        Objects.requireNonNull(parameters, "Parameters must be defined!");
        Objects.requireNonNull(parameters.getSigningCertificate(), "Signing Certificate must be defined!");
        Objects.requireNonNull(signatureValue, "Signature Value must be defined!");
        LOG.info("SignDocument in process...");
        DSSDocument tlDocument = RemoteDocumentConverter.toDSSDocument(trustedList);
        XAdESSignatureParameters signatureParameters = this.createParameters(tlDocument, parameters);
        DSSDocument signDocument = this.xadesService.signDocument(tlDocument, signatureParameters, this.toSignatureValue(signatureValue));
        LOG.info("SignDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(signDocument);
    }

    private XAdESSignatureParameters createParameters(DSSDocument tlDocument, RemoteTrustedListSignatureParameters parameters) {
        CertificateToken certificateToken = RemoteCertificateConverter.toCertificateToken(parameters.getSigningCertificate());
        TrustedListSignatureParametersBuilder tlParametersBuilder = new TrustedListSignatureParametersBuilder(certificateToken, tlDocument);
        if (parameters.getBLevelParameters() != null) {
            tlParametersBuilder.setBLevelParams(this.toBLevelParameters(parameters.getBLevelParameters()));
        }
        if (parameters.getReferenceId() != null) {
            tlParametersBuilder.setReferenceId(parameters.getReferenceId());
        }
        if (parameters.getReferenceDigestAlgorithm() != null) {
            tlParametersBuilder.setReferenceDigestAlgorithm(parameters.getReferenceDigestAlgorithm());
        }
        return tlParametersBuilder.build();
    }
}

