/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.scope;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.validation.scope.SignatureScopeWithTransformations;
import java.util.List;

public class ManifestEntrySignatureScope
extends SignatureScopeWithTransformations {
    private static final long serialVersionUID = 8764813918985821868L;
    private final String manifestName;

    public ManifestEntrySignatureScope(String entryName, Digest digest, String manifestName, List<String> transformations) {
        super(entryName, digest, transformations);
        this.manifestName = manifestName;
    }

    @Override
    public String getDescription() {
        String description = DomUtils.isElementReference(this.getName()) ? String.format("The XML Manifest Entry with ID '%s' from a Manifest with name '%s'", this.getName(), this.manifestName) : String.format("The File Manifest Entry with name '%s' from a Manifest with name '%s'", this.getName(), this.manifestName);
        return this.addTransformationIfNeeded(description);
    }

    @Override
    public SignatureScopeType getType() {
        return SignatureScopeType.FULL;
    }
}

