/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.scope;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.OriginalIdentifierProvider;
import eu.europa.esig.dss.validation.TokenIdentifierProvider;

public abstract class AbstractSignatureScopeFinder {
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    private TokenIdentifierProvider tokenIdentifierProvider = new OriginalIdentifierProvider();

    protected AbstractSignatureScopeFinder() {
    }

    protected DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }

    public void setDefaultDigestAlgorithm(DigestAlgorithm defaultDigestAlgorithm) {
        this.defaultDigestAlgorithm = defaultDigestAlgorithm;
    }

    protected TokenIdentifierProvider getTokenIdentifierProvider() {
        return this.tokenIdentifierProvider;
    }

    public void setTokenIdentifierProvider(TokenIdentifierProvider tokenIdentifierProvider) {
        this.tokenIdentifierProvider = tokenIdentifierProvider;
    }

    protected Digest getDigest(DSSDocument document) {
        return new Digest(this.defaultDigestAlgorithm, Utils.fromBase64(document.getDigest(this.defaultDigestAlgorithm)));
    }

    protected Digest getDigest(byte[] dataBytes) {
        return new Digest(this.defaultDigestAlgorithm, DSSUtils.digest(this.defaultDigestAlgorithm, dataBytes));
    }

    protected boolean isASiCSArchive(AdvancedSignature advancedSignature) {
        return Utils.isCollectionNotEmpty(advancedSignature.getContainerContents());
    }

    protected boolean isASiCEArchive(AdvancedSignature advancedSignature) {
        return advancedSignature.getManifestFile() != null;
    }
}

