/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.AdditionalServiceInformation;
import eu.europa.esig.dss.enumerations.CertificateType;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.AbstractTrustedServiceFilter;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;

public class ServiceByCertificateTypeFilter
extends AbstractTrustedServiceFilter {
    private final CertificateWrapper certificate;

    public ServiceByCertificateTypeFilter(CertificateWrapper certificate) {
        this.certificate = certificate;
    }

    @Override
    boolean isAcceptable(TrustedServiceWrapper service) {
        Date issuance = this.certificate.getNotBefore();
        if (EIDASUtils.isPostEIDAS(issuance)) {
            List<String> additionalServiceInfos = service.getAdditionalServiceInfos();
            boolean asiEsign = AdditionalServiceInformation.isForeSignatures(additionalServiceInfos);
            boolean asiEseals = AdditionalServiceInformation.isForeSeals(additionalServiceInfos);
            boolean asiWsa = AdditionalServiceInformation.isForWebAuth(additionalServiceInfos);
            List<String> capturedQualifiers = service.getCapturedQualifiers();
            boolean qcForEsign = ServiceQualification.isQcForEsig(capturedQualifiers);
            boolean qcForEseals = ServiceQualification.isQcForEseal(capturedQualifiers);
            boolean qcForWSA = ServiceQualification.isQcForWSA(capturedQualifiers);
            qcForEsign = qcForEsign || !qcForEseals && !qcForWSA && this.certificate.isQcCompliance();
            boolean onlyOneQcForXXX = Stream.of(qcForEsign, qcForEseals, qcForWSA).filter((? super T b) -> b).count() == 1L;
            TypeStrategy strategy = TypeStrategyFactory.createTypeFromCert(this.certificate);
            CertificateType certType = strategy.getType();
            boolean overruleForEsign = asiEsign && qcForEsign && onlyOneQcForXXX;
            boolean overruleForEseals = asiEseals && qcForEseals && onlyOneQcForXXX;
            boolean overruleForWSA = asiWsa && qcForWSA && onlyOneQcForXXX;
            switch (certType) {
                case ESIGN: {
                    return asiEsign || overruleForEseals || overruleForWSA;
                }
                case ESEAL: {
                    return asiEseals || overruleForEsign || overruleForWSA;
                }
                case WSA: {
                    return asiWsa || overruleForEseals || overruleForEsign;
                }
                case UNKNOWN: {
                    return true;
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported CertificateType : %s", new Object[]{certType}));
        }
        return true;
    }
}

