/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.enumerations.QSCDStatus;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import java.util.List;

class QSCDByTL
implements QSCDStrategy {
    private final TrustedServiceWrapper trustedService;
    private final CertificateQualifiedStatus qualified;
    private final QSCDStrategy qscdFromCertificate;

    public QSCDByTL(TrustedServiceWrapper trustedService, CertificateQualifiedStatus qualified, QSCDStrategy qscdFromCertificate) {
        this.trustedService = trustedService;
        this.qualified = qualified;
        this.qscdFromCertificate = qscdFromCertificate;
    }

    @Override
    public QSCDStatus getQSCDStatus() {
        if (this.trustedService == null || !CertificateQualifiedStatus.isQC(this.qualified)) {
            return QSCDStatus.NOT_QSCD;
        }
        List<String> capturedQualifiers = this.trustedService.getCapturedQualifiers();
        if (Utils.isCollectionNotEmpty(capturedQualifiers)) {
            if (EIDASUtils.isPostEIDAS(this.trustedService.getStartDate())) {
                if (ServiceQualification.isQcWithQSCD(capturedQualifiers) || ServiceQualification.isQcQSCDManagedOnBehalf(capturedQualifiers)) {
                    return QSCDStatus.QSCD;
                }
                if (ServiceQualification.isQcQSCDStatusAsInCert(capturedQualifiers)) {
                    return this.qscdFromCertificate.getQSCDStatus();
                }
                if (ServiceQualification.isQcNoQSCD(capturedQualifiers)) {
                    return QSCDStatus.NOT_QSCD;
                }
            } else {
                if (ServiceQualification.isQcWithSSCD(capturedQualifiers)) {
                    return QSCDStatus.QSCD;
                }
                if (ServiceQualification.isQcSSCDStatusAsInCert(capturedQualifiers)) {
                    return this.qscdFromCertificate.getQSCDStatus();
                }
                if (ServiceQualification.isQcNoSSCD(capturedQualifiers)) {
                    return QSCDStatus.NOT_QSCD;
                }
            }
        }
        return this.qscdFromCertificate.getQSCDStatus();
    }
}

