/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rac;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.SignatureIntactCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.SignatureIntactWithIdCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.ProspectiveCertificateChainCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.crs.CertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationCertHashMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationCertHashPresenceCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationConsistentCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationDataKnownCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationIssuerRevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.SelfIssuedOCSPCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateRevocationSelectorResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.IdPkixOcspNoCheck;
import java.util.Date;
import java.util.Set;

public class RevocationAcceptanceChecker
extends Chain<XmlRAC> {
    private final CertificateWrapper certificate;
    private final CertificateRevocationWrapper revocationData;
    private final Date controlTime;
    private final ValidationPolicy policy;
    private final Set<String> validatedTokens;

    public RevocationAcceptanceChecker(I18nProvider i18nProvider, CertificateWrapper certificate, CertificateRevocationWrapper revocationData, Date controlTime, ValidationPolicy policy, Set<String> validatedTokens) {
        super(i18nProvider, new XmlRAC());
        this.certificate = certificate;
        this.revocationData = revocationData;
        this.controlTime = controlTime;
        this.policy = policy;
        this.validatedTokens = validatedTokens;
        ((XmlRAC)this.result).setId(revocationData.getId());
        ((XmlRAC)this.result).setRevocationThisUpdate(revocationData.getThisUpdate());
        ((XmlRAC)this.result).setRevocationProductionDate(revocationData.getProductionDate());
        this.validatedTokens.add(certificate.getId());
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.RAC;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlRAC> item = this.firstItem = this.revocationDataKnown();
        if (RevocationType.OCSP.equals((Object)this.revocationData.getRevocationType())) {
            item = item.setNextItem(this.revocationCertHashPresent());
            if (this.revocationData.isCertHashExtensionPresent()) {
                item = item.setNextItem(this.revocationCertHashMatch());
            }
            item = item.setNextItem(this.selfIssuedOcsp());
        }
        item = item.setNextItem(this.revocationDataConsistent());
        item = item.setNextItem(this.revocationDataIntact());
        item = item.setNextItem(this.prospectiveCertificateChain(this.revocationData.getSigningCertificate()));
        for (CertificateWrapper revocationCertificate : this.revocationData.getCertificateChain()) {
            if (revocationCertificate.isTrusted()) break;
            if (this.isTokenValidated(revocationCertificate)) continue;
            item = item.setNextItem(this.certificateIntact(revocationCertificate));
            if (revocationCertificate.isSelfSigned()) {
                item = item.setNextItem(this.selfSigned(revocationCertificate));
            }
            if (revocationCertificate.isIdPkixOcspNoCheck()) {
                item = item.setNextItem(this.idPkixOcspNoCheck(revocationCertificate));
            }
            if (!ValidationProcessUtils.isRevocationCheckRequired(revocationCertificate)) continue;
            SubContext subContext = this.revocationData.getSigningCertificate().getId().equals(revocationCertificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            item = item.setNextItem(this.revocationDataPresentForRevocationChain(revocationCertificate, subContext));
            if (!Utils.isCollectionNotEmpty(revocationCertificate.getCertificateRevocationData())) continue;
            CertificateRevocationSelector certificateRevocationSelector = new CertificateRevocationSelector(this.i18nProvider, revocationCertificate, this.controlTime, this.policy, this.validatedTokens);
            XmlCRS xmlCRS = (XmlCRS)certificateRevocationSelector.execute();
            ((XmlRAC)this.result).setCRS(xmlCRS);
            item = item.setNextItem(this.checkCertificateRevocationSelectorResult(xmlCRS, subContext));
        }
    }

    private ChainItem<XmlRAC> revocationDataKnown() {
        return new RevocationDataKnownCheck(this.i18nProvider, (XmlRAC)this.result, this.revocationData, this.policy.getUnknownStatusConstraint());
    }

    private ChainItem<XmlRAC> revocationCertHashPresent() {
        LevelConstraint constraint = this.policy.getOCSPResponseCertHashPresentConstraint();
        return new RevocationCertHashPresenceCheck(this.i18nProvider, (XmlRAC)this.result, this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> revocationCertHashMatch() {
        LevelConstraint constraint = this.policy.getOCSPResponseCertHashMatchConstraint();
        return new RevocationCertHashMatchCheck(this.i18nProvider, (XmlRAC)this.result, this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> selfIssuedOcsp() {
        LevelConstraint constraint = this.policy.getSelfIssuedOCSPConstraint();
        return new SelfIssuedOCSPCheck(this.i18nProvider, (XmlRAC)this.result, this.certificate, this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> revocationDataConsistent() {
        return new RevocationConsistentCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, this.certificate, this.revocationData, this.getFailLevelConstraint());
    }

    private ChainItem<XmlRAC> revocationDataIntact() {
        LevelConstraint constraint = this.policy.getSignatureIntactConstraint(Context.REVOCATION);
        return new SignatureIntactCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, this.revocationData, Context.REVOCATION, constraint);
    }

    private ChainItem<XmlRAC> prospectiveCertificateChain(CertificateWrapper signingCertificate) {
        LevelConstraint constraint = this.policy.getProspectiveCertificateChainConstraint(Context.REVOCATION);
        return new ProspectiveCertificateChainCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, signingCertificate, Context.REVOCATION, constraint);
    }

    private boolean isTokenValidated(TokenProxy token) {
        boolean validated = this.validatedTokens.contains(token.getId());
        this.validatedTokens.add(token.getId());
        return validated;
    }

    private ChainItem<XmlRAC> certificateIntact(CertificateWrapper certificate) {
        LevelConstraint constraint = this.policy.getSignatureIntactConstraint(Context.CERTIFICATE);
        return new SignatureIntactWithIdCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, certificate, Context.CERTIFICATE, constraint);
    }

    private ChainItem<XmlRAC> selfSigned(CertificateWrapper certificate) {
        return new CertificateSelfSignedCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, certificate, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlRAC> idPkixOcspNoCheck(CertificateWrapper certificateWrapper) {
        return new IdPkixOcspNoCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, certificateWrapper, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlRAC> revocationDataPresentForRevocationChain(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.policy.getRevocationDataAvailableConstraint(Context.REVOCATION, subContext);
        return new RevocationIssuerRevocationDataAvailableCheck(this.i18nProvider, (XmlRAC)this.result, certificate, constraint);
    }

    private ChainItem<XmlRAC> checkCertificateRevocationSelectorResult(XmlCRS crsResult, SubContext subContext) {
        LevelConstraint constraint = this.policy.getAcceptableRevocationDataFoundConstraint(Context.REVOCATION, subContext);
        return new CertificateRevocationSelectorResultCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, crsResult, constraint);
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        super.collectAdditionalMessages(conclusion);
        XmlCRS crs = ((XmlRAC)this.result).getCRS();
        if (crs != null) {
            super.collectAllMessages(conclusion, crs.getConclusion());
        }
    }
}

