/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;

public class MessageDigestOrSignedPropertiesCheck
extends ChainItem<XmlSAV> {
    private final SignatureWrapper signature;

    public MessageDigestOrSignedPropertiesCheck(I18nProvider i18nProvider, XmlSAV result, SignatureWrapper signature, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        switch (this.signature.getSignatureFormat().getSignatureForm()) {
            case XAdES: {
                return this.isRequiredDigestMatcherPresent(DigestMatcherType.SIGNED_PROPERTIES);
            }
            case CAdES: 
            case PAdES: 
            case PKCS7: {
                return this.isRequiredDigestMatcherPresent(DigestMatcherType.MESSAGE_DIGEST);
            }
        }
        return false;
    }

    private boolean isRequiredDigestMatcherPresent(DigestMatcherType digestMatcherType) {
        List<XmlDigestMatcher> digestMatchers = this.signature.getDigestMatchers();
        if (Utils.isCollectionNotEmpty(digestMatchers)) {
            for (XmlDigestMatcher digestMatcher : digestMatchers) {
                if (!digestMatcherType.equals((Object)digestMatcher.getType())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_ISQPMDOSPP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_ISQPMDOSPP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

