/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;

public abstract class AbstractCryptographicCheck
extends ChainItem<XmlCC> {
    protected final MessageTag position;
    protected final CryptographicConstraintWrapper constraintWrapper;

    protected AbstractCryptographicCheck(I18nProvider i18nProvider, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, constraintWrapper.getConstraint());
        this.position = position;
        this.constraintWrapper = constraintWrapper;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE;
    }

    protected String getName(DigestAlgorithm digestAlgorithm) {
        return digestAlgorithm != null ? digestAlgorithm.getName() : "?";
    }

    protected String getName(EncryptionAlgorithm encryptionAlgorithm) {
        return encryptionAlgorithm != null ? encryptionAlgorithm.getName() : "?";
    }
}

