/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class EllipticCurveKeySizeCheck
extends ChainItem<XmlFC> {
    private final SignatureWrapper signature;

    public EllipticCurveKeySizeCheck(I18nProvider i18nProvider, XmlFC result, SignatureWrapper signature, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        if (!(this.isEncryptionAlgorithmKnown() && this.isDigestAlgorithmKnown() && this.isKeySizeKnown())) {
            return false;
        }
        return !this.signature.getEncryptionAlgorithm().isEquivalent(EncryptionAlgorithm.ECDSA) || this.isDigestAlgorithmAuthorized() && this.keySizeCorrespondsDigestAlgorithm();
    }

    private boolean isEncryptionAlgorithmKnown() {
        return this.signature.getEncryptionAlgorithm() != null;
    }

    private boolean isDigestAlgorithmKnown() {
        return this.signature.getDigestAlgorithm() != null;
    }

    private boolean isKeySizeKnown() {
        return this.signature.getKeyLengthUsedToSignThisToken() != null;
    }

    private boolean isDigestAlgorithmAuthorized() {
        switch (this.signature.getDigestAlgorithm()) {
            case SHA256: 
            case SHA384: 
            case SHA512: {
                return true;
            }
        }
        return false;
    }

    private boolean keySizeCorrespondsDigestAlgorithm() {
        String correspondingKeySize = this.getCorrespondingKeySize(this.signature.getDigestAlgorithm());
        return correspondingKeySize != null && correspondingKeySize.equals(this.signature.getKeyLengthUsedToSignThisToken());
    }

    private String getCorrespondingKeySize(DigestAlgorithm digestAlgorithm) {
        switch (digestAlgorithm) {
            case SHA256: {
                return "256";
            }
            case SHA384: {
                return "384";
            }
            case SHA512: {
                return "521";
            }
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_IECKSCDA;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        if (!this.isEncryptionAlgorithmKnown()) {
            return MessageTag.BBB_FC_IECKSCDA_ANS1;
        }
        if (!this.isDigestAlgorithmKnown()) {
            return MessageTag.BBB_FC_IECKSCDA_ANS2;
        }
        if (!this.isKeySizeKnown()) {
            return MessageTag.BBB_FC_IECKSCDA_ANS3;
        }
        if (!this.isDigestAlgorithmAuthorized()) {
            return MessageTag.BBB_FC_IECKSCDA_ANS4;
        }
        if (!this.keySizeCorrespondsDigestAlgorithm()) {
            return MessageTag.BBB_FC_IECKSCDA_ANS5;
        }
        return null;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.isEncryptionAlgorithmKnown() && this.isDigestAlgorithmKnown() && this.isKeySizeKnown()) {
            return this.i18nProvider.getMessage(MessageTag.SIGNATURE_ALGORITHM_WITH_KEY_SIZE, this.signature.getSignatureAlgorithm().getName(), this.signature.getKeyLengthUsedToSignThisToken());
        }
        return null;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

