/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.cv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;

public class ReferenceDataExistenceCheck
extends ChainItem<XmlCV> {
    private final XmlDigestMatcher digestMatcher;

    public ReferenceDataExistenceCheck(I18nProvider i18nProvider, XmlCV result, XmlDigestMatcher digestMatcher, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.digestMatcher = digestMatcher;
    }

    @Override
    protected boolean process() {
        return this.digestMatcher.isDataFound();
    }

    @Override
    protected MessageTag getMessageTag() {
        switch (this.digestMatcher.getType()) {
            case MESSAGE_IMPRINT: {
                return MessageTag.BBB_CV_TSP_IRDOF;
            }
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return MessageTag.BBB_CV_CS_CSSVF;
            }
        }
        return MessageTag.BBB_CV_IRDOF;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        switch (this.digestMatcher.getType()) {
            case MESSAGE_IMPRINT: {
                return MessageTag.BBB_CV_TSP_IRDOF_ANS;
            }
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return MessageTag.BBB_CV_CS_CSSVF_ANS;
            }
        }
        return MessageTag.BBB_CV_IRDOF_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIGNED_DATA_NOT_FOUND;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (!DigestMatcherType.MESSAGE_IMPRINT.equals((Object)this.digestMatcher.getType())) {
            String referenceName = Utils.isStringNotBlank(this.digestMatcher.getName()) ? this.digestMatcher.getName() : this.digestMatcher.getType().name();
            return this.i18nProvider.getMessage(MessageTag.REFERENCE, referenceName);
        }
        return null;
    }
}

