/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.policy;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.policy.AbstractSignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidationResult;

public class NonASN1SignaturePolicyValidator
extends AbstractSignaturePolicyValidator {
    @Override
    public boolean canValidate(SignaturePolicy signaturePolicy) {
        DSSDocument policyContent = signaturePolicy.getPolicyContent();
        if (policyContent != null) {
            byte firstByte = DSSUtils.readFirstByte(policyContent);
            return !DSSASN1Utils.isASN1SequenceTag(firstByte) && !DomUtils.startsWithXmlPreamble(policyContent);
        }
        return false;
    }

    @Override
    public SignaturePolicyValidationResult validate(SignaturePolicy signaturePolicy) {
        SignaturePolicyValidationResult validationResult = new SignaturePolicyValidationResult();
        DSSDocument policyContent = signaturePolicy.getPolicyContent();
        if (policyContent == null) {
            validationResult.addError("general", "The signature policy content is not obtained.");
            return validationResult;
        }
        validationResult.setIdentified(true);
        Digest digest = signaturePolicy.getDigest();
        if (digest == null) {
            validationResult.addError("general", "The policy digest value is not defined.");
            return validationResult;
        }
        validationResult.setDigestAlgorithmsEqual(true);
        Digest recalculatedDigest = this.getComputedDigest(signaturePolicy.getPolicyContent(), digest.getAlgorithm());
        validationResult.setDigest(recalculatedDigest);
        if (digest.equals(recalculatedDigest)) {
            validationResult.setDigestValid(true);
            validationResult.setDigestAlgorithmsEqual(true);
        } else {
            validationResult.addError("general", "The policy digest value (" + Utils.toBase64(digest.getValue()) + ") does not match the re-calculated digest value (" + Utils.toBase64(recalculatedDigest.getValue()) + ").");
        }
        return validationResult;
    }
}

