/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.policy.ValidationPolicy;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;

public abstract class AbstractProcessExecutor {
    protected Date currentTime = new Date();
    protected ValidationPolicy policy;
    protected XmlDiagnosticData jaxbDiagnosticData;
    private I18nProvider i18nProvider;

    protected AbstractProcessExecutor() {
    }

    public void setCurrentTime(Date currentTime) {
        this.currentTime = currentTime;
    }

    public Date getCurrentTime() {
        return this.currentTime;
    }

    public void setDiagnosticData(XmlDiagnosticData diagnosticData) {
        this.jaxbDiagnosticData = diagnosticData;
    }

    public ValidationPolicy getValidationPolicy() {
        return this.policy;
    }

    public void setValidationPolicy(ValidationPolicy validationPolicy) {
        this.policy = validationPolicy;
    }

    public void setLocale(Locale locale) {
        Objects.requireNonNull(locale, "Locale cannot be null!");
        this.i18nProvider = new I18nProvider(locale);
    }

    protected I18nProvider getI18nProvider() {
        if (this.i18nProvider == null) {
            this.i18nProvider = new I18nProvider(Locale.getDefault());
        }
        return this.i18nProvider;
    }

    protected void assertConfigurationValid() {
        Objects.requireNonNull(this.jaxbDiagnosticData, "The diagnostic data is missing");
        Objects.requireNonNull(this.policy, "The validation policy is missing");
        Objects.requireNonNull(this.currentTime, "The current time is missing");
    }
}

