/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ManifestFile
implements Serializable {
    private static final long serialVersionUID = -5971045309587760817L;
    private DSSDocument document;
    private String signatureFilename;
    private List<ManifestEntry> entries;
    private boolean timestampManifest;
    private boolean archiveManifest;

    public DSSDocument getDocument() {
        return this.document;
    }

    public void setDocument(DSSDocument document) {
        this.document = document;
    }

    public String getFilename() {
        return this.document.getName();
    }

    public String getSignatureFilename() {
        return this.signatureFilename;
    }

    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    public String getDigestBase64String(DigestAlgorithm digestAlgorithm) {
        return this.document.getDigest(digestAlgorithm);
    }

    public List<ManifestEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<ManifestEntry>();
        }
        return this.entries;
    }

    public void setEntries(List<ManifestEntry> entries) {
        this.entries = entries;
    }

    public boolean isTimestampManifest() {
        return this.timestampManifest;
    }

    public void setTimestampManifest(boolean timestampManifest) {
        this.timestampManifest = timestampManifest;
    }

    public boolean isArchiveManifest() {
        return this.archiveManifest;
    }

    public void setArchiveManifest(boolean archiveManifest) {
        this.archiveManifest = archiveManifest;
    }

    public ManifestEntry getRootFile() {
        for (ManifestEntry entry : this.getEntries()) {
            if (!entry.isRootfile()) continue;
            return entry;
        }
        return null;
    }

    public boolean isDocumentCovered(String documentName) {
        if (Utils.isStringNotBlank(documentName)) {
            for (ManifestEntry entry : this.getEntries()) {
                if (!documentName.equals(entry.getFileName())) continue;
                return true;
            }
        }
        return false;
    }
}

