/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.alert.ExceptionOnStatusAlert;
import eu.europa.esig.dss.alert.LogOnStatusAlert;
import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.aia.AIASource;
import eu.europa.esig.dss.spi.x509.aia.DefaultAIASource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.OCSPFirstRevocationDataLoadingStrategyFactory;
import eu.europa.esig.dss.validation.RevocationDataLoadingStrategyFactory;
import eu.europa.esig.dss.validation.RevocationDataVerifier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class CommonCertificateVerifier
implements CertificateVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCertificateVerifier.class);
    private ListCertificateSource trustedCertSources = new ListCertificateSource();
    private ListCertificateSource adjunctCertSources = new ListCertificateSource();
    private RevocationSource<OCSP> ocspSource;
    private RevocationSource<CRL> crlSource;
    private RevocationDataLoadingStrategyFactory revocationDataLoadingStrategyFactory = new OCSPFirstRevocationDataLoadingStrategyFactory();
    private RevocationDataVerifier revocationDataVerifier = RevocationDataVerifier.createDefaultRevocationDataVerifier();
    private boolean revocationFallback = false;
    private AIASource aiaSource;
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    private StatusAlert alertOnInvalidTimestamp = new ExceptionOnStatusAlert();
    private StatusAlert alertOnMissingRevocationData = new ExceptionOnStatusAlert();
    private StatusAlert alertOnRevokedCertificate = new ExceptionOnStatusAlert();
    private StatusAlert alertOnNoRevocationAfterBestSignatureTime = new LogOnStatusAlert(Level.WARN);
    private StatusAlert alertOnUncoveredPOE = new LogOnStatusAlert(Level.WARN);
    private StatusAlert alertOnExpiredSignature = new ExceptionOnStatusAlert();
    private boolean checkRevocationForUntrustedChains = false;
    private boolean extractPOEFromUntrustedChains = false;

    public CommonCertificateVerifier() {
        this(false);
    }

    public CommonCertificateVerifier(boolean simpleCreationOnly) {
        LOG.info("+ New CommonCertificateVerifier created.");
        if (!simpleCreationOnly) {
            this.aiaSource = new DefaultAIASource();
        }
    }

    @Override
    public RevocationSource<CRL> getCrlSource() {
        return this.crlSource;
    }

    @Override
    public void setCrlSource(RevocationSource<CRL> crlSource) {
        this.crlSource = crlSource;
    }

    @Override
    public RevocationSource<OCSP> getOcspSource() {
        return this.ocspSource;
    }

    @Override
    public void setOcspSource(RevocationSource<OCSP> ocspSource) {
        this.ocspSource = ocspSource;
    }

    @Override
    public RevocationDataLoadingStrategyFactory getRevocationDataLoadingStrategyFactory() {
        return this.revocationDataLoadingStrategyFactory;
    }

    @Override
    public void setRevocationDataLoadingStrategyFactory(RevocationDataLoadingStrategyFactory revocationDataLoadingStrategyFactory) {
        Objects.requireNonNull(revocationDataLoadingStrategyFactory, "RevocationDataLoadingStrategyFactory shall be defined!");
        this.revocationDataLoadingStrategyFactory = revocationDataLoadingStrategyFactory;
    }

    @Override
    public RevocationDataVerifier getRevocationDataVerifier() {
        return this.revocationDataVerifier;
    }

    @Override
    public void setRevocationDataVerifier(RevocationDataVerifier revocationDataVerifier) {
        Objects.requireNonNull(revocationDataVerifier, "RevocationDataVerifier shall be defined!");
        this.revocationDataVerifier = revocationDataVerifier;
    }

    @Override
    public boolean isRevocationFallback() {
        return this.revocationFallback;
    }

    @Override
    public void setRevocationFallback(boolean revocationFallback) {
        this.revocationFallback = revocationFallback;
    }

    @Override
    public ListCertificateSource getTrustedCertSources() {
        return this.trustedCertSources;
    }

    @Override
    public void setTrustedCertSources(CertificateSource ... certSources) {
        this.trustedCertSources = new ListCertificateSource();
        this.addTrustedCertSources(certSources);
    }

    @Override
    public void addTrustedCertSources(CertificateSource ... certSources) {
        for (CertificateSource certificateSource : certSources) {
            if (!certificateSource.getCertificateSourceType().isTrusted()) {
                throw new UnsupportedOperationException(String.format("The certificateSource with type [%s] is not allowed in the trustedCertSources. Please, use CertificateSource with a type TRUSTED_STORE or TRUSTED_LIST.", new Object[]{certificateSource.getCertificateSourceType()}));
            }
            this.trustedCertSources.add(certificateSource);
        }
    }

    @Override
    public void setTrustedCertSources(ListCertificateSource trustedListCertificateSource) {
        if (trustedListCertificateSource == null) {
            this.trustedCertSources = new ListCertificateSource();
        } else if (trustedListCertificateSource.areAllCertSourcesTrusted()) {
            this.trustedCertSources = trustedListCertificateSource;
        } else {
            throw new UnsupportedOperationException("The trusted ListCertificateSource must contain only trusted sources with a type TRUSTED_STORE or TRUSTED_LIST.");
        }
    }

    @Override
    public ListCertificateSource getAdjunctCertSources() {
        return this.adjunctCertSources;
    }

    @Override
    public void setAdjunctCertSources(CertificateSource ... certSources) {
        this.adjunctCertSources = new ListCertificateSource();
        this.addAdjunctCertSources(certSources);
    }

    @Override
    public void addAdjunctCertSources(CertificateSource ... certSources) {
        for (CertificateSource certificateSource : certSources) {
            this.assertNotTrusted(certificateSource);
            this.adjunctCertSources.add(certificateSource);
        }
    }

    @Override
    public void setAdjunctCertSources(ListCertificateSource adjunctListCertificateSource) {
        if (adjunctListCertificateSource == null) {
            adjunctListCertificateSource = new ListCertificateSource();
        }
        for (CertificateSource certificateSource : adjunctListCertificateSource.getSources()) {
            this.assertNotTrusted(certificateSource);
        }
        this.adjunctCertSources = adjunctListCertificateSource;
    }

    private void assertNotTrusted(CertificateSource adjunctCertificateSource) {
        if (adjunctCertificateSource.getCertificateSourceType().isTrusted()) {
            LOG.warn("Adjunct certificate sources shouldn't be trusted. An adjunct certificate source contains missing intermediate certificates");
        }
    }

    @Override
    public AIASource getAIASource() {
        return this.aiaSource;
    }

    @Override
    public void setAIASource(AIASource aiaSource) {
        this.aiaSource = aiaSource;
    }

    @Override
    public StatusAlert getAlertOnInvalidTimestamp() {
        return this.alertOnInvalidTimestamp;
    }

    @Override
    public void setAlertOnInvalidTimestamp(StatusAlert alertOnInvalidTimestamp) {
        Objects.requireNonNull(alertOnInvalidTimestamp);
        this.alertOnInvalidTimestamp = alertOnInvalidTimestamp;
    }

    @Override
    public StatusAlert getAlertOnMissingRevocationData() {
        return this.alertOnMissingRevocationData;
    }

    @Override
    public void setAlertOnMissingRevocationData(StatusAlert alertOnMissingRevocationData) {
        Objects.requireNonNull(alertOnMissingRevocationData);
        this.alertOnMissingRevocationData = alertOnMissingRevocationData;
    }

    @Override
    public StatusAlert getAlertOnUncoveredPOE() {
        return this.alertOnUncoveredPOE;
    }

    @Override
    public void setAlertOnUncoveredPOE(StatusAlert alertOnUncoveredPOE) {
        Objects.requireNonNull(alertOnUncoveredPOE);
        this.alertOnUncoveredPOE = alertOnUncoveredPOE;
    }

    @Override
    public StatusAlert getAlertOnRevokedCertificate() {
        return this.alertOnRevokedCertificate;
    }

    @Override
    public void setAlertOnRevokedCertificate(StatusAlert alertOnRevokedCertificate) {
        Objects.requireNonNull(alertOnRevokedCertificate);
        this.alertOnRevokedCertificate = alertOnRevokedCertificate;
    }

    @Override
    public StatusAlert getAlertOnNoRevocationAfterBestSignatureTime() {
        return this.alertOnNoRevocationAfterBestSignatureTime;
    }

    @Override
    public void setAlertOnNoRevocationAfterBestSignatureTime(StatusAlert alertOnNoRevocationAfterBestSignatureTime) {
        Objects.requireNonNull(alertOnNoRevocationAfterBestSignatureTime);
        this.alertOnNoRevocationAfterBestSignatureTime = alertOnNoRevocationAfterBestSignatureTime;
    }

    @Override
    public void setAlertOnExpiredSignature(StatusAlert alertOnExpiredSignature) {
        Objects.requireNonNull(alertOnExpiredSignature);
        this.alertOnExpiredSignature = alertOnExpiredSignature;
    }

    @Override
    public StatusAlert getAlertOnExpiredSignature() {
        return this.alertOnExpiredSignature;
    }

    @Override
    public boolean isCheckRevocationForUntrustedChains() {
        return this.checkRevocationForUntrustedChains;
    }

    @Override
    public void setCheckRevocationForUntrustedChains(boolean checkRevocationForUntrustedChains) {
        this.checkRevocationForUntrustedChains = checkRevocationForUntrustedChains;
    }

    @Override
    public boolean isExtractPOEFromUntrustedChains() {
        return this.extractPOEFromUntrustedChains;
    }

    @Override
    public void setExtractPOEFromUntrustedChains(boolean extractPOEFromUntrustedChains) {
        this.extractPOEFromUntrustedChains = extractPOEFromUntrustedChains;
    }

    @Override
    public void setDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "Default DigestAlgorithm cannot be nulL!");
        this.defaultDigestAlgorithm = digestAlgorithm;
    }

    @Override
    public DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }
}

