/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CMSOCSPSource
extends OfflineOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(CMSOCSPSource.class);
    protected final transient CMSSignedData cmsSignedData;
    protected final transient AttributeTable unsignedAttributes;

    protected CMSOCSPSource(CMSSignedData cms, AttributeTable unsignedAttributes) {
        this.cmsSignedData = cms;
        this.unsignedAttributes = unsignedAttributes;
        this.appendContainedOCSPResponses();
    }

    private void appendContainedOCSPResponses() {
        this.collectFromSignedData();
        if (this.unsignedAttributes != null) {
            this.collectRevocationValues(this.unsignedAttributes, PKCSObjectIdentifiers.id_aa_ets_revocationValues, RevocationOrigin.REVOCATION_VALUES);
            this.collectRevocationRefs(this.unsignedAttributes, PKCSObjectIdentifiers.id_aa_ets_revocationRefs, RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
            this.collectRevocationRefs(this.unsignedAttributes, OID.attributeRevocationRefsOid, RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
        }
    }

    private void collectFromSignedData() {
        this.addBasicOcspRespFrom_id_ri_ocsp_response();
        this.addBasicOcspRespFrom_id_pkix_ocsp_basic();
    }

    private void addBasicOcspRespFrom_id_ri_ocsp_response() {
        Store otherRevocationInfo = this.cmsSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
        Collection otherRevocationInfoMatches = otherRevocationInfo.getMatches(null);
        for (Object object : otherRevocationInfoMatches) {
            if (object instanceof ASN1Sequence) {
                BasicOCSPResp basicOCSPResp;
                ASN1Sequence otherRevocationInfoMatch = (ASN1Sequence)object;
                if (otherRevocationInfoMatch.size() == 4) {
                    basicOCSPResp = DSSRevocationUtils.getBasicOcspResp(otherRevocationInfoMatch);
                } else {
                    OCSPResp ocspResp = DSSRevocationUtils.getOcspResp(otherRevocationInfoMatch);
                    basicOCSPResp = DSSRevocationUtils.fromRespToBasic(ocspResp);
                }
                OCSPResponseBinary ocspResponseIdentifier = OCSPResponseBinary.build(basicOCSPResp);
                ocspResponseIdentifier.setAsn1ObjectIdentifier(CMSObjectIdentifiers.id_ri_ocsp_response);
                this.addBinary(ocspResponseIdentifier, RevocationOrigin.CMS_SIGNED_DATA);
                continue;
            }
            LOG.warn("Unsupported object type for id_ri_ocsp_response (SHALL be an ASN1Sequence) : {}", (Object)object.getClass().getSimpleName());
        }
    }

    private void addBasicOcspRespFrom_id_pkix_ocsp_basic() {
        Store otherRevocationInfo = this.cmsSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        Collection otherRevocationInfoMatches = otherRevocationInfo.getMatches(null);
        for (Object object : otherRevocationInfoMatches) {
            if (object instanceof ASN1Sequence) {
                ASN1Sequence otherRevocationInfoMatch = (ASN1Sequence)object;
                BasicOCSPResp basicOCSPResp = DSSRevocationUtils.getBasicOcspResp(otherRevocationInfoMatch);
                if (basicOCSPResp != null) {
                    OCSPResponseBinary ocspResponseIdentifier = OCSPResponseBinary.build(basicOCSPResp);
                    ocspResponseIdentifier.setAsn1ObjectIdentifier(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
                    this.addBinary(ocspResponseIdentifier, RevocationOrigin.CMS_SIGNED_DATA);
                    continue;
                }
                LOG.warn("Unable to create an OCSP response from an objects. The entry is skipped.");
                continue;
            }
            LOG.warn("Unsupported object type for id_pkix_ocsp_basic (SHALL be an ASN1Sequence) : {}", (Object)object.getClass().getSimpleName());
        }
    }

    private void collectRevocationValues(AttributeTable attributes, ASN1ObjectIdentifier revocationValueAttributes, RevocationOrigin origin) {
        RevocationValues revocationValues;
        ASN1Encodable attValue = DSSASN1Utils.getAsn1Encodable(attributes, revocationValueAttributes);
        if (attValue != null && (revocationValues = DSSASN1Utils.getRevocationValues(attValue)) != null) {
            for (BasicOCSPResponse basicOCSPResponse : revocationValues.getOcspVals()) {
                BasicOCSPResp basicOCSPResp = new BasicOCSPResp(basicOCSPResponse);
                OCSPResponseBinary ocspResponseIdentifier = OCSPResponseBinary.build(basicOCSPResp);
                this.addBinary(ocspResponseIdentifier, origin);
            }
        }
    }

    private void collectRevocationRefs(AttributeTable unsignedAttributes, ASN1ObjectIdentifier revocationReferencesAttribute, RevocationRefOrigin origin) {
        Attribute attribute = unsignedAttributes.get(revocationReferencesAttribute);
        if (attribute == null) {
            return;
        }
        ASN1Set attrValues = attribute.getAttrValues();
        if (attrValues.size() <= 0) {
            return;
        }
        ASN1Encodable attrValue = attrValues.getObjectAt(0);
        ASN1Sequence completeRevocationRefs = (ASN1Sequence)attrValue;
        for (int i = 0; i < completeRevocationRefs.size(); ++i) {
            CrlOcspRef otherCertId = CrlOcspRef.getInstance(completeRevocationRefs.getObjectAt(i));
            OcspListID ocspListID = otherCertId.getOcspids();
            if (ocspListID == null) continue;
            for (OcspResponsesID ocspResponsesID : ocspListID.getOcspResponses()) {
                OCSPRef ocspRef = new OCSPRef(ocspResponsesID);
                this.addRevocationReference(ocspRef, origin);
            }
        }
    }
}

