/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.parsing.TLParsingTask;
import eu.europa.esig.dss.tsl.runnable.AbstractRunnableAnalysis;
import eu.europa.esig.dss.tsl.source.TLSource;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLAnalysis
extends AbstractRunnableAnalysis {
    private static final Logger LOG = LoggerFactory.getLogger(TLAnalysis.class);
    private final TLSource source;
    private final CacheAccessByKey cacheAccess;

    public TLAnalysis(TLSource source, CacheAccessByKey cacheAccess, DSSFileLoader dssFileLoader, CountDownLatch latch) {
        super(cacheAccess, dssFileLoader, latch);
        this.source = source;
        this.cacheAccess = cacheAccess;
    }

    @Override
    protected void doAnalyze() {
        DSSDocument document = this.download(this.source.getUrl());
        if (document != null) {
            this.trustedListParsing(document);
            this.validation(document, this.source.getCertificateSource());
        }
    }

    private void trustedListParsing(DSSDocument document) {
        if (this.cacheAccess.isParsingRefreshNeeded()) {
            try {
                LOG.debug("Parsing TL with cache key '{}'...", (Object)this.source.getCacheKey().getKey());
                TLParsingTask parsingTask = new TLParsingTask(document, this.source);
                this.cacheAccess.update(parsingTask.get());
            }
            catch (Exception e) {
                LOG.error("Cannot parse the TL with the cache key '{}' : {}", (Object)this.source.getCacheKey().getKey(), (Object)e.getMessage());
                this.cacheAccess.parsingError(e);
            }
        }
    }
}

