/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.MRA;
import eu.europa.esig.dss.spi.tsl.OtherTSLPointer;
import eu.europa.esig.dss.tsl.function.converter.DigitalIdentityListTypeConverter;
import eu.europa.esig.dss.tsl.function.converter.MRAConverter;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.mra.MutualRecognitionAgreementInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.AdditionalInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.AnyType;
import eu.europa.esig.trustedlist.jaxb.tsl.DigitalIdentityListType;
import eu.europa.esig.trustedlist.jaxb.tsl.OtherTSLPointerType;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceDigitalIdentityListType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.JAXBElement;

public class OtherTSLPointerConverter
implements Function<OtherTSLPointerType, OtherTSLPointer> {
    private boolean mraSupport;

    public OtherTSLPointerConverter(boolean mraSupport) {
        this.mraSupport = mraSupport;
    }

    @Override
    public OtherTSLPointer apply(OtherTSLPointerType original) {
        return new OtherTSLPointer(original.getTSLLocation(), Collections.unmodifiableList(this.getCertificates(original.getServiceDigitalIdentities())), this.getMRA(original.getAdditionalInformation()));
    }

    private MRA getMRA(AdditionalInformationType additionalInformation) {
        if (this.mraSupport && additionalInformation != null && Utils.isCollectionNotEmpty(additionalInformation.getTextualInformationOrOtherInformation())) {
            for (Serializable serializableObj : additionalInformation.getTextualInformationOrOtherInformation()) {
                if (!(serializableObj instanceof AnyType)) continue;
                AnyType anytype = (AnyType)serializableObj;
                List<Object> content = anytype.getContent();
                for (Object objectValue : content) {
                    JAXBElement jaxbElement;
                    if (!(objectValue instanceof JAXBElement) || !((jaxbElement = (JAXBElement)objectValue).getValue() instanceof MutualRecognitionAgreementInformationType)) continue;
                    MutualRecognitionAgreementInformationType jaxbMRA = (MutualRecognitionAgreementInformationType)jaxbElement.getValue();
                    MRAConverter converter = new MRAConverter();
                    return converter.apply(jaxbMRA);
                }
            }
        }
        return null;
    }

    private List<CertificateToken> getCertificates(ServiceDigitalIdentityListType serviceDigitalIdentities) {
        ArrayList<CertificateToken> certificates = new ArrayList<CertificateToken>();
        if (serviceDigitalIdentities != null && Utils.isCollectionNotEmpty(serviceDigitalIdentities.getServiceDigitalIdentity())) {
            DigitalIdentityListTypeConverter converter = new DigitalIdentityListTypeConverter();
            for (DigitalIdentityListType digitalIdentityList : serviceDigitalIdentities.getServiceDigitalIdentity()) {
                certificates.addAll(converter.apply(digitalIdentityList));
            }
        }
        return certificates;
    }
}

