/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto.condition;

import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.Condition;
import java.util.Objects;

public class KeyUsageCondition
implements Condition {
    private static final long serialVersionUID = -5078159553328523044L;
    private final KeyUsageBit bit;
    private final boolean value;

    public KeyUsageCondition(KeyUsageBit bit, boolean value) {
        Objects.requireNonNull(bit, "key usage");
        this.bit = bit;
        this.value = value;
    }

    public KeyUsageCondition(String usage, boolean value) {
        this(KeyUsageBit.valueOf(usage), value);
    }

    public final KeyUsageBit getBit() {
        return this.bit;
    }

    public final boolean getValue() {
        return this.value;
    }

    @Override
    public boolean check(CertificateToken certificateToken) {
        boolean keyUsage = certificateToken.checkKeyUsage(this.bit);
        return keyUsage == this.value;
    }

    @Override
    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("KeyUsageCondition: ").append(this.bit.name()).append('=').append(this.value).append('\n');
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

