/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureValidity;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSignatureIntegrityValidator;
import java.io.StringWriter;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.isismtt.ocsp.CertHash;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPToken
extends RevocationToken<OCSP> {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPToken.class);
    private final BasicOCSPResp basicOCSPResp;
    private final SingleResp latestSingleResp;
    private CertificateToken issuerCertificateToken;
    private OCSPCertificateSource certificateSource;

    public OCSPToken(BasicOCSPResp basicOCSPResp, SingleResp latestSingleResp, CertificateToken certificate, CertificateToken issuer) {
        Objects.requireNonNull(basicOCSPResp, "The OCSP Response must be defined!");
        Objects.requireNonNull(certificate, "The related certificate token cannot be null!");
        this.basicOCSPResp = basicOCSPResp;
        this.productionDate = basicOCSPResp.getProducedAt();
        this.relatedCertificate = certificate;
        this.latestSingleResp = latestSingleResp;
        if (latestSingleResp != null) {
            this.thisUpdate = latestSingleResp.getThisUpdate();
            this.nextUpdate = latestSingleResp.getNextUpdate();
            this.extractStatusInfo(latestSingleResp);
            this.extractArchiveCutOff(latestSingleResp);
            this.extractCertHashExtension(latestSingleResp);
        }
        this.checkSignatureValidity(issuer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("OCSPToken created : {})", (Object)this.getDSSIdAsString());
        }
    }

    private void extractStatusInfo(SingleResp bestSingleResp) {
        CertificateStatus certStatus = bestSingleResp.getCertStatus();
        if (CertificateStatus.GOOD == certStatus) {
            if (LOG.isInfoEnabled()) {
                LOG.info("OCSP status is good");
            }
            this.status = eu.europa.esig.dss.enumerations.CertificateStatus.GOOD;
        } else if (certStatus instanceof RevokedStatus) {
            if (LOG.isInfoEnabled()) {
                LOG.info("OCSP status revoked");
            }
            RevokedStatus revokedStatus = (RevokedStatus)certStatus;
            this.status = eu.europa.esig.dss.enumerations.CertificateStatus.REVOKED;
            this.revocationDate = revokedStatus.getRevocationTime();
            int reasonId = 0;
            if (revokedStatus.hasRevocationReason()) {
                reasonId = revokedStatus.getRevocationReason();
            }
            this.reason = RevocationReason.fromInt(reasonId);
        } else if (certStatus instanceof UnknownStatus) {
            if (LOG.isInfoEnabled()) {
                LOG.info("OCSP status unknown");
            }
            this.status = eu.europa.esig.dss.enumerations.CertificateStatus.UNKNOWN;
        } else {
            LOG.info("OCSP certificate status: {}", (Object)certStatus);
        }
    }

    private void extractArchiveCutOff(SingleResp bestSingleResp) {
        Extension extension = bestSingleResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_archive_cutoff);
        if (extension != null) {
            ASN1GeneralizedTime archiveCutOffAsn1 = (ASN1GeneralizedTime)extension.getParsedValue();
            try {
                this.archiveCutOff = archiveCutOffAsn1.getDate();
            }
            catch (ParseException e) {
                LOG.warn("Unable to extract id_pkix_ocsp_archive_cutoff : {}", (Object)e.getMessage());
            }
        }
    }

    private void extractCertHashExtension(SingleResp bestSingleResp) {
        Extension extension = bestSingleResp.getExtension(ISISMTTObjectIdentifiers.id_isismtt_at_certHash);
        if (extension != null) {
            try {
                CertHash asn1CertHash = CertHash.getInstance(extension.getParsedValue());
                DigestAlgorithm digestAlgo = DigestAlgorithm.forOID(asn1CertHash.getHashAlgorithm().getAlgorithm().getId());
                Digest certHash = new Digest(digestAlgo, asn1CertHash.getCertificateHash());
                this.certHashPresent = true;
                byte[] expectedDigest = this.relatedCertificate.getDigest(certHash.getAlgorithm());
                byte[] foundDigest = certHash.getValue();
                this.certHashMatch = Arrays.equals(expectedDigest, foundDigest);
            }
            catch (Exception e) {
                LOG.warn("Unable to extract id_isismtt_at_certHash : {}", (Object)e.getMessage());
            }
        }
    }

    private void checkSignatureValidity(CertificateToken caCertificateToken) {
        OCSPSignatureIntegrityValidator signingCertificateValidator = new OCSPSignatureIntegrityValidator(this);
        CandidatesForSigningCertificate candidates = this.getCertificateSource().getCandidatesForSigningCertificate(caCertificateToken);
        CertificateValidity certificateValidity = signingCertificateValidator.validate(candidates);
        if (certificateValidity != null) {
            CertificateToken certificateToken;
            candidates.setTheCertificateValidity(certificateValidity);
            this.issuerCertificateToken = certificateToken = certificateValidity.getCertificateToken();
        }
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        if (this.signatureAlgorithm == null) {
            AlgorithmIdentifier signatureAlgorithmID = this.basicOCSPResp.getSignatureAlgorithmID();
            String oid = signatureAlgorithmID.getAlgorithm().getId();
            byte[] sigAlgParams = signatureAlgorithmID.getParameters() == null ? null : DSSASN1Utils.getDEREncoded(signatureAlgorithmID.getParameters());
            this.signatureAlgorithm = SignatureAlgorithm.forOidAndParams(oid, sigAlgParams);
        }
        return this.signatureAlgorithm;
    }

    public BasicOCSPResp getBasicOCSPResp() {
        return this.basicOCSPResp;
    }

    public SingleResp getLatestSingleResp() {
        return this.latestSingleResp;
    }

    @Override
    public OCSPCertificateSource getCertificateSource() {
        if (this.certificateSource == null) {
            this.certificateSource = new OCSPCertificateSource(this.getBasicOCSPResp());
        }
        return this.certificateSource;
    }

    @Override
    public byte[] getEncoded() {
        return DSSRevocationUtils.getEncodedFromBasicResp(this.basicOCSPResp);
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        if (this.issuerCertificateToken != null) {
            return this.issuerCertificateToken.getSubject().getPrincipal();
        }
        return null;
    }

    @Override
    public CertificateToken getIssuerCertificateToken() {
        return this.issuerCertificateToken;
    }

    @Override
    public boolean isValid() {
        return SignatureValidity.VALID == this.signatureValidity;
    }

    @Override
    protected SignatureValidity checkIsSignedBy(PublicKey publicKey) {
        try {
            this.signatureInvalidityReason = "";
            JcaContentVerifierProviderBuilder jcaContentVerifierProviderBuilder = new JcaContentVerifierProviderBuilder();
            jcaContentVerifierProviderBuilder.setProvider(DSSSecurityProvider.getSecurityProvider());
            ContentVerifierProvider contentVerifierProvider = jcaContentVerifierProviderBuilder.build(publicKey);
            this.signatureValidity = SignatureValidity.get(this.basicOCSPResp.isSignatureValid(contentVerifierProvider));
        }
        catch (Exception e) {
            LOG.error("An error occurred during in attempt to check signature owner : ", e);
            this.signatureInvalidityReason = e.getClass().getSimpleName() + " - " + e.getMessage();
            this.signatureValidity = SignatureValidity.INVALID;
        }
        return this.signatureValidity;
    }

    @Override
    public RevocationType getRevocationType() {
        return RevocationType.OCSP;
    }

    @Override
    public String getAbbreviation() {
        return "OCSPToken[" + (this.basicOCSPResp == null ? "?" : DSSUtils.formatDateToRFC(this.basicOCSPResp.getProducedAt())) + ", signedBy=" + this.getIssuerX500Principal() + "]";
    }

    @Override
    public String toString(String indentStr) {
        StringWriter out = new StringWriter();
        out.append(indentStr).append("OCSPToken[\n");
        indentStr = indentStr + "\t";
        out.append(indentStr).append("Id: ").append(this.getDSSIdAsString()).append('\n');
        out.append(indentStr).append("ProductionTime: ").append(DSSUtils.formatDateToRFC(this.productionDate)).append("; ");
        out.append(indentStr).append("ThisUpdate: ").append(DSSUtils.formatDateToRFC(this.thisUpdate)).append("; ");
        out.append(indentStr).append("NextUpdate: ").append(DSSUtils.formatDateToRFC(this.nextUpdate)).append('\n');
        if (this.getIssuerX500Principal() != null) {
            out.append(indentStr).append("SignedBy: ").append(this.getIssuerX500Principal().toString()).append('\n');
        }
        out.append(indentStr).append("Signature algorithm: ").append(this.signatureAlgorithm == null ? "?" : this.signatureAlgorithm.getJCEId()).append('\n');
        if (this.getRelatedCertificateId() != null) {
            out.append(indentStr).append("Related certificate: ").append(this.getRelatedCertificateId()).append('\n');
        }
        indentStr = indentStr.substring(1);
        out.append(indentStr).append("]");
        return out.toString();
    }
}

