/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.ocsp;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.client.jdbc.JdbcCacheConnector;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.revocation.JdbcRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;

public class JdbcCacheOCSPSource
extends JdbcRevocationSource<OCSP>
implements OCSPSource {
    private static final long serialVersionUID = 10480458323923489L;
    private static final String SQL_INIT_CHECK_EXISTENCE = "SELECT COUNT(*) FROM CACHED_OCSP";
    private static final String SQL_INIT_CREATE_TABLE = "CREATE TABLE CACHED_OCSP (ID VARCHAR(100), DATA BLOB, LOC VARCHAR(200))";
    private static final String SQL_FIND_QUERY = "SELECT * FROM CACHED_OCSP WHERE ID = ?";
    private static final String SQL_FIND_QUERY_DATA = "DATA";
    private static final String SQL_FIND_QUERY_LOC = "LOC";
    private static final String SQL_FIND_INSERT = "INSERT INTO CACHED_OCSP (ID, DATA, LOC) VALUES (?, ?, ?)";
    private static final String SQL_FIND_UPDATE = "UPDATE CACHED_OCSP SET DATA = ?, LOC = ? WHERE ID = ?";
    private static final String SQL_FIND_REMOVE = "DELETE FROM CACHED_OCSP WHERE ID = ?";
    private static final String SQL_DROP_TABLE = "DROP TABLE CACHED_OCSP";
    private static List<JdbcCacheConnector.JdbcResultRequest> findOCSPRequests = new ArrayList<JdbcCacheConnector.JdbcResultRequest>();

    @Override
    protected String getCreateTableQuery() {
        return SQL_INIT_CREATE_TABLE;
    }

    @Override
    protected String getTableExistenceQuery() {
        return SQL_INIT_CHECK_EXISTENCE;
    }

    @Override
    protected String getFindRevocationQuery() {
        return SQL_FIND_QUERY;
    }

    @Override
    protected String getRemoveRevocationTokenEntryQuery() {
        return SQL_FIND_REMOVE;
    }

    @Override
    protected String getDeleteTableQuery() {
        return SQL_DROP_TABLE;
    }

    @Override
    protected Collection<JdbcCacheConnector.JdbcResultRequest> getRevocationDataExtractRequests() {
        return findOCSPRequests;
    }

    @Override
    protected final List<String> initRevocationTokenKeys(CertificateToken certificateToken) {
        return DSSRevocationUtils.getOcspRevocationTokenKeys(certificateToken);
    }

    @Override
    protected RevocationToken<OCSP> buildRevocationTokenFromResult(JdbcCacheConnector.JdbcResultRecord resultRecord, CertificateToken certificateToken, CertificateToken issuerCert) throws DSSExternalResourceException {
        try {
            byte[] data = (byte[])resultRecord.get(SQL_FIND_QUERY_DATA);
            String url = (String)resultRecord.get(SQL_FIND_QUERY_LOC);
            OCSPResp ocspResp = new OCSPResp(data);
            BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResp.getResponseObject();
            SingleResp latestSingleResponse = DSSRevocationUtils.getLatestSingleResponse(basicResponse, certificateToken, issuerCert);
            OCSPToken ocspToken = new OCSPToken(basicResponse, latestSingleResponse, certificateToken, issuerCert);
            ocspToken.setSourceURL(url);
            ocspToken.setExternalOrigin(RevocationOrigin.CACHED);
            return ocspToken;
        }
        catch (IOException | OCSPException e) {
            throw new DSSExternalResourceException(String.format("An error occurred during an attempt to obtain a revocation token. Reason : %s", e.getMessage()), e);
        }
    }

    @Override
    protected void insertRevocation(String revocationKey, RevocationToken<OCSP> token) {
        this.jdbcCacheConnector.execute(SQL_FIND_INSERT, revocationKey, token.getEncoded(), token.getSourceURL());
    }

    @Override
    protected void updateRevocation(String revocationKey, RevocationToken<OCSP> token) {
        this.jdbcCacheConnector.execute(SQL_FIND_UPDATE, token.getEncoded(), token.getSourceURL(), revocationKey);
    }

    @Override
    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return (OCSPToken)super.getRevocationToken(certificateToken, issuerCertificateToken);
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        return (OCSPToken)super.getRevocationToken(certificateToken, issuerCertificateToken, forceRefresh);
    }

    @Override
    protected String getRevocationTokenKey(CertificateToken certificateToken, String urlString) {
        return DSSRevocationUtils.getOcspRevocationKey(certificateToken, urlString);
    }

    static {
        findOCSPRequests.add(new JdbcCacheConnector.JdbcResultRequest(SQL_FIND_QUERY_DATA, byte[].class));
        findOCSPRequests.add(new JdbcCacheConnector.JdbcResultRequest(SQL_FIND_QUERY_LOC, String.class));
    }
}

