/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.modifications;

import eu.europa.esig.dss.pdf.PdfArray;
import eu.europa.esig.dss.pdf.PdfDict;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.modifications.ObjectModification;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModifications;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModificationsFilter;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModificationsFinder;
import eu.europa.esig.dss.pdf.modifications.PdfObjectTree;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPdfObjectModificationsFinder
implements PdfObjectModificationsFinder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPdfObjectModificationsFinder.class);
    private int maximumObjectVerificationDeepness = 500;
    private PdfObjectModificationsFilter pdfObjectModificationsFilter = new PdfObjectModificationsFilter();

    public void setMaximumObjectVerificationDeepness(int maximumObjectVerificationDeepness) {
        this.maximumObjectVerificationDeepness = maximumObjectVerificationDeepness;
    }

    public void setPdfObjectModificationsFilter(PdfObjectModificationsFilter pdfObjectModificationsFilter) {
        Objects.requireNonNull(pdfObjectModificationsFilter, "PdfObjectModificationsFilter cannot be null!");
        this.pdfObjectModificationsFilter = pdfObjectModificationsFilter;
    }

    @Override
    public PdfObjectModifications find(PdfDocumentReader originalRevisionReader, PdfDocumentReader finalRevisionReader) {
        Set<ObjectModification> objectModifications = this.findObjectModifications(originalRevisionReader, finalRevisionReader);
        return this.pdfObjectModificationsFilter.filter(objectModifications);
    }

    private Set<ObjectModification> findObjectModifications(PdfDocumentReader originalRevisionReader, PdfDocumentReader finalRevisionReader) {
        LinkedHashSet<ObjectModification> modifications = new LinkedHashSet<ObjectModification>();
        PdfDict signedCatalogDict = originalRevisionReader.getCatalogDictionary();
        PdfDict finalCatalogDict = finalRevisionReader.getCatalogDictionary();
        this.compareObjectsRecursively(modifications, new HashSet<String>(), new PdfObjectTree("Catalog"), "Catalog", signedCatalogDict, finalCatalogDict);
        return modifications;
    }

    private void compareDictsRecursively(Set<ObjectModification> modifications, Set<String> processedObjects, PdfObjectTree objectTree, PdfDict signedDict, PdfDict finalDict) {
        String[] signedRevKeys = signedDict.list();
        String[] finalRevKeys = finalDict.list();
        for (String key : signedRevKeys) {
            Long objectNumber;
            PdfObjectTree currentObjectTree = objectTree.copy();
            if (this.isProcessedReference(processedObjects, currentObjectTree, key, objectNumber = signedDict.getObjectNumber(key))) continue;
            currentObjectTree.addKey(key);
            this.addProcessedReference(processedObjects, currentObjectTree, key, objectNumber);
            this.compareObjectsRecursively(modifications, processedObjects, currentObjectTree, key, signedDict.getObject(key), finalDict.getObject(key));
        }
        List<String> signedRevKeyList = Arrays.asList(signedRevKeys);
        for (String key : finalRevKeys) {
            PdfObjectTree currentObjectTree = objectTree.copy();
            if (signedRevKeyList.contains(key)) continue;
            currentObjectTree.addKey(key);
            Object finalObject = finalDict.getObject(key);
            if (finalObject instanceof PdfDict || finalObject instanceof PdfArray) {
                Long objectNumber = finalDict.getObjectNumber(key);
                this.addProcessedReference(processedObjects, currentObjectTree, key, objectNumber);
                modifications.add(ObjectModification.create(currentObjectTree, finalDict.getObject(key)));
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Added entry with key '{}'.", (Object)currentObjectTree);
                continue;
            }
            modifications.add(ObjectModification.modify(currentObjectTree, null, finalObject));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Added parameter with key name '{}'.", (Object)objectTree);
        }
        this.compareDictStreams(modifications, objectTree, signedDict, finalDict);
    }

    private void compareObjectsRecursively(Set<ObjectModification> modifications, Set<String> processedObjects, PdfObjectTree objectTree, String key, Object signedObject, Object finalObject) {
        if (this.maximumObjectVerificationDeepness < objectTree.getChainDeepness()) {
            LOG.warn("Maximum objects verification deepness has been reached : {}. Chain of objects is skipped.", (Object)this.maximumObjectVerificationDeepness);
            return;
        }
        if (signedObject == null && finalObject != null) {
            if (finalObject instanceof PdfDict || finalObject instanceof PdfArray) {
                modifications.add(ObjectModification.create(objectTree, finalObject));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Added entry with key '{}'.", (Object)objectTree);
                }
            } else {
                modifications.add(ObjectModification.modify(objectTree, null, finalObject));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Added parameter with key name '{}'.", (Object)objectTree);
                }
            }
        } else if (signedObject != null && finalObject == null) {
            if (signedObject instanceof PdfDict || signedObject instanceof PdfArray) {
                modifications.add(ObjectModification.delete(objectTree, signedObject));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleted entry with key '{}'.", (Object)objectTree);
                }
            } else {
                modifications.add(ObjectModification.modify(objectTree, signedObject, null));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleted parameter with key name '{}'.", (Object)objectTree);
                }
            }
        } else if (signedObject != null && finalObject != null) {
            if (signedObject instanceof PdfDict && finalObject instanceof PdfDict) {
                this.compareDictsRecursively(modifications, processedObjects, objectTree, (PdfDict)signedObject, (PdfDict)finalObject);
            } else if (signedObject instanceof PdfArray && finalObject instanceof PdfArray) {
                PdfArray signedArray = (PdfArray)signedObject;
                PdfArray finalArray = (PdfArray)finalObject;
                this.compareArraysRecursively(modifications, processedObjects, objectTree, key, signedArray, finalArray, true);
                this.compareArraysRecursively(modifications, processedObjects, objectTree, key, finalArray, signedArray, false);
            } else if (signedObject instanceof String && finalObject instanceof String) {
                if (!signedObject.equals(finalObject)) {
                    modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Object changed with key '{}'.", (Object)objectTree);
                    }
                }
            } else if (signedObject instanceof Number && finalObject instanceof Number) {
                if (!signedObject.equals(finalObject)) {
                    modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Object changed with key '{}'.", (Object)objectTree);
                    }
                }
            } else if (signedObject instanceof Boolean && finalObject instanceof Boolean) {
                if (!signedObject.equals(finalObject)) {
                    modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Object changed with key '{}'.", (Object)objectTree);
                    }
                }
            } else {
                modifications.add(ObjectModification.modify(objectTree, signedObject, finalObject));
                LOG.warn("Unsupported objects found with key '{}' of types '{}' and '{}'", objectTree, signedObject.getClass(), finalObject.getClass());
            }
        }
    }

    private void compareArraysRecursively(Set<ObjectModification> modifications, Set<String> processedObjects, PdfObjectTree objectTree, String key, PdfArray firstArray, PdfArray secondArray, boolean signedFirst) {
        for (int i = 0; i < firstArray.size(); ++i) {
            PdfObjectTree currentObjectTree = objectTree.copy();
            Object signedRevObject = firstArray.getObject(i);
            Object finalRevObject = null;
            Long objectNumber = firstArray.getObjectNumber(i);
            if (objectNumber != null) {
                for (int j = 0; j < secondArray.size(); ++j) {
                    Long finalObjectNumber = secondArray.getObjectNumber(j);
                    if (!objectNumber.equals(finalObjectNumber)) continue;
                    finalRevObject = secondArray.getObject(j);
                }
            } else if (i < secondArray.size()) {
                finalRevObject = secondArray.getObject(i);
            }
            if (this.isProcessedReference(processedObjects, currentObjectTree, key, objectNumber)) continue;
            this.addProcessedReference(processedObjects, currentObjectTree, key, objectNumber);
            this.compareObjectsRecursively(modifications, processedObjects, currentObjectTree, key, signedFirst ? signedRevObject : finalRevObject, signedFirst ? finalRevObject : signedRevObject);
        }
    }

    private boolean isProcessedReference(Set<String> processedObjects, PdfObjectTree objectTree, String key, Number objectNumber) {
        return processedObjects.contains(key + objectNumber) || objectTree.isProcessedReference(objectNumber);
    }

    private void addProcessedReference(Set<String> processedObjects, PdfObjectTree objectTree, String key, Number objectNumber) {
        if (objectNumber != null) {
            processedObjects.add(key + objectNumber);
            objectTree.addReference(objectNumber);
        }
    }

    private void compareDictStreams(Set<ObjectModification> modifications, PdfObjectTree objectTree, PdfDict signedDict, PdfDict finalDict) {
        PdfObjectTree currentObjectTree = objectTree.copy();
        currentObjectTree.setStream();
        byte[] signedStream = this.getStreamBytesSecurely(signedDict);
        byte[] finalBytes = this.getStreamBytesSecurely(finalDict);
        if (Utils.isArrayEmpty(signedStream) && Utils.isArrayNotEmpty(finalBytes)) {
            modifications.add(ObjectModification.create(currentObjectTree, finalDict));
            if (LOG.isDebugEnabled()) {
                LOG.debug("A stream has been added '{}'.", (Object)currentObjectTree);
            }
        } else if (Utils.isArrayNotEmpty(signedStream) && Utils.isArrayEmpty(finalBytes)) {
            modifications.add(ObjectModification.delete(currentObjectTree, signedDict));
            if (LOG.isDebugEnabled()) {
                LOG.debug("A stream has been removed '{}'.", (Object)currentObjectTree);
            }
        } else if (Utils.isArrayNotEmpty(signedStream) && Utils.isArrayNotEmpty(finalBytes) && !Arrays.equals(signedStream, finalBytes)) {
            modifications.add(ObjectModification.modify(currentObjectTree, signedDict, finalDict));
            if (LOG.isDebugEnabled()) {
                LOG.debug("A stream has been modified '{}'.", (Object)currentObjectTree);
            }
        }
    }

    private byte[] getStreamBytesSecurely(PdfDict pdfDict) {
        try {
            return pdfDict.getStreamBytes();
        }
        catch (IOException e) {
            LOG.debug("Unable to compare underlying stream binaries. Reason : {}", (Object)e.getMessage());
            return DSSUtils.EMPTY_BYTE_ARRAY;
        }
    }
}

