/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf;

import eu.europa.esig.dss.alert.ExceptionOnStatusAlert;
import eu.europa.esig.dss.alert.StatusAlert;
import eu.europa.esig.dss.alert.status.MessageStatus;
import eu.europa.esig.dss.enumerations.CertificationPermission;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.pades.PAdESCommonParameters;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.SignatureFieldParameters;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pades.exception.InvalidPasswordException;
import eu.europa.esig.dss.pades.validation.ByteRange;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.PdfRevision;
import eu.europa.esig.dss.pades.validation.PdfSignatureDictionary;
import eu.europa.esig.dss.pades.validation.PdfSignatureField;
import eu.europa.esig.dss.pades.validation.PdfValidationDataContainer;
import eu.europa.esig.dss.pades.validation.dss.PdfCompositeDssDictionary;
import eu.europa.esig.dss.pdf.AnnotationBox;
import eu.europa.esig.dss.pdf.PDFServiceMode;
import eu.europa.esig.dss.pdf.PDFSignatureService;
import eu.europa.esig.dss.pdf.PdfAnnotation;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import eu.europa.esig.dss.pdf.PdfDocDssRevision;
import eu.europa.esig.dss.pdf.PdfDocTimestampRevision;
import eu.europa.esig.dss.pdf.PdfDocumentReader;
import eu.europa.esig.dss.pdf.PdfDssDict;
import eu.europa.esig.dss.pdf.PdfSignatureCache;
import eu.europa.esig.dss.pdf.PdfSignatureDictionaryComparator;
import eu.europa.esig.dss.pdf.PdfSignatureRevision;
import eu.europa.esig.dss.pdf.SigFieldPermissions;
import eu.europa.esig.dss.pdf.modifications.DefaultPdfDifferencesFinder;
import eu.europa.esig.dss.pdf.modifications.DefaultPdfObjectModificationsFinder;
import eu.europa.esig.dss.pdf.modifications.PdfDifferencesFinder;
import eu.europa.esig.dss.pdf.modifications.PdfModification;
import eu.europa.esig.dss.pdf.modifications.PdfModificationDetection;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModificationsFinder;
import eu.europa.esig.dss.pdf.visible.SignatureDrawer;
import eu.europa.esig.dss.pdf.visible.SignatureDrawerFactory;
import eu.europa.esig.dss.pdf.visible.SignatureFieldBoxBuilder;
import eu.europa.esig.dss.pdf.visible.VisualSignatureFieldAppearance;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandler;
import eu.europa.esig.dss.signature.resources.DSSResourcesHandlerBuilder;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPDFSignatureService
implements PDFSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPDFSignatureService.class);
    private final PDFServiceMode serviceMode;
    private final SignatureDrawerFactory signatureDrawerFactory;
    protected DSSResourcesHandlerBuilder resourcesHandlerBuilder = PAdESUtils.DEFAULT_RESOURCES_HANDLER_BUILDER;
    protected PdfDifferencesFinder pdfDifferencesFinder = new DefaultPdfDifferencesFinder();
    protected PdfObjectModificationsFinder pdfObjectModificationsFinder = new DefaultPdfObjectModificationsFinder();
    private StatusAlert alertOnSignatureFieldOverlap = new ExceptionOnStatusAlert();
    private StatusAlert alertOnSignatureFieldOutsidePageDimensions = new ExceptionOnStatusAlert();
    private StatusAlert alertOnForbiddenSignatureCreation = new ExceptionOnStatusAlert();

    protected AbstractPDFSignatureService(PDFServiceMode serviceMode, SignatureDrawerFactory signatureDrawerFactory) {
        Objects.requireNonNull(serviceMode, "The PDFServiceMode shall be defined!");
        Objects.requireNonNull(signatureDrawerFactory, "The SignatureDrawerFactory shall be defined!");
        this.serviceMode = serviceMode;
        this.signatureDrawerFactory = signatureDrawerFactory;
    }

    @Override
    public void setResourcesHandlerBuilder(DSSResourcesHandlerBuilder resourcesHandlerBuilder) {
        Objects.requireNonNull(resourcesHandlerBuilder, "DSSResourcesFactoryBuilder cannot be null!");
        this.resourcesHandlerBuilder = resourcesHandlerBuilder;
    }

    @Override
    public void setPdfDifferencesFinder(PdfDifferencesFinder pdfDifferencesFinder) {
        Objects.requireNonNull(pdfDifferencesFinder, "PdfDifferencesFinder cannot be null!");
        this.pdfDifferencesFinder = pdfDifferencesFinder;
    }

    @Override
    public void setPdfObjectModificationsFinder(PdfObjectModificationsFinder pdfObjectModificationsFinder) {
        Objects.requireNonNull(pdfObjectModificationsFinder, "PdfObjectModificationsFinder cannot be null!");
        this.pdfObjectModificationsFinder = pdfObjectModificationsFinder;
    }

    public void setAlertOnSignatureFieldOverlap(StatusAlert alertOnSignatureFieldOverlap) {
        Objects.requireNonNull(alertOnSignatureFieldOverlap, "StatusAlert cannot be null!");
        this.alertOnSignatureFieldOverlap = alertOnSignatureFieldOverlap;
    }

    public void setAlertOnSignatureFieldOutsidePageDimensions(StatusAlert alertOnSignatureFieldOutsidePageDimensions) {
        this.alertOnSignatureFieldOutsidePageDimensions = alertOnSignatureFieldOutsidePageDimensions;
    }

    public void setAlertOnForbiddenSignatureCreation(StatusAlert alertOnForbiddenSignatureCreation) {
        this.alertOnForbiddenSignatureCreation = alertOnForbiddenSignatureCreation;
    }

    @Deprecated
    public void setMaximalPagesAmountForVisualComparison(int pagesAmount) {
        LOG.warn("Use of deprecated setMaximalPagesAmountForVisualComparison(pagesAmount) method! See more details in JavaDoc.");
        DefaultPdfDifferencesFinder pdfDifferencesFinder = new DefaultPdfDifferencesFinder();
        pdfDifferencesFinder.setMaximalPagesAmountForVisualComparison(pagesAmount);
        this.setPdfDifferencesFinder(pdfDifferencesFinder);
    }

    protected SignatureDrawer loadSignatureDrawer(SignatureImageParameters imageParameters) {
        SignatureDrawer signatureDrawer = this.signatureDrawerFactory.getSignatureDrawer(imageParameters);
        if (signatureDrawer == null) {
            throw new IllegalArgumentException("SignatureDrawer shall be defined for the used SignatureDrawerFactory!");
        }
        return signatureDrawer;
    }

    protected DSSResourcesHandler instantiateResourcesHandler() throws IOException {
        return this.resourcesHandlerBuilder.createResourcesHandler();
    }

    @Override
    public byte[] digest(DSSDocument toSignDocument, PAdESCommonParameters parameters) {
        PdfSignatureCache pdfSignatureCache = parameters.getPdfSignatureCache();
        if (Utils.isArrayEmpty(pdfSignatureCache.getDigest())) {
            byte[] digest = this.computeDigest(toSignDocument, parameters);
            pdfSignatureCache.setDigest(digest);
        }
        return pdfSignatureCache.getDigest();
    }

    protected abstract byte[] computeDigest(DSSDocument var1, PAdESCommonParameters var2);

    @Override
    public DSSDocument sign(DSSDocument toSignDocument, byte[] cmsSignedData, PAdESCommonParameters parameters) {
        PdfSignatureCache pdfSignatureCache = parameters.getPdfSignatureCache();
        DSSDocument signedDocument = null;
        if (pdfSignatureCache.getToBeSignedDocument() != null) {
            try {
                signedDocument = PAdESUtils.replaceSignature(pdfSignatureCache.getToBeSignedDocument(), cmsSignedData, this.resourcesHandlerBuilder);
            }
            catch (Exception e) {
                String errorMessage = "Unable to sign document using a resources caching! Reason : '{}'. Sign using a complete processing...";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        parameters.reinit();
        if (signedDocument == null) {
            signedDocument = this.signDocument(toSignDocument, cmsSignedData, parameters);
        }
        signedDocument.setMimeType(MimeType.PDF);
        return signedDocument;
    }

    protected abstract DSSDocument signDocument(DSSDocument var1, byte[] var2, PAdESCommonParameters var3);

    protected boolean isDocumentTimestampLayer() {
        return PDFServiceMode.SIGNATURE_TIMESTAMP == this.serviceMode || PDFServiceMode.ARCHIVE_TIMESTAMP == this.serviceMode;
    }

    protected String getType() {
        if (this.isDocumentTimestampLayer()) {
            return "DocTimeStamp";
        }
        return "Sig";
    }

    protected void checkDocumentPermissions(PdfDocumentReader pdfDocumentReader) {
        pdfDocumentReader.checkDocumentPermissions();
    }

    protected void checkNewSignatureIsPermitted(PdfDocumentReader reader, SignatureFieldParameters fieldParameters) {
        CertificationPermission certificationPermission = reader.getCertificationPermission();
        if (this.isDocumentChangeForbidden(certificationPermission)) {
            this.alertOnForbiddenSignatureCreation();
        }
        if (reader.isUsageRightsSignaturePresent()) {
            LOG.info("A usage rights signature is present. The feature is deprecated and the entry is not handled.");
        }
        try {
            String signatureFieldId = fieldParameters.getFieldId();
            Map<PdfSignatureDictionary, List<PdfSignatureField>> sigDictionaries = reader.extractSigDictionaries();
            sigDictionaries = this.sortSignatureDictionaries(sigDictionaries);
            for (PdfSignatureDictionary pdfSignatureDictionary : sigDictionaries.keySet()) {
                SigFieldPermissions fieldMDP = pdfSignatureDictionary.getFieldMDP();
                if (fieldMDP == null || !this.isSignatureFieldCreationForbidden(fieldMDP, signatureFieldId)) continue;
                this.alertOnForbiddenSignatureCreation();
            }
            for (List list : sigDictionaries.values()) {
                for (PdfSignatureField signatureField : list) {
                    SigFieldPermissions lockDict = signatureField.getLockDictionary();
                    if (lockDict == null || lockDict.getCertificationPermission() == null || !this.isSignatureFieldCreationForbidden(lockDict, signatureFieldId)) continue;
                    this.alertOnForbiddenSignatureCreation();
                }
            }
        }
        catch (IOException e) {
            LOG.warn("An error occurred while reading signature dictionary entries : {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public List<PdfRevision> getRevisions(DSSDocument document, String pwd) {
        ArrayList<PdfRevision> revisions = new ArrayList<PdfRevision>();
        try (PdfDocumentReader reader = this.loadPdfDocumentReader(document, pwd);){
            PdfDssDict dssDictionary;
            PdfCompositeDssDictionary compositeDssDictionary = new PdfCompositeDssDictionary();
            PdfDssDict lastDSSDictionary = dssDictionary = reader.getDSSDictionary();
            compositeDssDictionary.populateFromDssDictionary(lastDSSDictionary);
            Map<PdfSignatureDictionary, List<PdfSignatureField>> sigDictionaries = reader.extractSigDictionaries();
            sigDictionaries = this.sortSignatureDictionaries(sigDictionaries);
            for (Map.Entry<PdfSignatureDictionary, List<PdfSignatureField>> sigDictEntry : sigDictionaries.entrySet()) {
                PdfSignatureDictionary signatureDictionary = sigDictEntry.getKey();
                List<PdfSignatureField> fields = sigDictEntry.getValue();
                List<String> fieldNames = fields.stream().map(PdfSignatureField::getFieldName).collect(Collectors.toList());
                try {
                    LOG.info("Signature fields: {}", (Object)fieldNames);
                    ByteRange byteRange = signatureDictionary.getByteRange();
                    byteRange.validate();
                    byte[] cms = signatureDictionary.getContents();
                    byte[] revisionContent = DSSUtils.EMPTY_BYTE_ARRAY;
                    if (!this.isContentValueEqualsByteRangeExtraction(document, byteRange, cms, fieldNames)) {
                        LOG.warn("Signature {} is invalid. SIWA detected !", (Object)fieldNames);
                    } else {
                        revisionContent = PAdESUtils.getRevisionContent(document, byteRange);
                    }
                    boolean signatureCoversWholeDocument = reader.isSignatureCoversWholeDocument(signatureDictionary);
                    byte[] signedData = PAdESUtils.getSignedContentFromRevision(revisionContent, byteRange);
                    InMemoryDocument signedContent = new InMemoryDocument(signedData);
                    lastDSSDictionary = this.getPreviousDssDictAndUpdateIfNeeded(revisions, compositeDssDictionary, lastDSSDictionary, revisionContent, pwd);
                    PdfCMSRevision newRevision = null;
                    if (this.isDocTimestamp(signatureDictionary)) {
                        newRevision = new PdfDocTimestampRevision(signatureDictionary, fields, signedContent, signatureCoversWholeDocument);
                    } else if (this.isSignature(signatureDictionary)) {
                        newRevision = new PdfSignatureRevision(signatureDictionary, compositeDssDictionary, dssDictionary, fields, signedContent, signatureCoversWholeDocument);
                    } else {
                        LOG.warn("The entry {} is skipped. A signature dictionary entry with a type '{}' and subFilter '{}' is not acceptable configuration!", fieldNames, signatureDictionary.getType(), signatureDictionary.getSubFilter());
                    }
                    if (newRevision != null) {
                        revisions.add(newRevision);
                    }
                    lastDSSDictionary = this.getPreviousDssDictAndUpdateIfNeeded(revisions, compositeDssDictionary, lastDSSDictionary, this.extractBeforeSignatureValue(byteRange, revisionContent), pwd);
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse signature {} . Reason : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.error(errorMessage, fieldNames, e.getMessage(), e);
                        continue;
                    }
                    LOG.error(errorMessage, (Object)fieldNames, (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            throw new DSSException(String.format("The document with name [%s] is either not accessible or not PDF compatible. Reason : [%s]", document.getName(), e.getMessage()), e);
        }
        catch (DSSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSSException("Cannot analyze signatures : " + e.getMessage(), e);
        }
        return revisions;
    }

    @Override
    public DSSDocument addDssDictionary(DSSDocument document, PdfValidationDataContainer validationDataForInclusion) {
        return this.addDssDictionary(document, validationDataForInclusion, null);
    }

    @Override
    public List<String> getAvailableSignatureFields(DSSDocument document) {
        return this.getAvailableSignatureFields(document, null);
    }

    @Override
    public DSSDocument addNewSignatureField(DSSDocument document, SignatureFieldParameters parameters) {
        return this.addNewSignatureField(document, parameters, null);
    }

    protected abstract PdfDocumentReader loadPdfDocumentReader(DSSDocument var1, String var2) throws IOException, InvalidPasswordException;

    protected abstract PdfDocumentReader loadPdfDocumentReader(byte[] var1, String var2) throws IOException, InvalidPasswordException;

    private Map<PdfSignatureDictionary, List<PdfSignatureField>> sortSignatureDictionaries(Map<PdfSignatureDictionary, List<PdfSignatureField>> pdfSignatureDictionary) {
        return pdfSignatureDictionary.entrySet().stream().sorted(Map.Entry.comparingByKey(new PdfSignatureDictionaryComparator()).reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    private PdfDssDict getPreviousDssDictAndUpdateIfNeeded(List<PdfRevision> revisions, PdfCompositeDssDictionary compositeDssDictionary, PdfDssDict lastDSSDictionary, byte[] dssDictionaryRevision, String pwd) {
        PdfDssDict currentDssDict = this.getDSSDictionaryPresentInRevision(dssDictionaryRevision, pwd);
        if (lastDSSDictionary != null && !lastDSSDictionary.equals(currentDssDict)) {
            compositeDssDictionary.populateFromDssDictionary(lastDSSDictionary);
            revisions.add(new PdfDocDssRevision(compositeDssDictionary, lastDSSDictionary));
        }
        return currentDssDict;
    }

    private PdfDssDict getDSSDictionaryPresentInRevision(byte[] originalBytes, String pwd) {
        PdfDssDict pdfDssDict;
        block10: {
            if (Utils.isArrayEmpty(originalBytes)) {
                return null;
            }
            PdfDocumentReader reader = this.loadPdfDocumentReader(originalBytes, pwd);
            try {
                pdfDssDict = reader.getDSSDictionary();
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cannot extract DSS dictionary from the previous revision : {}", (Object)e.getMessage());
                    }
                    return null;
                }
            }
            reader.close();
        }
        return pdfDssDict;
    }

    protected boolean isContentValueEqualsByteRangeExtraction(DSSDocument document, ByteRange byteRange, byte[] cms, List<String> signatureFieldNames) {
        boolean match = false;
        try {
            byte[] cmsWithByteRange = this.getSignatureValue(document, byteRange);
            match = Arrays.equals(cms, cmsWithByteRange);
            if (!match) {
                LOG.warn("Conflict between /Content and ByteRange for Signature {}.", (Object)signatureFieldNames);
            }
        }
        catch (Exception e) {
            String message = String.format("Unable to retrieve data from the ByteRange : %s. Reason : %s", byteRange, e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.error(message, e);
            }
            LOG.error(message);
        }
        return match;
    }

    protected byte[] getSignatureValue(DSSDocument dssDocument, ByteRange byteRange) throws IOException {
        int startSigValueContent = byteRange.getFirstPartStart() + byteRange.getFirstPartEnd() + 1;
        int endSigValueContent = byteRange.getSecondPartStart() - 1;
        int signatureValueArraySize = endSigValueContent - startSigValueContent;
        if (signatureValueArraySize < 1) {
            throw new DSSException("The byte range present in the document is not valid! SignatureValue size cannot be negative or equal to zero!");
        }
        byte[] signatureValueArray = new byte[signatureValueArraySize];
        try (InputStream is = dssDocument.openStream();){
            DSSUtils.skipAvailableBytes(is, startSigValueContent);
            DSSUtils.readAvailableBytes(is, signatureValueArray);
        }
        return Utils.fromHex(new String(signatureValueArray));
    }

    protected byte[] extractBeforeSignatureValue(ByteRange byteRange, byte[] signedContent) {
        int length = byteRange.getFirstPartEnd();
        if (signedContent.length < length) {
            return new byte[0];
        }
        return PAdESUtils.retrievePreviousPDFRevision(new InMemoryDocument(signedContent), byteRange).getBytes();
    }

    protected boolean isDocTimestamp(PdfSignatureDictionary pdfSigDict) {
        String type = pdfSigDict.getType();
        String subFilter = pdfSigDict.getSubFilter();
        return (type == null || "DocTimeStamp".equals(type)) && "ETSI.RFC3161".equals(subFilter);
    }

    protected boolean isSignature(PdfSignatureDictionary pdfSigDict) {
        String type = pdfSigDict.getType();
        String subFilter = pdfSigDict.getSubFilter();
        return (type == null || "Sig".equals(type)) && !"ETSI.RFC3161".equals(subFilter);
    }

    protected AnnotationBox getVisibleSignatureFieldBoxPosition(SignatureDrawer signatureDrawer, PdfDocumentReader documentReader, SignatureFieldParameters fieldParameters) throws IOException {
        AnnotationBox signatureFieldAnnotation = this.buildSignatureFieldBox(signatureDrawer);
        if (signatureFieldAnnotation != null) {
            AnnotationBox pageBox = documentReader.getPageBox(fieldParameters.getPage());
            int pageRotation = documentReader.getPageRotation(fieldParameters.getPage());
            signatureFieldAnnotation = this.toPdfPageCoordinates(signatureFieldAnnotation, pageBox, pageRotation);
            this.assertSignatureFieldPositionValid(signatureFieldAnnotation, documentReader, fieldParameters);
        }
        return signatureFieldAnnotation;
    }

    protected AnnotationBox buildSignatureFieldBox(SignatureDrawer signatureDrawer) throws IOException {
        SignatureFieldBoxBuilder signatureFieldBoxBuilder;
        VisualSignatureFieldAppearance signatureFieldBox;
        if (signatureDrawer instanceof SignatureFieldBoxBuilder && (signatureFieldBox = (signatureFieldBoxBuilder = (SignatureFieldBoxBuilder)((Object)signatureDrawer)).buildSignatureFieldBox()) != null) {
            return signatureFieldBox.getAnnotationBox();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("The used SignatureDrawer shall be an instance of VisibleSignatureFieldBoxBuilder in order to verify a SignatureField position!");
        }
        return null;
    }

    protected AnnotationBox getVisibleSignatureFieldBoxPosition(PdfDocumentReader reader, SignatureFieldParameters parameters) throws IOException {
        AnnotationBox annotationBox = new AnnotationBox(parameters);
        AnnotationBox pageBox = reader.getPageBox(parameters.getPage());
        int pageRotation = reader.getPageRotation(parameters.getPage());
        annotationBox = this.toPdfPageCoordinates(annotationBox, pageBox, pageRotation);
        this.assertSignatureFieldPositionValid(annotationBox, reader, parameters);
        return annotationBox;
    }

    protected AnnotationBox toPdfPageCoordinates(AnnotationBox fieldAnnotationBox, AnnotationBox pageBox, int pageRotation) {
        return fieldAnnotationBox.toPdfPageCoordinates(pageBox.getHeight());
    }

    private void assertSignatureFieldPositionValid(AnnotationBox annotationBox, PdfDocumentReader reader, SignatureFieldParameters parameters) throws IOException {
        int pageRotation = reader.getPageRotation(parameters.getPage());
        AnnotationBox pageBox = reader.getPageBox(parameters.getPage());
        this.checkSignatureFieldAgainstPageDimensions(annotationBox, pageBox, pageRotation);
        List<PdfAnnotation> pdfAnnotations = reader.getPdfAnnotations(parameters.getPage());
        this.checkSignatureFieldBoxOverlap(annotationBox, pdfAnnotations);
    }

    protected void checkSignatureFieldBoxOverlap(AnnotationBox signatureFieldBox, List<PdfAnnotation> pdfAnnotations) {
        if (this.pdfDifferencesFinder.isAnnotationBoxOverlapping(signatureFieldBox, pdfAnnotations)) {
            this.alertOnSignatureFieldOverlap();
        }
    }

    private void alertOnSignatureFieldOverlap() {
        MessageStatus status = new MessageStatus();
        status.setMessage("The new signature field position overlaps with an existing annotation!");
        this.alertOnSignatureFieldOverlap.alert(status);
    }

    protected void checkSignatureFieldAgainstPageDimensions(AnnotationBox signatureFieldBox, AnnotationBox pageBox, int pageRotation) {
        if (signatureFieldBox.getMinX() < pageBox.getMinX() || signatureFieldBox.getMaxX() > pageBox.getMaxX() || signatureFieldBox.getMinY() < pageBox.getMinY() || signatureFieldBox.getMaxY() > pageBox.getMaxY()) {
            this.alertOnSignatureFieldOutsidePageDimensions(signatureFieldBox, pageBox);
        }
    }

    private void alertOnSignatureFieldOutsidePageDimensions(AnnotationBox signatureFieldBox, AnnotationBox pageBox) {
        MessageStatus status = new MessageStatus();
        status.setMessage(String.format("The new signature field position is outside the page dimensions! Signature Field : [minX=%s, maxX=%s, minY=%s, maxY=%s], Page : [minX=%s, maxX=%s, minY=%s, maxY=%s]", Float.valueOf(signatureFieldBox.getMinX()), Float.valueOf(signatureFieldBox.getMaxX()), Float.valueOf(signatureFieldBox.getMinY()), Float.valueOf(signatureFieldBox.getMaxY()), Float.valueOf(pageBox.getMinX()), Float.valueOf(pageBox.getMaxX()), Float.valueOf(pageBox.getMinY()), Float.valueOf(pageBox.getMaxY())));
        this.alertOnSignatureFieldOutsidePageDimensions.alert(status);
    }

    @Override
    public void analyzePdfModifications(DSSDocument document, List<AdvancedSignature> signatures, String pwd) {
        try (PdfDocumentReader finalRevisionReader = this.loadPdfDocumentReader(document, pwd);){
            for (AdvancedSignature signature : signatures) {
                PAdESSignature padesSignature = (PAdESSignature)signature;
                PdfSignatureRevision pdfRevision = padesSignature.getPdfRevision();
                byte[] revisionContent = PAdESUtils.getRevisionContent(document, pdfRevision.getByteRange());
                pdfRevision.setModificationDetection(this.getModificationDetection(finalRevisionReader, new InMemoryDocument(revisionContent), pwd));
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to proceed PDF modification detection. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.error(errorMessage, (Object)e.getMessage(), (Object)e);
            }
            LOG.error(errorMessage, (Object)e.getMessage());
        }
    }

    private PdfModificationDetection getModificationDetection(PdfDocumentReader finalRevisionReader, DSSDocument originalDocument, String pwd) throws IOException {
        try (PdfDocumentReader signedRevisionReader = this.loadPdfDocumentReader(originalDocument, pwd);){
            PdfModificationDetection pdfModificationDetection = new PdfModificationDetection();
            pdfModificationDetection.setAnnotationOverlaps(this.pdfDifferencesFinder.getAnnotationOverlaps(finalRevisionReader));
            pdfModificationDetection.setPageDifferences(this.pdfDifferencesFinder.getPagesDifferences(signedRevisionReader, finalRevisionReader));
            pdfModificationDetection.setVisualDifferences(this.getVisualDifferences(signedRevisionReader, finalRevisionReader));
            pdfModificationDetection.setObjectModifications(this.pdfObjectModificationsFinder.find(signedRevisionReader, finalRevisionReader));
            PdfModificationDetection pdfModificationDetection2 = pdfModificationDetection;
            return pdfModificationDetection2;
        }
    }

    protected List<PdfModification> getVisualDifferences(PdfDocumentReader signedRevisionReader, PdfDocumentReader finalRevisionReader) {
        return this.pdfDifferencesFinder.getVisualDifferences(signedRevisionReader, finalRevisionReader);
    }

    private boolean isDocumentChangeForbidden(CertificationPermission certificationPermission) {
        return CertificationPermission.NO_CHANGE_PERMITTED.equals((Object)certificationPermission);
    }

    private void alertOnForbiddenSignatureCreation() {
        MessageStatus status = new MessageStatus();
        status.setMessage("The creation of new signatures is not permitted in the current document.");
        this.alertOnForbiddenSignatureCreation.alert(status);
    }

    private boolean isSignatureFieldCreationForbidden(SigFieldPermissions sigFieldPermissions, String signatureFieldId) {
        switch (sigFieldPermissions.getAction()) {
            case ALL: {
                return true;
            }
            case INCLUDE: {
                if (Utils.isStringEmpty(signatureFieldId)) {
                    return false;
                }
                if (!sigFieldPermissions.getFields().contains(signatureFieldId)) break;
                return true;
            }
            case EXCLUDE: {
                if (Utils.isStringEmpty(signatureFieldId)) {
                    return true;
                }
                if (sigFieldPermissions.getFields().contains(signatureFieldId)) break;
                return true;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The action value '%s' is not supported!", new Object[]{sigFieldPermissions.getAction()}));
            }
        }
        CertificationPermission certificationPermission = sigFieldPermissions.getCertificationPermission();
        return CertificationPermission.NO_CHANGE_PERMITTED.equals((Object)certificationPermission);
    }
}

