/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.scope;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.scope.FullPdfByteRangeSignatureScope;
import eu.europa.esig.dss.pades.validation.scope.PartialPdfByteRangeSignatureScope;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import eu.europa.esig.dss.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.validation.scope.SignatureScope;

public abstract class PdfRevisionScopeFinder
extends AbstractSignatureScopeFinder {
    protected PdfRevisionScopeFinder() {
    }

    protected SignatureScope findSignatureScope(PdfCMSRevision pdfRevision) {
        if (pdfRevision.areAllOriginalBytesCovered()) {
            return new FullPdfByteRangeSignatureScope(pdfRevision.getByteRange(), this.getOriginalPdfDigest(pdfRevision));
        }
        return new PartialPdfByteRangeSignatureScope(pdfRevision.getByteRange(), this.getOriginalPdfDigest(pdfRevision));
    }

    private Digest getOriginalPdfDigest(PdfCMSRevision pdfRevision) {
        InMemoryDocument originalDocument = PAdESUtils.getOriginalPDF(pdfRevision);
        return this.getDigest(originalDocument);
    }
}

