/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model;

import eu.europa.esig.dss.model.DSSException;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeType
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MimeType.class);
    private static Map<String, MimeType> mimeTypes = new HashMap<String, MimeType>();
    private static Map<String, MimeType> fileExtensions = new HashMap<String, MimeType>();
    public static final MimeType BINARY = new MimeType("application/octet-stream");
    public static final MimeType XML = new MimeType("text/xml");
    public static final MimeType HTML = new MimeType("text/html");
    public static final MimeType PDF = new MimeType("application/pdf");
    public static final MimeType PKCS7 = new MimeType("application/pkcs7-signature");
    public static final MimeType JSON = new MimeType("application/json");
    public static final MimeType JOSE = new MimeType("application/jose");
    public static final MimeType JOSE_JSON = new MimeType("application/jose+json");
    public static final MimeType TST = new MimeType("application/vnd.etsi.timestamp-token");
    public static final MimeType ZIP = new MimeType("application/zip");
    public static final MimeType ASICS = new MimeType("application/vnd.etsi.asic-s+zip");
    public static final MimeType ASICE = new MimeType("application/vnd.etsi.asic-e+zip");
    public static final MimeType ODT = new MimeType("application/vnd.oasis.opendocument.text");
    public static final MimeType ODS = new MimeType("application/vnd.oasis.opendocument.spreadsheet");
    public static final MimeType ODP = new MimeType("application/vnd.oasis.opendocument.presentation");
    public static final MimeType ODG = new MimeType("application/vnd.oasis.opendocument.graphics");
    public static final MimeType TEXT = new MimeType("text/plain");
    public static final MimeType CRL = new MimeType("application/pkix-crl");
    public static final MimeType CER = new MimeType("application/pkix-cert");
    public static final MimeType PNG = new MimeType("image/png");
    public static final MimeType JPEG = new MimeType("image/jpeg");
    public static final MimeType SVG = new MimeType("image/svg+xml");
    private String mimeTypeString;

    public MimeType() {
    }

    private MimeType(String mimeTypeString) {
        Objects.requireNonNull(mimeTypeString, "The mimeTypeString cannot be null!");
        if (!mimeTypeString.matches("([\\w])*/([\\w\\-\\+\\.])*")) {
            LOG.warn("'{}' is not conformant mime-type string! (see RFC 2045)", (Object)mimeTypeString);
        }
        if (mimeTypes.get(mimeTypeString) != null) {
            throw new DSSException(String.format("'%s' corresponding MimeType exists already! Use #fromMimeTypeString method to obtain the corresponding object.", mimeTypeString));
        }
        this.mimeTypeString = mimeTypeString;
        mimeTypes.put(mimeTypeString, this);
    }

    public MimeType(String mimeTypeString, String extension) {
        this(mimeTypeString);
        this.defineFileExtension(extension);
    }

    public String getMimeTypeString() {
        return this.mimeTypeString;
    }

    public void setMimeTypeString(String mimeTypeString) {
        this.mimeTypeString = mimeTypeString;
    }

    public static MimeType fromFileName(String fileName) {
        String lowerCaseExtension;
        MimeType mimeType;
        String fileExtension = MimeType.getFileExtension(fileName);
        if (fileExtension != null && (mimeType = fileExtensions.get(lowerCaseExtension = fileExtension.toLowerCase())) != null) {
            return mimeType;
        }
        return BINARY;
    }

    public static String getExtension(MimeType mimeType) {
        Objects.requireNonNull(mimeType, "The MimeType must be provided!");
        for (Map.Entry<String, MimeType> entry : fileExtensions.entrySet()) {
            if (!mimeType.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        LOG.warn("The MimeType '{}' is not known or does not have a particular extension", (Object)mimeType);
        return null;
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.trim().length() == 0) {
            return null;
        }
        String extension = "";
        int lastIndexOf = fileName.lastIndexOf(46);
        if (lastIndexOf > 0) {
            extension = fileName.substring(lastIndexOf + 1);
        }
        return extension;
    }

    public static MimeType fromFile(File file) {
        Objects.requireNonNull(file, "The file cannot be null!");
        String fileName = file.getName();
        return MimeType.fromFileName(fileName);
    }

    public static MimeType fromMimeTypeString(String mimeTypeString) {
        Objects.requireNonNull(mimeTypeString, "The mimeTypeString cannot be null!");
        MimeType mimeType = mimeTypes.get(mimeTypeString);
        if (mimeType == null) {
            mimeType = new MimeType(mimeTypeString);
        }
        return mimeType;
    }

    public void defineFileExtension(String extension) {
        if (extension == null || extension.trim().length() == 0) {
            throw new IllegalArgumentException("The extension cannot be null or blank!");
        }
        fileExtensions.put(extension, this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mimeTypeString == null ? 0 : this.mimeTypeString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MimeType other = (MimeType)obj;
        return !(this.mimeTypeString == null ? other.mimeTypeString != null : !this.mimeTypeString.equals(other.mimeTypeString));
    }

    public String toString() {
        return "MimeType [mimeTypeString=" + this.mimeTypeString + "]";
    }

    static {
        fileExtensions.put("xml", XML);
        fileExtensions.put("html", HTML);
        fileExtensions.put("pkcs7", PKCS7);
        fileExtensions.put("p7m", PKCS7);
        fileExtensions.put("p7s", PKCS7);
        fileExtensions.put("pdf", PDF);
        fileExtensions.put("json", JSON);
        fileExtensions.put("zip", ZIP);
        fileExtensions.put("asics", ASICS);
        fileExtensions.put("scs", ASICS);
        fileExtensions.put("asice", ASICE);
        fileExtensions.put("sce", ASICE);
        fileExtensions.put("bdoc", ASICE);
        fileExtensions.put("odt", ODT);
        fileExtensions.put("ods", ODS);
        fileExtensions.put("odp", ODP);
        fileExtensions.put("odg", ODG);
        fileExtensions.put("txt", TEXT);
        fileExtensions.put("png", PNG);
        fileExtensions.put("jpg", JPEG);
        fileExtensions.put("jpeg", JPEG);
        fileExtensions.put("svg", SVG);
        fileExtensions.put("tst", TST);
    }
}

