/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation.scope;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.jades.HTTPHeader;
import eu.europa.esig.dss.jades.HTTPHeaderDigest;
import eu.europa.esig.dss.jades.HTTPHeaderMessageBodySignatureScope;
import eu.europa.esig.dss.jades.HTTPHeaderSignatureScope;
import eu.europa.esig.dss.jades.signature.HttpHeadersPayloadBuilder;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.validation.scope.CounterSignatureScope;
import eu.europa.esig.dss.validation.scope.DigestSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESSignatureScopeFinder
extends AbstractSignatureScopeFinder
implements SignatureScopeFinder<JAdESSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESSignatureScopeFinder.class);

    @Override
    public List<SignatureScope> findSignatureScope(JAdESSignature jadesSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        List<DSSDocument> originalDocuments = this.getOriginalDocuments(jadesSignature);
        if (Utils.isCollectionEmpty(originalDocuments)) {
            return result;
        }
        List<ReferenceValidation> referenceValidations = jadesSignature.getReferenceValidations();
        for (ReferenceValidation referenceValidation : referenceValidations) {
            if (!referenceValidation.isIntact()) continue;
            if (originalDocuments.get(0) instanceof HTTPHeader) {
                return this.getHttpHeaderSignatureScope(originalDocuments);
            }
            if (originalDocuments.size() == 1) {
                if (jadesSignature.isCounterSignature()) {
                    return Collections.singletonList(new CounterSignatureScope(this.getTokenIdentifierProvider().getIdAsString(jadesSignature.getMasterSignature()), this.getDigest(originalDocuments.get(0))));
                }
                return Collections.singletonList(this.getSignatureScopeFromOriginalDocument(originalDocuments.get(0)));
            }
            if (referenceValidations.size() == 1) {
                return this.getSignatureScopeFromOriginalDocuments(originalDocuments);
            }
            if (referenceValidation.getName() == null) continue;
            DSSDocument documentByName = this.getDocumentByName(originalDocuments, referenceValidation.getName());
            result.add(this.getSignatureScopeFromOriginalDocument(documentByName));
        }
        return result;
    }

    protected List<DSSDocument> getOriginalDocuments(JAdESSignature jadesSignature) {
        try {
            return jadesSignature.getOriginalDocuments();
        }
        catch (DSSException e) {
            LOG.warn("A JAdES signer's original document is not found [{}].", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    protected SignatureScope getSignatureScopeFromOriginalDocument(DSSDocument originalDocument) {
        if (originalDocument instanceof DigestDocument) {
            DigestDocument digestDocument = (DigestDocument)originalDocument;
            return new DigestSignatureScope(originalDocument.getName(), digestDocument.getExistingDigest());
        }
        return new FullSignatureScope(originalDocument.getName(), this.getDigest(originalDocument));
    }

    private DSSDocument getDocumentByName(List<DSSDocument> documents, String documentName) {
        documentName = DSSUtils.decodeURI(documentName);
        for (DSSDocument document : documents) {
            if (!documentName.equals(document.getName())) continue;
            return document;
        }
        return null;
    }

    protected List<SignatureScope> getSignatureScopeFromOriginalDocuments(List<DSSDocument> originalDocuments) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        if (Utils.isCollectionEmpty(originalDocuments)) {
            return result;
        }
        for (DSSDocument originalDocument : originalDocuments) {
            String documentName;
            String string = documentName = originalDocument.getName() != null ? originalDocument.getName() : "Detached content";
            if (originalDocument instanceof HTTPHeader) {
                return this.getHttpHeaderSignatureScope(originalDocuments);
            }
            if (originalDocument instanceof DigestDocument) {
                DigestDocument digestDocument = (DigestDocument)originalDocument;
                result.add(new DigestSignatureScope(documentName, digestDocument.getExistingDigest()));
                continue;
            }
            result.add(new FullSignatureScope(documentName, this.getDigest(originalDocument)));
        }
        return result;
    }

    private List<SignatureScope> getHttpHeaderSignatureScope(List<DSSDocument> originalDocuments) {
        ArrayList<SignatureScope> httpHeadersSignatureScopes = new ArrayList<SignatureScope>();
        SignatureScope httpHeadersPayloadSignatureScope = this.getHttpHeadersPayloadSignatureScope(originalDocuments);
        httpHeadersSignatureScopes.add(httpHeadersPayloadSignatureScope);
        for (DSSDocument document : originalDocuments) {
            if (!"Digest".equals(document.getName()) || !(document instanceof HTTPHeader)) continue;
            SignatureScope httpHeaderDigestSignatureScope = this.getHttpHeaderDigestSignatureScope((HTTPHeader)document);
            if (httpHeaderDigestSignatureScope == null) break;
            httpHeadersSignatureScopes.add(httpHeaderDigestSignatureScope);
            break;
        }
        return httpHeadersSignatureScopes;
    }

    private SignatureScope getHttpHeadersPayloadSignatureScope(List<DSSDocument> originalDocuments) {
        HttpHeadersPayloadBuilder httpHeadersPayloadBuilder = new HttpHeadersPayloadBuilder(originalDocuments, false);
        byte[] payload = httpHeadersPayloadBuilder.build();
        byte[] digest = DSSUtils.digest(this.getDefaultDigestAlgorithm(), payload);
        return new HTTPHeaderSignatureScope(new Digest(this.getDefaultDigestAlgorithm(), digest));
    }

    private SignatureScope getHttpHeaderDigestSignatureScope(HTTPHeader digestHttpHeader) {
        Digest digest = this.getDigest(digestHttpHeader.getValue());
        if (digest != null) {
            if (digestHttpHeader instanceof HTTPHeaderDigest) {
                HTTPHeaderDigest httpHeaderDigest = (HTTPHeaderDigest)digestHttpHeader;
                return new HTTPHeaderMessageBodySignatureScope(httpHeaderDigest.getMessageBodyDocument().getName(), digest);
            }
            return new HTTPHeaderMessageBodySignatureScope(digest);
        }
        return null;
    }

    private Digest getDigest(String digestHeaderValue) {
        String[] valueParts = digestHeaderValue.split("=");
        if (valueParts.length == 2) {
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forHttpHeader(valueParts[0]);
            byte[] digestValue = Utils.fromBase64(valueParts[1]);
            return new Digest(digestAlgorithm, digestValue);
        }
        LOG.warn("Not conformant value of 'Digest' header : '{}'!", (Object)digestHeaderValue);
        return null;
    }
}

