/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JAdESTimestampParameters;
import eu.europa.esig.dss.jades.JWSJsonSerializationGenerator;
import eu.europa.esig.dss.jades.JWSJsonSerializationObject;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.signature.JAdESExtensionBuilder;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineExtension;
import eu.europa.esig.dss.jades.validation.AbstractJWSDocumentValidator;
import eu.europa.esig.dss.jades.validation.JAdESDocumentValidatorFactory;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class JAdESLevelBaselineT
extends JAdESExtensionBuilder
implements JAdESLevelBaselineExtension {
    protected final CertificateVerifier certificateVerifier;
    protected TSPSource tspSource;
    protected AbstractJWSDocumentValidator documentValidator;
    private SigningOperation operationKind;

    public JAdESLevelBaselineT(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    public void setTspSource(TSPSource tspSource) {
        this.tspSource = tspSource;
    }

    @Override
    public void setOperationKind(SigningOperation signingOperation) {
        this.operationKind = signingOperation;
    }

    @Override
    public DSSDocument extendSignatures(DSSDocument document, JAdESSignatureParameters params) {
        Objects.requireNonNull(document, "The document cannot be null");
        Objects.requireNonNull(this.tspSource, "The TSPSource cannot be null");
        JAdESDocumentValidatorFactory documentValidatorFactory = new JAdESDocumentValidatorFactory();
        this.documentValidator = documentValidatorFactory.create(document);
        this.documentValidator.setCertificateVerifier(this.certificateVerifier);
        this.documentValidator.setDetachedContents(params.getDetachedContents());
        JWSJsonSerializationObject jwsJsonSerializationObject = this.documentValidator.getJwsJsonSerializationObject();
        this.assertJWSJsonSerializationObjectValid(jwsJsonSerializationObject);
        List<AdvancedSignature> signatures = this.documentValidator.getSignatures();
        if (Utils.isCollectionEmpty(signatures)) {
            throw new IllegalInputException("There is no signature to extend!");
        }
        List<AdvancedSignature> signaturesToExtend = signatures;
        if (SigningOperation.SIGN.equals((Object)this.operationKind)) {
            signaturesToExtend = Arrays.asList(signatures.get(signatures.size() - 1));
        }
        this.extendSignatures(signaturesToExtend, params);
        JWSJsonSerializationGenerator generator = new JWSJsonSerializationGenerator(jwsJsonSerializationObject, params.getJwsSerializationType());
        return generator.generate();
    }

    protected void extendSignatures(List<AdvancedSignature> signatures, JAdESSignatureParameters params) {
        SignatureRequirementsChecker signatureRequirementsChecker = new SignatureRequirementsChecker(this.certificateVerifier, params);
        for (AdvancedSignature signature : signatures) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            this.assertEtsiUComponentsConsistent(jadesSignature.getJws(), params.isBase64UrlEncodedEtsiUComponents());
            if (!this.tLevelExtensionRequired(jadesSignature, params)) continue;
            this.assertExtendSignatureToTPossible(jadesSignature, params);
            signatureRequirementsChecker.assertSigningCertificateIsValid(signature);
            JAdESTimestampParameters signatureTimestampParameters = params.getSignatureTimestampParameters();
            DigestAlgorithm digestAlgorithmForTimestampRequest = signatureTimestampParameters.getDigestAlgorithm();
            byte[] messageImprint = jadesSignature.getTimestampSource().getSignatureTimestampData();
            byte[] digest = DSSUtils.digest(digestAlgorithmForTimestampRequest, messageImprint);
            TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithmForTimestampRequest, digest);
            JsonObject tstContainer = DSSJsonUtils.getTstContainer(Collections.singletonList(timeStampResponse), null);
            JAdESEtsiUHeader etsiUHeader = jadesSignature.getEtsiUHeader();
            etsiUHeader.addComponent("sigTst", tstContainer, params.isBase64UrlEncodedEtsiUComponents());
        }
    }

    private boolean tLevelExtensionRequired(JAdESSignature jadesSignature, JAdESSignatureParameters parameters) {
        return SignatureLevel.JAdES_BASELINE_T.equals((Object)parameters.getSignatureLevel()) || !jadesSignature.hasTProfile();
    }

    private void assertExtendSignatureToTPossible(JAdESSignature jadesSignature, JAdESSignatureParameters params) {
        SignatureLevel signatureLevel = params.getSignatureLevel();
        if (SignatureLevel.JAdES_BASELINE_T.equals((Object)signatureLevel) && (jadesSignature.hasLTAProfile() || jadesSignature.hasLTProfile() && !jadesSignature.areAllSelfSignedCertificates())) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already extended with LT level.", new Object[]{signatureLevel}));
        }
    }
}

