/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.CommitmentType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.HTTPHeader;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.signature.HttpHeadersPayloadBuilder;
import eu.europa.esig.dss.model.CommitmentQualifier;
import eu.europa.esig.dss.model.CommonCommitmentType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SignerLocation;
import eu.europa.esig.dss.model.SpDocSpecification;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.UserNotice;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.BaselineBCertificateSelector;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jose4j.json.JsonUtil;
import org.jose4j.json.internal.json_simple.JSONArray;
import org.jose4j.keys.X509Util;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESLevelBaselineB {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESLevelBaselineB.class);
    private final CertificateVerifier certificateVerifier;
    private final JAdESSignatureParameters parameters;
    private final List<DSSDocument> documentsToSign;
    private Map<String, Object> signedProperties = new LinkedHashMap<String, Object>();

    public JAdESLevelBaselineB(CertificateVerifier certificateVerifier, JAdESSignatureParameters parameters, List<DSSDocument> documentsToSign) {
        Objects.requireNonNull(certificateVerifier, "certificateVerifier must not be null!");
        Objects.requireNonNull(certificateVerifier, "signatureParameters must be defined!");
        if (Utils.isCollectionEmpty(documentsToSign)) {
            throw new IllegalArgumentException("Documents to sign must be provided!");
        }
        this.certificateVerifier = certificateVerifier;
        this.parameters = parameters;
        this.documentsToSign = documentsToSign;
    }

    public Map<String, Object> getSignedProperties() {
        this.incorporateSignatureAlgorithm();
        this.incorporateContentType();
        this.incorporateKeyIdentifier();
        this.incorporateSigningCertificateUri();
        this.incorporateSigningCertificate();
        this.incorporateCertificateChain();
        this.incorporateType();
        this.incorporateB64();
        this.incorporateSigningTime();
        this.incorporateX509CertificateDigests();
        this.incorporateSignerCommitments();
        this.incorporateSignatureProductionPlace();
        this.incorporateSignerRoles();
        this.incorporateContentTimestamps();
        this.incorporateSignaturePolicy();
        this.incorporateDetachedContents();
        this.incorporateCritical();
        return this.signedProperties;
    }

    protected void incorporateSignatureAlgorithm() {
        String id = this.parameters.getSignatureAlgorithm().getJWAId();
        if (!Utils.isStringNotEmpty(id)) {
            throw new UnsupportedOperationException(String.format("The defined signature algorithm '%s' is not supported!", this.parameters.getSignatureAlgorithm()));
        }
        this.addHeader("alg", id);
    }

    protected void incorporateContentType() {
        if (SignaturePackaging.DETACHED.equals((Object)this.parameters.getSignaturePackaging())) {
            return;
        }
        MimeType mimeType = this.documentsToSign.get(0).getMimeType();
        if (mimeType != null) {
            String mimeTypeString = this.getRFC7515ConformantMimeTypeString(mimeType);
            this.addHeader("cty", mimeTypeString);
        }
    }

    private String getRFC7515ConformantMimeTypeString(MimeType mimeType) {
        String mimeTypeString = mimeType.getMimeTypeString();
        String shortMimeTypeString = DSSUtils.stripFirstLeadingOccurrence(mimeTypeString, "application/");
        if (!shortMimeTypeString.contains("/")) {
            return shortMimeTypeString;
        }
        return mimeTypeString;
    }

    protected void incorporateKeyIdentifier() {
        if (this.parameters.isIncludeKeyIdentifier() && this.parameters.getSigningCertificate() != null) {
            this.addHeader("kid", DSSJsonUtils.generateKid(this.parameters.getSigningCertificate()));
        }
    }

    protected void incorporateSigningCertificateUri() {
    }

    protected void incorporateSigningCertificate() {
        CertificateToken signingCertificate = this.parameters.getSigningCertificate();
        if (signingCertificate == null) {
            return;
        }
        DigestAlgorithm signingCertificateDigestMethod = this.parameters.getSigningCertificateDigestMethod();
        if (DigestAlgorithm.SHA256.equals(signingCertificateDigestMethod)) {
            this.incorporateSigningCertificateSha256Thumbprint(signingCertificate);
        } else {
            this.incorporateSigningCertificateOtherDigestReference(signingCertificate, signingCertificateDigestMethod);
        }
    }

    protected void incorporateSigningCertificateSha256Thumbprint(CertificateToken signingCertificate) {
        String x5tS256 = X509Util.x5tS256(signingCertificate.getCertificate());
        this.addHeader("x5t#S256", x5tS256);
    }

    protected void incorporateCertificateChain() {
        if (!this.parameters.isIncludeCertificateChain() || this.parameters.getSigningCertificate() == null) {
            return;
        }
        BaselineBCertificateSelector certificateSelector = new BaselineBCertificateSelector(this.certificateVerifier, this.parameters);
        List<CertificateToken> certificates = certificateSelector.getCertificates();
        ArrayList<String> base64Certificates = new ArrayList<String>();
        for (CertificateToken certificateToken : certificates) {
            base64Certificates.add(Utils.toBase64(certificateToken.getEncoded()));
        }
        this.addHeader("x5c", new JSONArray(base64Certificates));
    }

    protected void incorporateCritical() {
        ArrayList<String> criticalHeaderNames = new ArrayList<String>();
        for (String header : this.signedProperties.keySet()) {
            if (DSSJsonUtils.isCriticalHeaderException(header)) continue;
            criticalHeaderNames.add(header);
        }
        if (Utils.isCollectionNotEmpty(criticalHeaderNames)) {
            this.addHeader("crit", new JSONArray(criticalHeaderNames));
        }
    }

    protected void incorporateType() {
        if (this.parameters.isIncludeSignatureType()) {
            MimeType signatureMimeType;
            switch (this.parameters.getJwsSerializationType()) {
                case COMPACT_SERIALIZATION: {
                    signatureMimeType = MimeType.JOSE;
                    break;
                }
                case JSON_SERIALIZATION: 
                case FLATTENED_JSON_SERIALIZATION: {
                    signatureMimeType = MimeType.JOSE_JSON;
                    break;
                }
                default: {
                    throw new DSSException(String.format("The given JWS serialization type '%s' is not supported!", new Object[]{this.parameters.getJwsSerializationType()}));
                }
            }
            String type = this.getRFC7515ConformantMimeTypeString(signatureMimeType);
            this.addHeader("typ", type);
        }
    }

    protected void incorporateB64() {
        if (!this.parameters.isBase64UrlEncodedPayload()) {
            this.assertPayloadEncodingValid();
            this.addHeader("b64", this.parameters.isBase64UrlEncodedPayload());
        }
    }

    private void assertPayloadEncodingValid() {
        byte[] payloadBytes = this.getPayloadBytes();
        if (!this.parameters.isBase64UrlEncodedPayload() && !SignaturePackaging.DETACHED.equals((Object)this.parameters.getSignaturePackaging()) && Utils.isArrayNotEmpty(payloadBytes)) {
            switch (this.parameters.getJwsSerializationType()) {
                case COMPACT_SERIALIZATION: {
                    if (DSSJsonUtils.isUrlSafePayload(new String(payloadBytes))) break;
                    throw new IllegalInputException("The payload contains not URL-safe characters! With Unencoded Payload ('b64' = false) only ASCII characters in ranges %x20-2D and %x2F-7E are allowed for a COMPACT_SERIALIZATION!");
                }
                case JSON_SERIALIZATION: 
                case FLATTENED_JSON_SERIALIZATION: {
                    if (DSSJsonUtils.isUtf8(payloadBytes)) break;
                    throw new IllegalInputException("The payload contains not valid content! With Unencoded Payload ('b64' = false) only UTF-8 characters are allowed!");
                }
                default: {
                    throw new DSSException(String.format("The JWSSerializationType '%s' is not supported!", new Object[]{this.parameters.getJwsSerializationType()}));
                }
            }
        }
    }

    protected void incorporateSigningTime() {
        Date signingDate = this.parameters.bLevel().getSigningDate();
        String stringSigningTime = DSSUtils.formatDateToRFC(signingDate);
        this.addHeader("sigT", stringSigningTime);
    }

    protected void incorporateSigningCertificateOtherDigestReference(CertificateToken signingCertificate, DigestAlgorithm digestAlgorithm) {
        byte[] digestValue = signingCertificate.getDigest(digestAlgorithm);
        LinkedHashMap<String, Object> x5toParams = new LinkedHashMap<String, Object>();
        x5toParams.put("digAlg", digestAlgorithm.getJAdESId());
        x5toParams.put("digVal", DSSJsonUtils.toBase64Url(digestValue));
        this.addHeader("x5t#o", new JsonObject(x5toParams));
    }

    protected void incorporateX509CertificateDigests() {
    }

    protected void incorporateSignerCommitments() {
        if (Utils.isCollectionEmpty(this.parameters.bLevel().getCommitmentTypeIndications())) {
            return;
        }
        ArrayList<JsonObject> srCms = new ArrayList<JsonObject>();
        for (CommitmentType commitmentType : this.parameters.bLevel().getCommitmentTypeIndications()) {
            if (Utils.isStringEmpty(commitmentType.getUri()) && Utils.isStringEmpty(commitmentType.getOid())) {
                throw new IllegalArgumentException("Either URI or OID shall be defined for CommitmentType signed attribute in JAdES!");
            }
            LinkedHashMap<String, Object> srCmParams = new LinkedHashMap<String, Object>();
            JsonObject oidObject = DSSJsonUtils.getOidObject(commitmentType);
            srCmParams.put("commId", oidObject);
            List<JsonObject> commQuals = this.getCommitmentQualifiers(commitmentType);
            if (Utils.isCollectionNotEmpty(commQuals)) {
                srCmParams.put("commQuals", commQuals);
            }
            srCms.add(new JsonObject(srCmParams));
        }
        this.addHeader("srCms", new JSONArray(srCms));
    }

    private List<JsonObject> getCommitmentQualifiers(CommitmentType commitmentType) {
        Object[] commitmentQualifiers;
        ArrayList<JsonObject> commQuals = new ArrayList<JsonObject>();
        if (commitmentType instanceof CommonCommitmentType && Utils.isArrayNotEmpty(commitmentQualifiers = ((CommonCommitmentType)commitmentType).getCommitmentTypeQualifiers())) {
            for (Object commitmentQualifier : commitmentQualifiers) {
                Objects.requireNonNull(commitmentQualifier, "CommitmentTypeQualifier cannot be null!");
                DSSDocument content = ((CommitmentQualifier)commitmentQualifier).getContent();
                if (content == null) {
                    throw new IllegalArgumentException("CommitmentTypeQualifier content cannot be null!");
                }
                if (DSSJsonUtils.isJsonDocument(content)) {
                    try {
                        String jsonDocument = new String(DSSUtils.toByteArray(content));
                        Map<String, Object> object = JsonUtil.parseJson(jsonDocument);
                        commQuals.add(new JsonObject(object));
                        continue;
                    }
                    catch (JoseException e) {
                        throw new IllegalArgumentException(String.format("Unable to parse JSON Commitment Type Qualifier : %s", e.getMessage()), e);
                    }
                }
                LOG.info("None JSON encoded CommitmentTypeQualifier has been provided. Incorporate as JSONObject.");
                JsonObject jsonObject = new JsonObject();
                jsonObject.put("val", (Object)new String(DSSUtils.toByteArray(content)));
                commQuals.add(jsonObject);
            }
        }
        return commQuals;
    }

    protected void incorporateSignatureProductionPlace() {
        SignerLocation signerProductionPlace = this.parameters.bLevel().getSignerLocation();
        if (signerProductionPlace != null && !signerProductionPlace.isEmpty()) {
            String city = signerProductionPlace.getLocality();
            String streetAddress = signerProductionPlace.getStreetAddress();
            String stateOrProvince = signerProductionPlace.getStateOrProvince();
            String postOfficeBoxNumber = signerProductionPlace.getPostOfficeBoxNumber();
            String postalCode = signerProductionPlace.getPostalCode();
            String country = signerProductionPlace.getCountry();
            LinkedHashMap<String, Object> sigPlaceMap = new LinkedHashMap<String, Object>();
            if (country != null) {
                sigPlaceMap.put("addressCountry", country);
            }
            if (city != null) {
                sigPlaceMap.put("addressLocality", city);
            }
            if (stateOrProvince != null) {
                sigPlaceMap.put("addressRegion", stateOrProvince);
            }
            if (postOfficeBoxNumber != null) {
                sigPlaceMap.put("postOfficeBoxNumber", postOfficeBoxNumber);
            }
            if (postalCode != null) {
                sigPlaceMap.put("postalCode", postalCode);
            }
            if (streetAddress != null) {
                sigPlaceMap.put("streetAddress", streetAddress);
            }
            this.addHeader("sigPl", new JsonObject(sigPlaceMap));
        }
    }

    protected void incorporateSignerRoles() {
        List<String> signedAssertions;
        LinkedHashMap<String, Object> srAtsParams = new LinkedHashMap<String, Object>();
        List<String> claimedSignerRoles = this.parameters.bLevel().getClaimedSignerRoles();
        if (Utils.isCollectionNotEmpty(claimedSignerRoles)) {
            srAtsParams.put("claimed", this.getQArray(claimedSignerRoles));
        }
        if (Utils.isCollectionNotEmpty(signedAssertions = this.parameters.bLevel().getSignedAssertions())) {
            srAtsParams.put("signedAssertions", this.getQArray(signedAssertions));
        }
        if (Utils.isMapNotEmpty(srAtsParams)) {
            JsonObject srAtsParamsObject = new JsonObject(srAtsParams);
            this.addHeader("srAts", srAtsParamsObject);
        }
    }

    private JSONArray getQArray(List<String> qArrayVals) {
        ArrayList<JsonObject> qArrays = new ArrayList<JsonObject>();
        LinkedHashMap<String, Object> qArrayMap = new LinkedHashMap<String, Object>();
        qArrayMap.put("mediaType", MimeType.TEXT.getMimeTypeString());
        qArrayMap.put("encoding", "binary");
        qArrayMap.put("qVals", new JSONArray(qArrayVals));
        JsonObject qArray = new JsonObject(qArrayMap);
        qArrays.add(qArray);
        return new JSONArray(qArrays);
    }

    protected void incorporateContentTimestamps() {
        if (Utils.isCollectionEmpty(this.parameters.getContentTimestamps())) {
            return;
        }
        List<TimestampBinary> contentTimestampBinaries = this.toTimestampBinaries(this.parameters.getContentTimestamps());
        JsonObject tstContainer = DSSJsonUtils.getTstContainer(contentTimestampBinaries, null);
        this.addHeader("adoTst", tstContainer);
    }

    private List<TimestampBinary> toTimestampBinaries(List<TimestampToken> timestampTokens) {
        if (Utils.isCollectionEmpty(timestampTokens)) {
            return Collections.emptyList();
        }
        ArrayList<TimestampBinary> timestampBinaries = new ArrayList<TimestampBinary>();
        for (TimestampToken timestampToken : timestampTokens) {
            TimestampBinary timestampBinary = new TimestampBinary(timestampToken.getEncoded());
            timestampBinaries.add(timestampBinary);
        }
        return timestampBinaries;
    }

    protected void incorporateSignaturePolicy() {
        Policy signaturePolicy = this.parameters.bLevel().getSignaturePolicy();
        if (signaturePolicy != null && !signaturePolicy.isEmpty()) {
            this.assertSignaturePolicyValid(signaturePolicy);
            LinkedHashMap<String, Object> sigPIdParams = new LinkedHashMap<String, Object>();
            String signaturePolicyId = signaturePolicy.getId();
            JsonObject oid = DSSJsonUtils.getOidObject(signaturePolicyId, signaturePolicy.getDescription(), signaturePolicy.getDocumentationReferences());
            sigPIdParams.put("id", oid);
            if (signaturePolicy.getDigestAlgorithm() != null && signaturePolicy.getDigestValue() != null) {
                sigPIdParams.put("digAlg", signaturePolicy.getDigestAlgorithm().getJAdESId());
                sigPIdParams.put("digVal", DSSJsonUtils.toBase64Url(signaturePolicy.getDigestValue()));
            }
            if (signaturePolicy.isHashAsInTechnicalSpecification()) {
                sigPIdParams.put("digPSp", signaturePolicy.isHashAsInTechnicalSpecification());
            }
            if (signaturePolicy.isSPQualifierPresent()) {
                List<JsonObject> signaturePolicyQualifiers = this.getSignaturePolicyQualifiers(signaturePolicy);
                sigPIdParams.put("sigPQuals", signaturePolicyQualifiers);
            }
            this.addHeader("sigPId", new JsonObject(sigPIdParams));
        }
    }

    private void assertSignaturePolicyValid(Policy signaturePolicy) {
        if (Utils.isStringEmpty(signaturePolicy.getId())) {
            throw new IllegalArgumentException("Implicit policy is not allowed in JAdES! The signaturePolicyId attribute is required!");
        }
        if (signaturePolicy.isHashAsInTechnicalSpecification() && (signaturePolicy.getSpDocSpecification() == null || Utils.isStringEmpty(signaturePolicy.getSpDocSpecification().getId()))) {
            throw new IllegalArgumentException("SpDocSpecification shall be defined when DigestAsInTechnicalSpecification is set to true!");
        }
    }

    private List<JsonObject> getSignaturePolicyQualifiers(Policy signaturePolicy) {
        SpDocSpecification spDocSpecification;
        UserNotice userNotice;
        ArrayList<JsonObject> sigPQualifiers = new ArrayList<JsonObject>();
        String spuri = signaturePolicy.getSpuri();
        if (Utils.isStringNotEmpty(spuri)) {
            LinkedHashMap<String, Object> qualifier = new LinkedHashMap<String, Object>();
            qualifier.put("spURI", spuri);
            sigPQualifiers.add(new JsonObject(qualifier));
        }
        if ((userNotice = signaturePolicy.getUserNotice()) != null && !userNotice.isEmpty()) {
            String explicitText;
            LinkedHashMap<String, Object> spUserNotice = new LinkedHashMap<String, Object>();
            String organization = userNotice.getOrganization();
            int[] noticeNumbers = userNotice.getNoticeNumbers();
            if (Utils.isStringNotEmpty(organization) && noticeNumbers != null && noticeNumbers.length > 0) {
                LinkedHashMap<String, Object> noticeRef = new LinkedHashMap<String, Object>();
                noticeRef.put("organization", organization);
                noticeRef.put("noticeNumbers", noticeNumbers);
                spUserNotice.put("noticeRef", new JsonObject(noticeRef));
            }
            if (Utils.isStringNotEmpty(explicitText = userNotice.getExplicitText())) {
                spUserNotice.put("explText", explicitText);
            }
            LinkedHashMap<String, Object> qualifier = new LinkedHashMap<String, Object>();
            qualifier.put("spUserNotice", new JsonObject(spUserNotice));
            sigPQualifiers.add(new JsonObject(qualifier));
        }
        if ((spDocSpecification = signaturePolicy.getSpDocSpecification()) != null && Utils.isStringNotEmpty(spDocSpecification.getId())) {
            JsonObject spDSpec = DSSJsonUtils.getOidObject(spDocSpecification.getId(), spDocSpecification.getDescription(), spDocSpecification.getDocumentationReferences());
            LinkedHashMap<String, Object> qualifier = new LinkedHashMap<String, Object>();
            qualifier.put("spDSpec", spDSpec);
            sigPQualifiers.add(new JsonObject(qualifier));
        }
        return sigPQualifiers;
    }

    protected void incorporateDetachedContents() {
        if (SignaturePackaging.DETACHED.equals((Object)this.parameters.getSignaturePackaging())) {
            Map<String, Object> sigDParams;
            this.assertDetachedContentValid();
            switch (this.parameters.getSigDMechanism()) {
                case HTTP_HEADERS: {
                    this.assertHttpHeadersConfigurationValid();
                    sigDParams = this.getSigDForHttpHeadersMechanism(this.documentsToSign);
                    break;
                }
                case OBJECT_ID_BY_URI: {
                    sigDParams = this.getSigDForObjectIdByUriMechanism(this.documentsToSign);
                    break;
                }
                case OBJECT_ID_BY_URI_HASH: {
                    sigDParams = this.getSigDForObjectIdByUriHashMechanism(this.documentsToSign);
                    break;
                }
                case NO_SIG_D: {
                    return;
                }
                default: {
                    throw new DSSException(String.format("The 'sigD' mechanism '%s' is not supported!", this.parameters.getSigDMechanism()));
                }
            }
            this.addHeader("sigD", new JsonObject(sigDParams));
        }
    }

    private void assertDetachedContentValid() {
        SigDMechanism sigDMechanism = this.parameters.getSigDMechanism();
        if (sigDMechanism == null) {
            throw new IllegalArgumentException("The SigDMechanism is not defined for a detached signature! Please use JAdESSignatureParameters.setSigDMechanism(sigDMechanism) method.");
        }
        if (SigDMechanism.NO_SIG_D.equals(sigDMechanism)) {
            if (Utils.collectionSize(this.documentsToSign) > 1) {
                throw new IllegalArgumentException(String.format("Only one detached document is allowed with '%s' mechanism!", SigDMechanism.NO_SIG_D.name()));
            }
        } else {
            ArrayList<String> documentNames = new ArrayList<String>();
            for (DSSDocument document : this.documentsToSign) {
                if (Utils.isStringEmpty(document.getName())) {
                    throw new IllegalArgumentException("The signed document must have names for a detached JAdES signature!");
                }
                if (!SigDMechanism.HTTP_HEADERS.equals(sigDMechanism) && documentNames.contains(document.getName())) {
                    throw new IllegalArgumentException(String.format("The documents to be signed shall have different names! The name '%s' appears multiple times.", document.getName()));
                }
                documentNames.add(document.getName());
            }
        }
    }

    private void assertHttpHeadersConfigurationValid() {
        if (SigDMechanism.HTTP_HEADERS.equals(this.parameters.getSigDMechanism()) && this.parameters.isBase64UrlEncodedPayload()) {
            throw new IllegalArgumentException(String.format("'%s' SigD Mechanism can be used only with non-base64url encoded payload! Set JAdESSignatureParameters.setBase64UrlEncodedPayload(false).", SigDMechanism.HTTP_HEADERS.getUri()));
        }
    }

    private Map<String, Object> getSigDForHttpHeadersMechanism(List<DSSDocument> detachedContents) {
        LinkedHashMap<String, Object> sigDParams = new LinkedHashMap<String, Object>();
        sigDParams.put("mId", SigDMechanism.HTTP_HEADERS.getUri());
        sigDParams.put("pars", this.getHttpHeaderNames(detachedContents));
        return sigDParams;
    }

    private Map<String, Object> getSigDForObjectIdByUriMechanism(List<DSSDocument> detachedContents) {
        LinkedHashMap<String, Object> sigDParams = new LinkedHashMap<String, Object>();
        sigDParams.put("mId", SigDMechanism.OBJECT_ID_BY_URI.getUri());
        sigDParams.put("pars", this.getSignedDataReferences(detachedContents));
        sigDParams.put("ctys", this.getSignedDataMimeTypesIfPresent(detachedContents));
        return sigDParams;
    }

    private Map<String, Object> getSigDForObjectIdByUriHashMechanism(List<DSSDocument> detachedContents) {
        LinkedHashMap<String, Object> sigDParams = new LinkedHashMap<String, Object>();
        sigDParams.put("mId", SigDMechanism.OBJECT_ID_BY_URI_HASH.getUri());
        sigDParams.put("pars", this.getSignedDataReferences(detachedContents));
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault();
        sigDParams.put("hashM", digestAlgorithm.getJAdESId());
        sigDParams.put("hashV", this.getSignedDataDigests(detachedContents, digestAlgorithm));
        sigDParams.put("ctys", this.getSignedDataMimeTypesIfPresent(detachedContents));
        return sigDParams;
    }

    private JSONArray getSignedDataReferences(List<DSSDocument> detachedContents) {
        ArrayList<String> references = new ArrayList<String>();
        for (DSSDocument document : detachedContents) {
            references.add(document.getName());
        }
        return new JSONArray(references);
    }

    private DigestAlgorithm getReferenceDigestAlgorithmOrDefault() {
        return this.parameters.getReferenceDigestAlgorithm() != null ? this.parameters.getReferenceDigestAlgorithm() : this.parameters.getDigestAlgorithm();
    }

    private JSONArray getSignedDataDigests(List<DSSDocument> detachedContents, DigestAlgorithm digestAlgorithm) {
        ArrayList<String> digests = new ArrayList<String>();
        for (DSSDocument document : detachedContents) {
            byte[] docDigest;
            if (!this.parameters.isBase64UrlEncodedPayload() || document instanceof DigestDocument) {
                String base64Digest = document.getDigest(digestAlgorithm);
                docDigest = Utils.fromBase64(base64Digest);
            } else {
                byte[] base64urlDocumentContent = DSSJsonUtils.toBase64Url(document).getBytes();
                docDigest = DSSUtils.digest(digestAlgorithm, base64urlDocumentContent);
            }
            digests.add(DSSJsonUtils.toBase64Url(docDigest));
        }
        return new JSONArray(digests);
    }

    private JSONArray getSignedDataMimeTypesIfPresent(List<DSSDocument> detachedContents) {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        for (DSSDocument document : detachedContents) {
            MimeType mimeType = document.getMimeType();
            if (mimeType == null) {
                mimeType = MimeType.BINARY;
            }
            String rfc7515MimeType = this.getRFC7515ConformantMimeTypeString(mimeType);
            mimeTypes.add(rfc7515MimeType);
        }
        return new JSONArray(mimeTypes);
    }

    private Collection<String> getHttpHeaderNames(List<DSSDocument> detachedContents) {
        ArrayList<String> httpHeaderNames = new ArrayList<String>();
        for (DSSDocument document : detachedContents) {
            String headerName;
            if (!(document instanceof HTTPHeader) || httpHeaderNames.contains(headerName = Utils.lowerCase(document.getName()))) continue;
            httpHeaderNames.add(headerName);
        }
        return httpHeaderNames;
    }

    protected void addHeader(String headerName, Object value) {
        this.signedProperties.put(headerName, value);
    }

    public byte[] getPayloadBytes() {
        if (!SignaturePackaging.DETACHED.equals((Object)this.parameters.getSignaturePackaging()) || SigDMechanism.NO_SIG_D.equals(this.parameters.getSigDMechanism())) {
            return this.getIncorporatedPayload();
        }
        if (SigDMechanism.HTTP_HEADERS.equals(this.parameters.getSigDMechanism())) {
            return this.getPayloadForHttpHeadersMechanism();
        }
        if (SigDMechanism.OBJECT_ID_BY_URI.equals(this.parameters.getSigDMechanism())) {
            return this.getPayloadForObjectIdByUriMechanism();
        }
        if (SigDMechanism.OBJECT_ID_BY_URI_HASH.equals(this.parameters.getSigDMechanism())) {
            return DSSUtils.EMPTY_BYTE_ARRAY;
        }
        throw new IllegalArgumentException("The configured signature format is not supported!");
    }

    private byte[] getIncorporatedPayload() {
        return DSSJsonUtils.getDocumentOctets(this.documentsToSign.get(0), this.parameters.isBase64UrlEncodedPayload());
    }

    private byte[] getPayloadForHttpHeadersMechanism() {
        HttpHeadersPayloadBuilder httpHeadersPayloadBuilder = new HttpHeadersPayloadBuilder(this.documentsToSign, false);
        return httpHeadersPayloadBuilder.build();
    }

    private byte[] getPayloadForObjectIdByUriMechanism() {
        return DSSJsonUtils.concatenateDSSDocuments(this.documentsToSign, this.parameters.isBase64UrlEncodedPayload());
    }
}

