/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.FoundCertificatesProxy;
import eu.europa.esig.dss.diagnostic.FoundRevocationsProxy;
import eu.europa.esig.dss.diagnostic.OrphanCertificateTokenWrapper;
import eu.europa.esig.dss.diagnostic.OrphanRevocationTokenWrapper;
import eu.europa.esig.dss.diagnostic.OrphanTokenWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.SignerDataWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlAbstractToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlObjectModification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificateToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocationToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFRevision;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFSignatureField;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TimestampWrapper
extends AbstractTokenProxy {
    private final XmlTimestamp timestamp;

    public TimestampWrapper(XmlTimestamp timestamp) {
        Objects.requireNonNull(timestamp, "XmlTimestamp cannot be null!");
        this.timestamp = timestamp;
    }

    @Override
    public String getId() {
        return this.timestamp.getId();
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.timestamp.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.timestamp.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.timestamp.getSigningCertificate();
    }

    @Override
    public FoundCertificatesProxy foundCertificates() {
        return new FoundCertificatesProxy(this.timestamp.getFoundCertificates());
    }

    @Override
    public FoundRevocationsProxy foundRevocations() {
        return new FoundRevocationsProxy(this.timestamp.getFoundRevocations());
    }

    public TimestampType getType() {
        return this.timestamp.getType();
    }

    public ArchiveTimestampType getArchiveTimestampType() {
        return this.timestamp.getArchiveTimestampType();
    }

    public Date getProductionTime() {
        return this.timestamp.getProductionTime();
    }

    public XmlDigestMatcher getMessageImprint() {
        for (XmlDigestMatcher digestMatcher : this.getDigestMatchers()) {
            if (!DigestMatcherType.MESSAGE_IMPRINT.equals((Object)digestMatcher.getType())) continue;
            return digestMatcher;
        }
        return null;
    }

    public boolean isMessageImprintDataFound() {
        XmlDigestMatcher messageImprint = this.getMessageImprint();
        if (messageImprint != null) {
            return messageImprint.isDataFound();
        }
        return false;
    }

    public boolean isMessageImprintDataIntact() {
        XmlDigestMatcher messageImprint = this.getMessageImprint();
        if (messageImprint != null) {
            return messageImprint.isDataIntact();
        }
        return false;
    }

    public String getFilename() {
        return this.timestamp.getTimestampFilename();
    }

    @Override
    public List<XmlDigestMatcher> getDigestMatchers() {
        return this.timestamp.getDigestMatchers();
    }

    public List<XmlTimestampedObject> getTimestampedObjects() {
        return this.timestamp.getTimestampedObjects();
    }

    public List<SignatureWrapper> getTimestampedSignatures() {
        ArrayList<SignatureWrapper> signatures = new ArrayList<SignatureWrapper>();
        List<XmlAbstractToken> timestampedObjectsByCategory = this.getTimestampedObjectsByCategory(TimestampedObjectType.SIGNATURE);
        for (XmlAbstractToken token : timestampedObjectsByCategory) {
            if (token instanceof XmlSignature) {
                signatures.add(new SignatureWrapper((XmlSignature)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.SIGNATURE}));
        }
        return signatures;
    }

    public List<CertificateWrapper> getTimestampedCertificates() {
        ArrayList<CertificateWrapper> certificates = new ArrayList<CertificateWrapper>();
        List<XmlAbstractToken> timestampedObjectsByCategory = this.getTimestampedObjectsByCategory(TimestampedObjectType.CERTIFICATE);
        for (XmlAbstractToken token : timestampedObjectsByCategory) {
            if (token instanceof XmlCertificate) {
                certificates.add(new CertificateWrapper((XmlCertificate)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.CERTIFICATE}));
        }
        return certificates;
    }

    public List<RevocationWrapper> getTimestampedRevocations() {
        ArrayList<RevocationWrapper> revocations = new ArrayList<RevocationWrapper>();
        List<XmlAbstractToken> timestampedObjectsByCategory = this.getTimestampedObjectsByCategory(TimestampedObjectType.REVOCATION);
        for (XmlAbstractToken token : timestampedObjectsByCategory) {
            if (token instanceof XmlRevocation) {
                revocations.add(new RevocationWrapper((XmlRevocation)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.REVOCATION}));
        }
        return revocations;
    }

    public List<TimestampWrapper> getTimestampedTimestamps() {
        ArrayList<TimestampWrapper> timestamps = new ArrayList<TimestampWrapper>();
        List<XmlAbstractToken> timestampedObjectsByCategory = this.getTimestampedObjectsByCategory(TimestampedObjectType.TIMESTAMP);
        for (XmlAbstractToken token : timestampedObjectsByCategory) {
            if (token instanceof XmlTimestamp) {
                timestamps.add(new TimestampWrapper((XmlTimestamp)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.TIMESTAMP}));
        }
        return timestamps;
    }

    public List<SignerDataWrapper> getTimestampedSignedData() {
        ArrayList<SignerDataWrapper> timestamps = new ArrayList<SignerDataWrapper>();
        List<XmlAbstractToken> timestampedObjectsByCategory = this.getTimestampedObjectsByCategory(TimestampedObjectType.SIGNED_DATA);
        for (XmlAbstractToken token : timestampedObjectsByCategory) {
            if (token instanceof XmlSignerData) {
                timestamps.add(new SignerDataWrapper((XmlSignerData)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.SIGNED_DATA}));
        }
        return timestamps;
    }

    public boolean isSigningCertificateIdentified() {
        CertificateWrapper signingCertificate = this.getSigningCertificate();
        CertificateRefWrapper signingCertificateReference = this.getSigningCertificateReference();
        if (signingCertificate != null && signingCertificateReference != null) {
            return signingCertificateReference.isDigestValueMatch() && (!signingCertificateReference.isIssuerSerialPresent() || signingCertificateReference.isIssuerSerialMatch());
        }
        return false;
    }

    private List<XmlAbstractToken> getTimestampedObjectsByCategory(TimestampedObjectType category) {
        ArrayList<XmlAbstractToken> timestampedObjectIds = new ArrayList<XmlAbstractToken>();
        for (XmlTimestampedObject timestampedObject : this.getTimestampedObjects()) {
            if (category != timestampedObject.getCategory()) continue;
            timestampedObjectIds.add(timestampedObject.getToken());
        }
        return timestampedObjectIds;
    }

    public List<OrphanTokenWrapper> getAllTimestampedOrphanTokens() {
        ArrayList<OrphanTokenWrapper> timestampedObjectIds = new ArrayList<OrphanTokenWrapper>();
        timestampedObjectIds.addAll(this.getTimestampedOrphanCertificates());
        timestampedObjectIds.addAll(this.getTimestampedOrphanRevocations());
        return timestampedObjectIds;
    }

    public List<OrphanCertificateTokenWrapper> getTimestampedOrphanCertificates() {
        ArrayList<OrphanCertificateTokenWrapper> orphanCertificates = new ArrayList<OrphanCertificateTokenWrapper>();
        List<XmlAbstractToken> timestampedObjectsByCategory = this.getTimestampedObjectsByCategory(TimestampedObjectType.ORPHAN_CERTIFICATE);
        for (XmlAbstractToken token : timestampedObjectsByCategory) {
            if (token instanceof XmlOrphanCertificateToken) {
                orphanCertificates.add(new OrphanCertificateTokenWrapper((XmlOrphanCertificateToken)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.ORPHAN_CERTIFICATE}));
        }
        return orphanCertificates;
    }

    public List<OrphanRevocationTokenWrapper> getTimestampedOrphanRevocations() {
        ArrayList<OrphanRevocationTokenWrapper> orphanRevocations = new ArrayList<OrphanRevocationTokenWrapper>();
        List<XmlAbstractToken> timestampedObjectsByCategory = this.getTimestampedObjectsByCategory(TimestampedObjectType.ORPHAN_REVOCATION);
        for (XmlAbstractToken token : timestampedObjectsByCategory) {
            if (token instanceof XmlOrphanRevocationToken) {
                orphanRevocations.add(new OrphanRevocationTokenWrapper((XmlOrphanRevocationToken)token));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unexpected token of type [%s] found. Expected : %s", new Object[]{token.getClass(), TimestampedObjectType.ORPHAN_REVOCATION}));
        }
        return orphanRevocations;
    }

    @Override
    public byte[] getBinaries() {
        return this.timestamp.getBase64Encoded();
    }

    public XmlDigestAlgoAndValue getDigestAlgoAndValue() {
        return this.timestamp.getDigestAlgoAndValue();
    }

    public XmlPDFRevision getPDFRevision() {
        return this.timestamp.getPDFRevision();
    }

    public boolean arePdfModificationsDetected() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        return this.arePdfModificationsDetected(pdfRevision);
    }

    public List<BigInteger> getPdfAnnotationsOverlapConcernedPages() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        return this.getPdfAnnotationsOverlapConcernedPages(pdfRevision);
    }

    public List<BigInteger> getPdfVisualDifferenceConcernedPages() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        return this.getPdfVisualDifferenceConcernedPages(pdfRevision);
    }

    public List<BigInteger> getPdfPageDifferenceConcernedPages() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        return this.getPdfPageDifferenceConcernedPages(pdfRevision);
    }

    public List<XmlObjectModification> getPdfExtensionChanges() {
        return this.getPdfExtensionChanges(this.timestamp.getPDFRevision());
    }

    public List<XmlObjectModification> getPdfSignatureOrFormFillChanges() {
        return this.getPdfSignatureOrFormFillChanges(this.timestamp.getPDFRevision());
    }

    public List<XmlObjectModification> getPdfAnnotationChanges() {
        return this.getPdfAnnotationChanges(this.timestamp.getPDFRevision());
    }

    public List<XmlObjectModification> getPdfUndefinedChanges() {
        return this.getPdfUndefinedChanges(this.timestamp.getPDFRevision());
    }

    public List<String> getModifiedFieldNames() {
        return this.getModifiedFieldNames(this.timestamp.getPDFRevision());
    }

    public String getFirstFieldName() {
        List<XmlPDFSignatureField> fields;
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        if (pdfRevision != null && (fields = pdfRevision.getFields()) != null && !fields.isEmpty()) {
            return fields.iterator().next().getName();
        }
        return null;
    }

    public List<String> getSignatureFieldNames() {
        List<XmlPDFSignatureField> fields;
        ArrayList<String> names = new ArrayList<String>();
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        if (pdfRevision != null && (fields = pdfRevision.getFields()) != null && !fields.isEmpty()) {
            for (XmlPDFSignatureField signatureField : fields) {
                names.add(signatureField.getName());
            }
        }
        return names;
    }

    public List<XmlSignerInfo> getSignatureInformationStore() {
        return this.timestamp.getSignerInformationStore();
    }

    public boolean isTSAGeneralNamePresent() {
        return this.timestamp.getTSAGeneralName() != null;
    }

    public String getTSAGeneralNameValue() {
        if (this.isTSAGeneralNamePresent()) {
            return this.timestamp.getTSAGeneralName().getValue();
        }
        return null;
    }

    public boolean isTSAGeneralNameMatch() {
        return this.isTSAGeneralNamePresent() && this.timestamp.getTSAGeneralName().isContentMatch();
    }

    public boolean isTSAGeneralNameOrderMatch() {
        return this.isTSAGeneralNamePresent() && this.timestamp.getTSAGeneralName().isOrderMatch();
    }

    public List<XmlSignatureScope> getTimestampScopes() {
        return this.timestamp.getTimestampScopes();
    }

    public String getSignerName() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getSignerName();
        }
        return null;
    }

    public String getSignatureDictionaryType() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getType();
        }
        return null;
    }

    public String getFilter() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getFilter();
        }
        return null;
    }

    public String getSubFilter() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getSubFilter();
        }
        return null;
    }

    public String getContactInfo() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getContactInfo();
        }
        return null;
    }

    public String getReason() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getReason();
        }
        return null;
    }

    public List<BigInteger> getSignatureByteRange() {
        XmlPDFRevision pdfRevision = this.timestamp.getPDFRevision();
        if (pdfRevision != null) {
            return pdfRevision.getPDFSignatureDictionary().getSignatureByteRange();
        }
        return Collections.emptyList();
    }
}

