/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.CertificateRefWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.FoundCertificatesProxy;
import eu.europa.esig.dss.diagnostic.FoundRevocationsProxy;
import eu.europa.esig.dss.diagnostic.RelatedCertificateWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlModification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlModificationDetection;
import eu.europa.esig.dss.diagnostic.jaxb.XmlObjectModification;
import eu.europa.esig.dss.diagnostic.jaxb.XmlObjectModifications;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFRevision;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTokenProxy
implements TokenProxy {
    protected abstract XmlBasicSignature getCurrentBasicSignature();

    protected abstract List<XmlChainItem> getCurrentCertificateChain();

    protected abstract XmlSigningCertificate getCurrentSigningCertificate();

    @Override
    public FoundCertificatesProxy foundCertificates() {
        return new FoundCertificatesProxy(null);
    }

    @Override
    public FoundRevocationsProxy foundRevocations() {
        return new FoundRevocationsProxy(null);
    }

    @Override
    public List<XmlDigestMatcher> getDigestMatchers() {
        return Collections.emptyList();
    }

    @Override
    public List<CertificateWrapper> getCertificateChain() {
        ArrayList<CertificateWrapper> result = new ArrayList<CertificateWrapper>();
        List<XmlChainItem> certificateChain = this.getCurrentCertificateChain();
        if (certificateChain != null) {
            for (XmlChainItem xmlChainCertificate : certificateChain) {
                if (xmlChainCertificate.getCertificate() == null) continue;
                result.add(new CertificateWrapper(xmlChainCertificate.getCertificate()));
            }
        }
        return result;
    }

    @Override
    public boolean isSignatureIntact() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            Boolean signatureIntact = basicSignature.isSignatureIntact();
            return signatureIntact != null && signatureIntact != false;
        }
        return false;
    }

    @Override
    public boolean isSignatureValid() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            Boolean signatureValid = basicSignature.isSignatureValid();
            return signatureValid != null && signatureValid != false;
        }
        return false;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        EncryptionAlgorithm encryptionAlgorithm = this.getEncryptionAlgorithm();
        DigestAlgorithm digestAlgorithm = this.getDigestAlgorithm();
        if (encryptionAlgorithm != null && digestAlgorithm != null) {
            return SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm);
        }
        return null;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getEncryptionAlgoUsedToSignThisToken();
        }
        return null;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getDigestAlgoUsedToSignThisToken();
        }
        return null;
    }

    @Override
    public MaskGenerationFunction getMaskGenerationFunction() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getMaskGenerationFunctionUsedToSignThisToken();
        }
        return null;
    }

    @Override
    public String getKeyLengthUsedToSignThisToken() {
        XmlBasicSignature basicSignature = this.getCurrentBasicSignature();
        if (basicSignature != null) {
            return basicSignature.getKeyLengthUsedToSignThisToken();
        }
        return "";
    }

    @Override
    public CertificateWrapper getSigningCertificate() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        if (currentSigningCertificate != null && currentSigningCertificate.getCertificate() != null) {
            return new CertificateWrapper(currentSigningCertificate.getCertificate());
        }
        return null;
    }

    @Override
    public byte[] getSigningCertificatePublicKey() {
        XmlSigningCertificate currentSigningCertificate = this.getCurrentSigningCertificate();
        if (currentSigningCertificate != null) {
            return currentSigningCertificate.getPublicKey();
        }
        return null;
    }

    @Override
    public boolean isSigningCertificateReferencePresent() {
        return !this.getSigningCertificateReferences().isEmpty();
    }

    @Override
    public boolean isSigningCertificateReferenceUnique() {
        return this.getSigningCertificateReferences().size() == 1;
    }

    @Override
    public CertificateRefWrapper getSigningCertificateReference() {
        List<CertificateRefWrapper> signingCertificateReferences = this.foundCertificates().getRelatedCertificateRefsByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
        if (!signingCertificateReferences.isEmpty()) {
            CertificateWrapper signingCertificate = this.getSigningCertificate();
            if (signingCertificate != null) {
                return this.getCertificateReferenceOfReferenceOriginType(signingCertificate, CertificateRefOrigin.SIGNING_CERTIFICATE);
            }
        } else {
            List<CertificateRefWrapper> orphanSigningCertificateReferences = this.foundCertificates().getOrphanCertificateRefsByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
            if (!orphanSigningCertificateReferences.isEmpty()) {
                return orphanSigningCertificateReferences.iterator().next();
            }
        }
        return null;
    }

    private CertificateRefWrapper getCertificateReferenceOfReferenceOriginType(CertificateWrapper certificate, CertificateRefOrigin refOrigin) {
        for (RelatedCertificateWrapper relatedCertificate : this.foundCertificates().getRelatedCertificates()) {
            List<CertificateRefWrapper> signCertRefs = relatedCertificate.getReferences();
            if (!certificate.getId().equals(relatedCertificate.getId()) || signCertRefs.isEmpty()) continue;
            for (CertificateRefWrapper signCertRef : signCertRefs) {
                if (!refOrigin.equals((Object)signCertRef.getOrigin())) continue;
                return signCertRef;
            }
        }
        return null;
    }

    @Override
    public List<CertificateRefWrapper> getSigningCertificateReferences() {
        ArrayList<CertificateRefWrapper> certificateRefs = new ArrayList<CertificateRefWrapper>();
        certificateRefs.addAll(this.foundCertificates().getRelatedCertificateRefsByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE));
        certificateRefs.addAll(this.foundCertificates().getOrphanCertificateRefsByRefOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE));
        return certificateRefs;
    }

    @Override
    public boolean isTrustedChain() {
        List<CertificateWrapper> certificateChain = this.getCertificateChain();
        for (CertificateWrapper certificate : certificateChain) {
            List<CertificateSourceType> currentCertSources = certificate.getSources();
            if (!currentCertSources.contains((Object)CertificateSourceType.TRUSTED_STORE) && !currentCertSources.contains((Object)CertificateSourceType.TRUSTED_LIST)) continue;
            return true;
        }
        return false;
    }

    public boolean isCertificateChainFromTrustedStore() {
        for (CertificateWrapper certificate : this.getCertificateChain()) {
            if (!certificate.getSources().contains((Object)CertificateSourceType.TRUSTED_STORE)) continue;
            return true;
        }
        return false;
    }

    public abstract byte[] getBinaries();

    protected boolean arePdfModificationsDetected(XmlPDFRevision pdfRevision) {
        XmlModificationDetection modificationDetection;
        if (pdfRevision != null && (modificationDetection = pdfRevision.getModificationDetection()) != null) {
            return !modificationDetection.getAnnotationOverlap().isEmpty() || !modificationDetection.getVisualDifference().isEmpty() || !modificationDetection.getPageDifference().isEmpty();
        }
        return false;
    }

    protected List<BigInteger> getPdfAnnotationsOverlapConcernedPages(XmlPDFRevision pdfRevision) {
        XmlModificationDetection modificationDetection;
        if (pdfRevision != null && (modificationDetection = pdfRevision.getModificationDetection()) != null) {
            List<XmlModification> annotationOverlap = modificationDetection.getAnnotationOverlap();
            return this.getConcernedPages(annotationOverlap);
        }
        return Collections.emptyList();
    }

    protected List<BigInteger> getPdfVisualDifferenceConcernedPages(XmlPDFRevision pdfRevision) {
        XmlModificationDetection modificationDetection;
        if (pdfRevision != null && (modificationDetection = pdfRevision.getModificationDetection()) != null) {
            List<XmlModification> visualDifference = modificationDetection.getVisualDifference();
            return this.getConcernedPages(visualDifference);
        }
        return Collections.emptyList();
    }

    protected List<BigInteger> getPdfPageDifferenceConcernedPages(XmlPDFRevision pdfRevision) {
        XmlModificationDetection modificationDetection;
        if (pdfRevision != null && (modificationDetection = pdfRevision.getModificationDetection()) != null) {
            List<XmlModification> pageDifference = modificationDetection.getPageDifference();
            return this.getConcernedPages(pageDifference);
        }
        return Collections.emptyList();
    }

    private List<BigInteger> getConcernedPages(List<XmlModification> xmlModifications) {
        ArrayList<BigInteger> pages = new ArrayList<BigInteger>();
        for (XmlModification modification : xmlModifications) {
            pages.add(modification.getPage());
        }
        return pages;
    }

    protected XmlObjectModifications getPdfObjectModifications(XmlPDFRevision pdfRevision) {
        XmlModificationDetection modificationDetection;
        if (pdfRevision != null && (modificationDetection = pdfRevision.getModificationDetection()) != null) {
            return modificationDetection.getObjectModifications();
        }
        return null;
    }

    protected List<XmlObjectModification> getPdfExtensionChanges(XmlPDFRevision pdfRevision) {
        XmlObjectModifications pdfObjectModifications = this.getPdfObjectModifications(pdfRevision);
        if (pdfObjectModifications != null) {
            return pdfObjectModifications.getExtensionChanges();
        }
        return Collections.emptyList();
    }

    protected List<XmlObjectModification> getPdfSignatureOrFormFillChanges(XmlPDFRevision pdfRevision) {
        XmlObjectModifications pdfObjectModifications = this.getPdfObjectModifications(pdfRevision);
        if (pdfObjectModifications != null) {
            return pdfObjectModifications.getSignatureOrFormFill();
        }
        return Collections.emptyList();
    }

    protected List<XmlObjectModification> getPdfAnnotationChanges(XmlPDFRevision pdfRevision) {
        XmlObjectModifications pdfObjectModifications = this.getPdfObjectModifications(pdfRevision);
        if (pdfObjectModifications != null) {
            return pdfObjectModifications.getAnnotationChanges();
        }
        return Collections.emptyList();
    }

    protected List<XmlObjectModification> getPdfUndefinedChanges(XmlPDFRevision pdfRevision) {
        XmlObjectModifications pdfObjectModifications = this.getPdfObjectModifications(pdfRevision);
        if (pdfObjectModifications != null) {
            return pdfObjectModifications.getUndefined();
        }
        return Collections.emptyList();
    }

    protected List<String> getModifiedFieldNames(XmlPDFRevision pdfRevision) {
        ArrayList<String> names = new ArrayList<String>();
        XmlObjectModifications pdfObjectModifications = this.getPdfObjectModifications(pdfRevision);
        if (pdfObjectModifications != null) {
            names.addAll(this.getModifiedFieldNames(pdfObjectModifications.getExtensionChanges()));
            names.addAll(this.getModifiedFieldNames(pdfObjectModifications.getSignatureOrFormFill()));
            names.addAll(this.getModifiedFieldNames(pdfObjectModifications.getAnnotationChanges()));
            names.addAll(this.getModifiedFieldNames(pdfObjectModifications.getUndefined()));
        }
        return names;
    }

    private List<String> getModifiedFieldNames(List<XmlObjectModification> objectModifications) {
        ArrayList<String> names = new ArrayList<String>();
        for (XmlObjectModification objectModification : objectModifications) {
            String fieldName = objectModification.getFieldName();
            if (fieldName == null) continue;
            names.add(fieldName);
        }
        return names;
    }

    public String toString() {
        return "Token Id='" + this.getId() + "'";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTokenProxy other = (AbstractTokenProxy)obj;
        if (this.getId() == null) {
            return other.getId() == null;
        }
        return this.getId().equals(other.getId());
    }
}

