/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.asic.common.DSSZipEntry;
import eu.europa.esig.dss.asic.common.DSSZipEntryDocument;
import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSDocument;
import java.io.InputStream;
import java.util.Objects;

public class ContainerEntryDocument
extends CommonDocument
implements DSSZipEntryDocument {
    private final DSSDocument content;
    private final DSSZipEntry zipEntry;

    public ContainerEntryDocument(DSSDocument content) {
        Objects.requireNonNull(content, "Document content cannot be null!");
        Objects.requireNonNull(content.getName(), "Document shall contain name!");
        this.content = content;
        this.zipEntry = new DSSZipEntry(content.getName());
        this.name = content.getName();
        this.mimeType = content.getMimeType();
    }

    public ContainerEntryDocument(DSSDocument content, DSSZipEntry zipEntry) {
        Objects.requireNonNull(content, "Document content cannot be null!");
        Objects.requireNonNull(content.getName(), "Document shall contain name!");
        Objects.requireNonNull(zipEntry, "ZipEntry cannot be null!");
        if (!content.getName().equals(zipEntry.getName())) {
            throw new IllegalArgumentException("Name of the document shall match the name of ZipEntry!");
        }
        this.content = content;
        this.zipEntry = zipEntry;
        this.name = content.getName();
        this.mimeType = content.getMimeType();
    }

    @Override
    public InputStream openStream() {
        return this.content.openStream();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.zipEntry.setName(name);
    }

    @Override
    public DSSZipEntry getZipEntry() {
        return this.zipEntry;
    }
}

