/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.cades.validation.scope.ASiCWithCAdESTimestampScopeFinder;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.scope.DetachedTimestampScopeFinder;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.List;

public class ASiCWithCAdESTimestampValidator
extends DetachedTimestampValidator {
    private List<DSSDocument> originalDocuments;
    private List<DSSDocument> archiveDocuments;

    public ASiCWithCAdESTimestampValidator(DSSDocument timestamp) {
        super(timestamp);
    }

    public ASiCWithCAdESTimestampValidator(DSSDocument timestamp, TimestampType type) {
        super(timestamp, type);
    }

    public ManifestFile getCoveredManifest() {
        return this.manifestFile;
    }

    public void setOriginalDocuments(List<DSSDocument> originalDocuments) {
        this.originalDocuments = originalDocuments;
    }

    public void setArchiveDocuments(List<DSSDocument> archiveDocuments) {
        this.archiveDocuments = archiveDocuments;
    }

    @Override
    protected TimestampToken createTimestampToken() {
        TimestampToken timestamp = super.createTimestampToken();
        if (this.manifestFile != null) {
            timestamp.setManifestFile(this.manifestFile);
        }
        if (TimestampType.ARCHIVE_TIMESTAMP.equals((Object)this.timestampType)) {
            timestamp.setArchiveTimestampType(ArchiveTimestampType.CAdES_DETACHED);
        }
        return timestamp;
    }

    @Override
    protected ASiCWithCAdESTimestampScopeFinder getTimestampScopeFinder() {
        return new ASiCWithCAdESTimestampScopeFinder();
    }

    @Override
    protected void prepareDetachedTimestampScopeFinder(DetachedTimestampScopeFinder timestampScopeFinder) {
        super.prepareDetachedTimestampScopeFinder(timestampScopeFinder);
        ASiCWithCAdESTimestampScopeFinder asicWithCAdESTimestampScopeFinder = (ASiCWithCAdESTimestampScopeFinder)timestampScopeFinder;
        asicWithCAdESTimestampScopeFinder.setContainerDocuments(this.originalDocuments);
        asicWithCAdESTimestampScopeFinder.setArchiveDocuments(this.archiveDocuments);
    }

    @Override
    protected boolean addReference(SignatureScope signatureScope) {
        String fileName = signatureScope.getName();
        return fileName == null || !ASiCUtils.isSignature(fileName) && !ASiCUtils.isTimestamp(fileName);
    }
}

