/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.manifest;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.DefaultASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.signature.manifest.AbstractManifestBuilder;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.definition.ASiCElement;
import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ASiCEWithCAdESManifestBuilder
extends AbstractManifestBuilder {
    private final ASiCContent asicContent;
    private final DigestAlgorithm digestAlgorithm;
    private final String documentUri;
    private final ASiCWithCAdESFilenameFactory asicFilenameFactory;

    protected ASiCEWithCAdESManifestBuilder(ASiCContent asicContent, DigestAlgorithm digestAlgorithm, String documentUri) {
        this(asicContent, digestAlgorithm, documentUri, new DefaultASiCWithCAdESFilenameFactory());
    }

    protected ASiCEWithCAdESManifestBuilder(ASiCContent asicContent, DigestAlgorithm digestAlgorithm, String documentUri, ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        this.asicContent = asicContent;
        this.digestAlgorithm = digestAlgorithm;
        this.documentUri = documentUri;
        this.asicFilenameFactory = asicFilenameFactory;
    }

    public DSSDocument build() {
        Document documentDom = DomUtils.buildDOM();
        Element asicManifestDom = DomUtils.createElementNS(documentDom, ASiCNamespace.NS, ASiCElement.ASIC_MANIFEST);
        documentDom.appendChild(asicManifestDom);
        this.addSigReference(documentDom, asicManifestDom, this.documentUri, this.getSigReferenceMimeType());
        for (DSSDocument document : this.asicContent.getSignedDocuments()) {
            this.addDataObjectReference(documentDom, asicManifestDom, document, this.digestAlgorithm);
        }
        String newManifestName = this.asicFilenameFactory.getManifestFilename(this.asicContent);
        return DomUtils.createDssDocumentFromDomDocument(documentDom, newManifestName);
    }

    protected abstract MimeType getSigReferenceMimeType();
}

