/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.cades.signature.manifest.ASiCEWithCAdESManifestBuilder;
import eu.europa.esig.dss.asic.cades.signature.manifest.ASiCWithCAdESSignatureManifestBuilder;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCWithCAdESSignatureDataToSignHelperBuilder
extends ASiCWithCAdESDataToSignHelperBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithCAdESSignatureDataToSignHelperBuilder.class);

    public ASiCWithCAdESSignatureDataToSignHelperBuilder(ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        super(asicFilenameFactory);
    }

    @Override
    protected ASiCEWithCAdESManifestBuilder getManifestBuilder(ASiCContent asicContent, ASiCWithCAdESCommonParameters parameters) {
        String signatureFilename = this.getSignatureFilename(parameters.aSiC(), asicContent);
        return new ASiCWithCAdESSignatureManifestBuilder(asicContent, parameters.getDigestAlgorithm(), signatureFilename, this.asicFilenameFactory);
    }

    private String getSignatureFilename(ASiCParameters asicParameters, ASiCContent asicContent) {
        if (Utils.isStringNotEmpty(asicParameters.getSignatureFileName())) {
            LOG.warn("The signature filename has been defined within deprecated method parameters.aSiC().setSignatureFilename(filename). Please use asicWithCAdESService.setAsicFilenameFactory(asicFilenameFactory) defining a custom filename factory.");
            return asicParameters.getSignatureFileName();
        }
        return this.asicFilenameFactory.getSignatureFilename(asicContent);
    }
}

