/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.DefaultASiCWithCAdESFilenameFactory;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESSignatureExtension;
import eu.europa.esig.dss.asic.cades.signature.manifest.ASiCEWithCAdESArchiveManifestBuilder;
import eu.europa.esig.dss.asic.cades.validation.ASiCContainerWithCAdESValidator;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESManifestParser;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.List;
import org.bouncycastle.cms.CMSSignedData;

public class ASiCWithCAdESLevelBaselineLTA
extends ASiCWithCAdESSignatureExtension {
    private static final long serialVersionUID = 5337864432054920568L;
    private final ASiCWithCAdESFilenameFactory asicFilenameFactory;

    public ASiCWithCAdESLevelBaselineLTA(CertificateVerifier certificateVerifier, TSPSource tspSource) {
        this(certificateVerifier, tspSource, new DefaultASiCWithCAdESFilenameFactory());
    }

    public ASiCWithCAdESLevelBaselineLTA(CertificateVerifier certificateVerifier, TSPSource tspSource, ASiCWithCAdESFilenameFactory asicFilenameFactory) {
        super(certificateVerifier, tspSource);
        this.asicFilenameFactory = asicFilenameFactory;
    }

    @Override
    public ASiCContent extend(ASiCContent asicContent, CAdESSignatureParameters parameters) {
        asicContent = super.extend(asicContent, parameters);
        return this.extend(asicContent, this.getReferenceDigestAlgorithmOrDefault(parameters), parameters.getArchiveTimestampParameters().getDigestAlgorithm());
    }

    public ASiCContent extend(ASiCContent asicContent, DigestAlgorithm digestAlgorithm) {
        asicContent = super.extend(asicContent, this.getEmptyLTLevelSignatureParameters());
        return this.extend(asicContent, digestAlgorithm, digestAlgorithm);
    }

    private ASiCContent extend(ASiCContent asicContent, DigestAlgorithm manifestDigestAlgorithm, DigestAlgorithm tstDigestAlgorithm) {
        List<DSSDocument> timestampDocuments;
        String timestampFilename = this.asicFilenameFactory.getTimestampFilename(asicContent);
        ManifestFile lastManifestFile = this.getLastManifestFile(asicContent.getAllManifestDocuments());
        DSSDocument lastTimestamp = this.getLastTimestampDocument(lastManifestFile, timestampDocuments = asicContent.getTimestampDocuments());
        if (lastTimestamp != null) {
            ASiCContainerWithCAdESValidator validator = new ASiCContainerWithCAdESValidator(asicContent);
            validator.setCertificateVerifier(this.certificateVerifier);
            List<AdvancedSignature> allSignatures = validator.getAllSignatures();
            List<TimestampToken> detachedTimestamps = validator.getDetachedTimestamps();
            ValidationDataContainer validationDataContainer = validator.getValidationData(allSignatures, detachedTimestamps);
            ValidationData allValidationData = validationDataContainer.getAllValidationData();
            for (AdvancedSignature signature : allSignatures) {
                allValidationData.excludeCertificateTokens(signature.getCompleteCertificateSource().getAllCertificateTokens());
                allValidationData.excludeCRLTokens(signature.getCompleteCRLSource().getAllRevocationBinaries());
                allValidationData.excludeOCSPTokens(signature.getCompleteOCSPSource().getAllRevocationBinaries());
            }
            for (TimestampToken timestampToken : detachedTimestamps) {
                allValidationData.excludeCertificateTokens(timestampToken.getCertificateSource().getCertificates());
                allValidationData.excludeCRLTokens(timestampToken.getCRLSource().getAllRevocationBinaries());
                allValidationData.excludeOCSPTokens(timestampToken.getOCSPSource().getAllRevocationBinaries());
            }
            DSSDocument extendedTimestamp = this.extendTimestamp(lastTimestamp, allValidationData);
            ASiCUtils.addOrReplaceDocument(asicContent.getTimestampDocuments(), extendedTimestamp);
        }
        DSSDocument lastArchiveManifest = null;
        if (lastManifestFile != null && this.isLastArchiveManifest(lastManifestFile.getFilename())) {
            lastArchiveManifest = lastManifestFile.getDocument();
            lastArchiveManifest.setName(this.asicFilenameFactory.getArchiveManifestFilename(asicContent));
        }
        ASiCEWithCAdESArchiveManifestBuilder builder = new ASiCEWithCAdESArchiveManifestBuilder(asicContent, lastArchiveManifest, manifestDigestAlgorithm, timestampFilename);
        DSSDocument archiveManifest = builder.build();
        asicContent.getArchiveManifestDocuments().add(archiveManifest);
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(tstDigestAlgorithm, DSSUtils.digest(tstDigestAlgorithm, archiveManifest));
        InMemoryDocument timestamp = new InMemoryDocument(DSSASN1Utils.getDEREncoded(timeStampResponse), timestampFilename, MimeType.TST);
        asicContent.getTimestampDocuments().add(timestamp);
        return asicContent;
    }

    private ManifestFile getLastManifestFile(List<DSSDocument> manifests) {
        DSSDocument lastManifest = this.getLastArchiveManifest(manifests);
        if (lastManifest == null) {
            lastManifest = DSSUtils.getDocumentWithLastName(manifests);
        }
        if (lastManifest != null) {
            return ASiCWithCAdESManifestParser.getManifestFile(lastManifest);
        }
        return null;
    }

    private DSSDocument getLastArchiveManifest(List<DSSDocument> manifests) {
        if (Utils.isCollectionNotEmpty(manifests)) {
            for (DSSDocument manifest : manifests) {
                if (!this.isLastArchiveManifest(manifest.getName())) continue;
                return manifest;
            }
        }
        return null;
    }

    private boolean isLastArchiveManifest(String fileName) {
        return "META-INF/ASiCArchiveManifest.xml".equals(fileName);
    }

    private DSSDocument getLastTimestampDocument(ManifestFile lastManifestFile, List<DSSDocument> timestamps) {
        if (lastManifestFile != null) {
            return DSSUtils.getDocumentWithName(timestamps, lastManifestFile.getSignatureFilename());
        }
        return DSSUtils.getDocumentWithLastName(timestamps);
    }

    private DSSDocument extendTimestamp(DSSDocument archiveTimestamp, ValidationData validationDataForInclusion) {
        CMSSignedData cmsSignedData = DSSUtils.toCMSSignedData(archiveTimestamp);
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        CMSSignedData extendedCMSSignedData = cmsSignedDataBuilder.extendCMSSignedData(cmsSignedData, validationDataForInclusion);
        return new InMemoryDocument(DSSASN1Utils.getEncoded(extendedCMSSignedData), archiveTimestamp.getName(), MimeType.TST);
    }

    private CAdESSignatureParameters getEmptyLTLevelSignatureParameters() {
        CAdESSignatureParameters parameters = new CAdESSignatureParameters();
        parameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        return parameters;
    }

    @Override
    protected boolean extensionRequired(CAdESSignatureParameters parameters, boolean coveredByManifest) {
        return !coveredByManifest;
    }

    @Override
    protected void assertExtendSignaturePossible(CAdESSignatureParameters parameters, boolean coveredByManifest) {
        if (coveredByManifest) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already covered by an archive manifest.", new Object[]{parameters.getSignatureLevel()}));
        }
    }
}

