/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AbstractSignatureIdentifierBuilder;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XAdESSignatureIdentifierBuilder
extends AbstractSignatureIdentifierBuilder {
    public static final String META_INF_FOLDER = "META-INF/";

    public XAdESSignatureIdentifierBuilder(XAdESSignature signature) {
        super(signature);
    }

    @Override
    protected Integer getCounterSignaturePosition(AdvancedSignature masterSignature) {
        XAdESSignature xadesMasterSignature = (XAdESSignature)masterSignature;
        XAdESSignature xadesSignature = (XAdESSignature)this.signature;
        int counter = 0;
        for (AdvancedSignature counterSignature : xadesMasterSignature.getCounterSignatures()) {
            XAdESSignature xadesCounterSignature = (XAdESSignature)counterSignature;
            if (xadesSignature.getSignatureElement() == xadesCounterSignature.getSignatureElement()) break;
            ++counter;
        }
        return counter;
    }

    @Override
    protected Integer getSignaturePosition() {
        int counter;
        XAdESSignature xadesSignature = (XAdESSignature)this.signature;
        Element signatureElement = xadesSignature.getSignatureElement();
        Document document = signatureElement.getOwnerDocument();
        NodeList signatureNodeList = DSSXMLUtils.getAllSignaturesExceptCounterSignatures(document);
        for (counter = 0; counter < signatureNodeList.getLength() && signatureElement != signatureNodeList.item(counter); ++counter) {
        }
        return counter;
    }

    @Override
    protected Object getSignatureFilePosition() {
        String signatureFilename = this.signature.getSignatureFilename();
        if (Utils.isStringNotEmpty(signatureFilename) && signatureFilename.startsWith(META_INF_FOLDER)) {
            return signatureFilename;
        }
        return super.getSignatureFilePosition();
    }
}

