/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.validation.SignatureAttributeIdentifier;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESAttributeIdentifier
extends SignatureAttributeIdentifier {
    private static final long serialVersionUID = 178331193990451357L;

    XAdESAttributeIdentifier(byte[] data) {
        super(data);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static XAdESAttributeIdentifier build(Node node) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            XAdESAttributeIdentifier xAdESAttributeIdentifier;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                dos.write(XAdESAttributeIdentifier.getBinaries(node));
                dos.writeInt(XAdESAttributeIdentifier.getOrder(node));
                xAdESAttributeIdentifier = new XAdESAttributeIdentifier(baos.toByteArray());
            }
            return xAdESAttributeIdentifier;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to build a XAdES Attribute Identifier : %s", e.getMessage()), e);
        }
    }

    private static byte[] getBinaries(Node node) {
        return DSSXMLUtils.serializeNode(node);
    }

    private static int getOrder(Node node) {
        Node parentNode = node.getParentNode();
        if (parentNode != null) {
            NodeList childNodes = parentNode.getChildNodes();
            for (int ii = 0; ii < childNodes.getLength(); ++ii) {
                Node child = childNodes.item(ii);
                if (node != child) continue;
                return ii;
            }
        }
        return 0;
    }
}

