/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.ReferenceBuilder;
import eu.europa.esig.dss.xades.reference.ReferenceOutputType;
import eu.europa.esig.dss.xades.reference.ReferenceProcessor;
import eu.europa.esig.dss.xades.reference.ReferenceVerifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.tsp.TSPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllDataObjectsTimeStampBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AllDataObjectsTimeStampBuilder.class);
    private final TSPSource tspSource;
    private final XAdESSignatureParameters signatureParameters;

    public AllDataObjectsTimeStampBuilder(TSPSource tspSource, XAdESSignatureParameters signatureParameters) {
        this.tspSource = tspSource;
        this.signatureParameters = signatureParameters;
    }

    public TimestampToken build(DSSDocument document) {
        return this.build(Arrays.asList(document));
    }

    public TimestampToken build(List<DSSDocument> documents) {
        byte[] dataToBeDigested;
        this.assertTimestampCreationPossible(documents);
        List<DSSReference> references = this.signatureParameters.getReferences();
        if (Utils.isCollectionEmpty(references)) {
            ReferenceBuilder referenceBuilder = new ReferenceBuilder(documents, this.signatureParameters);
            references = referenceBuilder.build();
            this.signatureParameters.getContext().setReferences(references);
        } else {
            ReferenceVerifier referenceVerifier = new ReferenceVerifier(this.signatureParameters);
            referenceVerifier.checkReferencesValidity();
        }
        XAdESTimestampParameters contentTimestampParameters = this.signatureParameters.getContentTimestampParameters();
        String canonicalizationMethod = contentTimestampParameters.getCanonicalizationMethod();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            for (DSSReference reference : references) {
                ReferenceProcessor referenceProcessor = new ReferenceProcessor(this.signatureParameters);
                DSSDocument referenceContent = referenceProcessor.getReferenceOutput(reference);
                byte[] binaries = DSSUtils.toByteArray(referenceContent);
                if (ReferenceOutputType.NODE_SET.equals((Object)DSSXMLUtils.getReferenceOutputType(reference)) && DomUtils.isDOM(binaries)) {
                    binaries = DSSXMLUtils.canonicalize(canonicalizationMethod, binaries);
                }
                baos.write(binaries);
            }
            dataToBeDigested = baos.toByteArray();
        }
        catch (IOException e) {
            throw new DSSException("Unable to compute the data to be digested", e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Computed AllDataObjectsTimestampData bytes:");
            LOG.trace(new String(dataToBeDigested));
        }
        DigestAlgorithm digestAlgorithm = contentTimestampParameters.getDigestAlgorithm();
        byte[] digestToTimestamp = DSSUtils.digest(digestAlgorithm, dataToBeDigested);
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, digestToTimestamp);
        try {
            TimestampToken token = new TimestampToken(timeStampResponse.getBytes(), TimestampType.ALL_DATA_OBJECTS_TIMESTAMP);
            token.setCanonicalizationMethod(canonicalizationMethod);
            return token;
        }
        catch (IOException | CMSException | TSPException e) {
            throw new DSSException("Cannot build an AllDataObjectsTimestamp", e);
        }
    }

    private void assertTimestampCreationPossible(List<DSSDocument> documents) {
        for (DSSDocument document : documents) {
            if (!(document instanceof DigestDocument)) continue;
            throw new IllegalArgumentException("Content timestamp creation is not possible with DigestDocument!");
        }
    }
}

