/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.CaQcServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ConsistentServiceByCertificateTypeFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ConsistentServiceByQCFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ConsistentServiceByQSCDFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ConsistentServiceByStatusFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.GrantedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.QTSTServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByCertificateTypeFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByCountryFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByDateFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByMRAEnactedFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByMRAEquivalenceStartingDateFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.ServiceByTLUrlFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.UniqueServiceFilter;
import java.util.Date;
import java.util.Set;

public final class TrustedServicesFilterFactory {
    private TrustedServicesFilterFactory() {
    }

    public static TrustedServiceFilter createFilterByGranted() {
        return new GrantedServiceFilter();
    }

    public static TrustedServiceFilter createFilterByCaQc() {
        return new CaQcServiceFilter();
    }

    public static TrustedServiceFilter createFilterByQTST() {
        return new QTSTServiceFilter();
    }

    public static TrustedServiceFilter createFilterByDate(Date date) {
        return new ServiceByDateFilter(date);
    }

    public static TrustedServiceFilter createFilterByCountry(String countryCode) {
        return new ServiceByCountryFilter(countryCode);
    }

    public static TrustedServiceFilter createFilterByCountries(Set<String> countryCodes) {
        return new ServiceByCountryFilter(countryCodes);
    }

    public static TrustedServiceFilter createFilterByUrls(Set<String> urls) {
        return new ServiceByTLUrlFilter(urls);
    }

    public static TrustedServiceFilter createUniqueServiceFilter(CertificateWrapper endEntityCertificate) {
        return new UniqueServiceFilter(endEntityCertificate);
    }

    public static TrustedServiceFilter createFilterByCertificateType(CertificateWrapper certificate) {
        return new ServiceByCertificateTypeFilter(certificate);
    }

    public static TrustedServiceFilter createConsistentServiceByStatusFilter() {
        return new ConsistentServiceByStatusFilter();
    }

    public static TrustedServiceFilter createConsistentServiceByQCFilter() {
        return new ConsistentServiceByQCFilter();
    }

    public static TrustedServiceFilter createConsistentServiceByCertificateTypeFilter() {
        return new ConsistentServiceByCertificateTypeFilter();
    }

    public static TrustedServiceFilter createConsistentServiceByQSCDFilter() {
        return new ConsistentServiceByQSCDFilter();
    }

    public static TrustedServiceFilter createMRAEnactedFilter() {
        return new ServiceByMRAEnactedFilter();
    }

    public static TrustedServiceFilter createFilterByMRAEquivalenceStartingDate(Date date) {
        return new ServiceByMRAEquivalenceStartingDateFilter(date);
    }
}

