/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.AdditionalServiceInformation;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustedServiceCondition;
import java.util.Date;
import java.util.List;

public class TrustedServiceQualifierAndAdditionalServiceInfoPreEIDASConsistency
implements TrustedServiceCondition {
    @Override
    public boolean isConsistent(TrustedServiceWrapper trustedService) {
        Date startDate = trustedService.getStartDate();
        if (EIDASUtils.isPreEIDAS(startDate)) {
            List<String> asis = trustedService.getAdditionalServiceInfos();
            if (AdditionalServiceInformation.isForeSealsOnly(asis) || AdditionalServiceInformation.isForWebAuthOnly(asis)) {
                return false;
            }
            List<String> qualifiers = trustedService.getCapturedQualifiers();
            if (ServiceQualification.isQcForEseal(qualifiers) || ServiceQualification.isQcForWSA(qualifiers)) {
                return false;
            }
        }
        return true;
    }
}

