/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.enumerations.CertificateType;
import eu.europa.esig.dss.enumerations.QSCDStatus;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationMatrix;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationCalculator;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CaQcCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateIssuedByConsistentByQCTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateIssuedByConsistentByQSCDTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateTypeCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateTypeCoverageCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.GrantedStatusCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.IsAbleToSelectOneTrustService;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.IsNoQualificationConflictDetected;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QSCDCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QualifiedCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.RelatedToMraEnactedTrustedServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.ServiceConsistencyCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.TrustedCertificateMatchTrustedServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServicesFilterFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertQualificationAtTimeBlock
extends Chain<XmlValidationCertificateQualification> {
    private final ValidationTime validationTime;
    private final Date date;
    private final CertificateWrapper signingCertificate;
    private final List<TrustedServiceWrapper> caqcServices;
    private CertificateQualification certificateQualification = CertificateQualification.NA;

    public CertQualificationAtTimeBlock(I18nProvider i18nProvider, ValidationTime validationTime, CertificateWrapper signingCertificate, List<TrustedServiceWrapper> caqcServices) {
        this(i18nProvider, validationTime, null, signingCertificate, caqcServices);
    }

    public CertQualificationAtTimeBlock(I18nProvider i18nProvider, ValidationTime validationTime, Date date, CertificateWrapper signingCertificate, List<TrustedServiceWrapper> caqcServices) {
        super(i18nProvider, new XmlValidationCertificateQualification());
        ((XmlValidationCertificateQualification)this.result).setId(signingCertificate.getId());
        this.validationTime = validationTime;
        this.signingCertificate = signingCertificate;
        this.caqcServices = new ArrayList<TrustedServiceWrapper>(caqcServices);
        switch (validationTime) {
            case CERTIFICATE_ISSUANCE_TIME: {
                this.date = signingCertificate.getNotBefore();
                break;
            }
            case VALIDATION_TIME: 
            case BEST_SIGNATURE_TIME: {
                this.date = date;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown qualification time : " + (Object)((Object)validationTime));
            }
        }
    }

    @Override
    protected String buildChainTitle() {
        MessageTag param;
        MessageTag message = MessageTag.CERT_QUALIFICATION_AT_TIME;
        switch (this.validationTime) {
            case BEST_SIGNATURE_TIME: {
                param = MessageTag.VT_BEST_SIGNATURE_TIME;
                break;
            }
            case CERTIFICATE_ISSUANCE_TIME: {
                param = MessageTag.VT_CERTIFICATE_ISSUANCE_TIME;
                break;
            }
            case VALIDATION_TIME: {
                param = MessageTag.VT_VALIDATION_TIME;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The validation time [%s] is not supported", new Object[]{this.validationTime}));
            }
        }
        return this.i18nProvider.getMessage(message, new Object[]{param});
    }

    @Override
    protected void initChain() {
        ChainItem<XmlValidationCertificateQualification> item = null;
        TrustedServiceFilter filterByDate = TrustedServicesFilterFactory.createFilterByDate(this.date);
        List<TrustedServiceWrapper> caqcServicesAtTime = filterByDate.filter(this.caqcServices);
        if (this.isMRAEnactedForTrustedList(this.caqcServices)) {
            TrustedServiceFilter filterByMRAEnacted = TrustedServicesFilterFactory.createMRAEnactedFilter();
            caqcServicesAtTime = filterByMRAEnacted.filter(caqcServicesAtTime);
            filterByMRAEnacted = TrustedServicesFilterFactory.createFilterByMRAEquivalenceStartingDate(this.signingCertificate.getNotBefore());
            caqcServicesAtTime = filterByMRAEnacted.filter(caqcServicesAtTime);
            this.firstItem = this.hasMraEnactedTrustedService(caqcServicesAtTime);
            item = this.firstItem;
        }
        TrustedServiceFilter filterByCertificateType = TrustedServicesFilterFactory.createFilterByCertificateType(this.signingCertificate);
        caqcServicesAtTime = filterByCertificateType.filter(caqcServicesAtTime);
        if (item == null) {
            this.firstItem = this.hasCaQc(caqcServicesAtTime);
            item = this.firstItem;
        } else {
            item = item.setNextItem(this.hasCaQc(caqcServicesAtTime));
        }
        for (TrustedServiceWrapper trustedServiceWrapper : caqcServicesAtTime) {
            item = item.setNextItem(this.serviceConsistency(trustedServiceWrapper));
        }
        if (caqcServicesAtTime.size() > 1) {
            HashSet<CertificateQualification> results = new HashSet<CertificateQualification>();
            for (TrustedServiceWrapper trustedService : caqcServicesAtTime) {
                CertificateQualificationCalculator calculator = new CertificateQualificationCalculator(this.signingCertificate, trustedService);
                results.add(calculator.getQualification());
            }
            item = item.setNextItem(this.isNoConflictDetected(results));
            if (results.size() > 1) {
                this.certificateQualification = CertificateQualification.NA;
                return;
            }
        }
        TrustedServiceFilter filterConsistentByStatus = TrustedServicesFilterFactory.createConsistentServiceByStatusFilter();
        caqcServicesAtTime = filterConsistentByStatus.filter(caqcServicesAtTime);
        TrustedServiceFilter trustedServiceFilter = TrustedServicesFilterFactory.createFilterByGranted();
        caqcServicesAtTime = trustedServiceFilter.filter(caqcServicesAtTime);
        item = item.setNextItem(this.hasGrantedStatus(caqcServicesAtTime));
        if (Utils.collectionSize(caqcServicesAtTime) > 1) {
            TrustedServiceFilter filterUnique = TrustedServicesFilterFactory.createUniqueServiceFilter(this.signingCertificate);
            caqcServicesAtTime = filterUnique.filter(caqcServicesAtTime);
            item = item.setNextItem(this.isAbleToSelectOneTrustService(caqcServicesAtTime));
        }
        TrustedServiceWrapper selectedTrustService = !caqcServicesAtTime.isEmpty() ? caqcServicesAtTime.get(0) : null;
        item = item.setNextItem(this.isTrustedCertificateMatchTrustedService(selectedTrustService));
        TrustedServiceFilter filterConsistentByQC = TrustedServicesFilterFactory.createConsistentServiceByQCFilter();
        caqcServicesAtTime = filterConsistentByQC.filter(caqcServicesAtTime);
        item = item.setNextItem(this.hasConsistentByQCTrustService(caqcServicesAtTime));
        selectedTrustService = !caqcServicesAtTime.isEmpty() ? caqcServicesAtTime.get(0) : null;
        QualificationStrategy qcStrategy = QualificationStrategyFactory.createQualificationFromCertAndTL(this.signingCertificate, selectedTrustService);
        CertificateQualifiedStatus qualifiedStatus = qcStrategy.getQualifiedStatus();
        item = item.setNextItem(this.isQualified(qualifiedStatus));
        TrustedServiceFilter filterConsistentByType = TrustedServicesFilterFactory.createConsistentServiceByCertificateTypeFilter();
        List<TrustedServiceWrapper> caqcServicesByType = filterConsistentByType.filter(caqcServicesAtTime);
        item = item.setNextItem(this.hasCertificateTypeCoverage(caqcServicesByType));
        selectedTrustService = !caqcServicesByType.isEmpty() ? caqcServicesByType.get(0) : null;
        TypeStrategy typeStrategy = TypeStrategyFactory.createTypeFromCertAndTL(this.signingCertificate, selectedTrustService, qualifiedStatus);
        CertificateType type = typeStrategy.getType();
        item = item.setNextItem(this.certificateType(type));
        TrustedServiceFilter filterConsistentByQSCD = TrustedServicesFilterFactory.createConsistentServiceByQSCDFilter();
        caqcServicesAtTime = filterConsistentByQSCD.filter(caqcServicesAtTime);
        item = item.setNextItem(this.hasConsistentByQSCDTrustService(caqcServicesAtTime));
        selectedTrustService = !caqcServicesAtTime.isEmpty() ? caqcServicesAtTime.get(0) : null;
        QSCDStrategy qscdStrategy = QSCDStrategyFactory.createQSCDFromCertAndTL(this.signingCertificate, selectedTrustService, qualifiedStatus);
        QSCDStatus qscdStatus = qscdStrategy.getQSCDStatus();
        item = item.setNextItem(this.isQscd(qscdStatus));
        this.certificateQualification = CertQualificationMatrix.getCertQualification(qualifiedStatus, type, qscdStatus);
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlValidationCertificateQualification)this.result).setCertificateQualification(this.certificateQualification);
        ((XmlValidationCertificateQualification)this.result).setValidationTime(this.validationTime);
        ((XmlValidationCertificateQualification)this.result).setDateTime(this.date);
    }

    private ChainItem<XmlValidationCertificateQualification> hasMraEnactedTrustedService(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new RelatedToMraEnactedTrustedServiceCheck<XmlValidationCertificateQualification>(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasCaQc(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new CaQcCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isNoConflictDetected(Set<CertificateQualification> certificateQualificationsAtTime) {
        return new IsNoQualificationConflictDetected(this.i18nProvider, (XmlValidationCertificateQualification)this.result, certificateQualificationsAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasGrantedStatus(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new GrantedStatusCheck<XmlValidationCertificateQualification>(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasCertificateTypeCoverage(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new CertificateTypeCoverageCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasConsistentByQCTrustService(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new CertificateIssuedByConsistentByQCTrustServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasConsistentByQSCDTrustService(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new CertificateIssuedByConsistentByQSCDTrustServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isAbleToSelectOneTrustService(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new IsAbleToSelectOneTrustService(this.i18nProvider, (XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> serviceConsistency(TrustedServiceWrapper selectedTrustService) {
        return new ServiceConsistencyCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, selectedTrustService, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isTrustedCertificateMatchTrustedService(TrustedServiceWrapper selectedTrustService) {
        return new TrustedCertificateMatchTrustedServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, selectedTrustService, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isQualified(CertificateQualifiedStatus qualifiedStatus) {
        return new QualifiedCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, qualifiedStatus, this.validationTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> certificateType(CertificateType type) {
        return new CertificateTypeCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, type, this.validationTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isQscd(QSCDStatus qscdStatus) {
        return new QSCDCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, qscdStatus, this.validationTime, this.getWarnLevelConstraint());
    }

    private boolean isMRAEnactedForTrustedList(List<TrustedServiceWrapper> trustedServices) {
        for (TrustedServiceWrapper trustedService : trustedServices) {
            if (!Utils.isTrue(trustedService.getTrustedList().isMra())) continue;
            return true;
        }
        return false;
    }
}

