/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Date;

public class DigestAlgorithmOnValidationTimeCheck
extends AbstractCryptographicCheck {
    private final DigestAlgorithm digestAlgo;
    private final Date validationDate;

    protected DigestAlgorithmOnValidationTimeCheck(I18nProvider i18nProvider, DigestAlgorithm digestAlgo, Date validationDate, XmlCC result, MessageTag position, CryptographicConstraintWrapper constraintWrapper) {
        super(i18nProvider, result, position, constraintWrapper);
        this.digestAlgo = digestAlgo;
        this.validationDate = validationDate;
    }

    @Override
    protected boolean process() {
        Date expirationDate = this.constraintWrapper.getExpirationDate(this.digestAlgo);
        return expirationDate == null || !expirationDate.before(this.validationDate);
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_AR, this.getName(this.digestAlgo));
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.ASCCM_AR_ANS_ANR, new Object[]{this.getName(this.digestAlgo), this.position});
    }
}

