/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AcceptableMimetypeFileContentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AcceptableZipCommentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.AllFilesSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ContainerTypeCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.DocMDPCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.EllipticCurveKeySizeCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FieldMDPCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FormatCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.FullScopeCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ManifestFilePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.MimeTypeFilePresentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.PdfAnnotationOverlapCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.PdfPageDifferenceCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.PdfVisualDifferenceCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ReferencesNotAmbiguousCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SigFieldLockCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SignatureNotAmbiguousCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SignedFilesPresentCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.SignerInformationStoreCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.UndefinedChangesCheck;
import eu.europa.esig.dss.validation.process.bbb.fc.checks.ZipCommentPresentCheck;

public class FormatChecking
extends Chain<XmlFC> {
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper signature;
    private final Context context;
    private final ValidationPolicy policy;

    public FormatChecking(I18nProvider i18nProvider, DiagnosticData diagnosticData, SignatureWrapper signature, Context context, ValidationPolicy policy) {
        super(i18nProvider, new XmlFC());
        this.diagnosticData = diagnosticData;
        this.signature = signature;
        this.context = context;
        this.policy = policy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.FORMAT_CHECKING;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlFC> item = this.firstItem = this.formatCheck();
        item = item.setNextItem(this.signatureDuplicateCheck());
        item = item.setNextItem(this.referenceDuplicateCheck());
        item = item.setNextItem(this.fullScopeCheck());
        if (this.signature.getPDFRevision() != null) {
            item = item.setNextItem(this.signerInformationStoreCheck());
            item = item.setNextItem(this.pdfPageDifferenceCheck());
            item = item.setNextItem(this.pdfAnnotationOverlapCheck());
            item = item.setNextItem(this.pdfVisualDifferenceCheck());
            if (this.signature.getDocMDPPermissions() != null) {
                item = item.setNextItem(this.docMDPCheck());
            }
            if (this.signature.getFieldMDP() != null) {
                item = item.setNextItem(this.fieldMDPCheck());
            }
            if (this.signature.getSigFieldLock() != null) {
                item = item.setNextItem(this.sigFieldLockCheck());
            }
            item = item.setNextItem(this.undefinedChangesCheck());
        }
        if (SignatureForm.JAdES.equals((Object)this.signature.getSignatureFormat().getSignatureForm()) && this.signature.getEncryptionAlgorithm() != null && this.signature.getEncryptionAlgorithm().isEquivalent(EncryptionAlgorithm.ECDSA)) {
            item = item.setNextItem(this.ellipticCurveKeySizeCheck());
        }
        if (this.diagnosticData.isContainerInfoPresent()) {
            item = item.setNextItem(this.containerTypeCheck());
            item = item.setNextItem(this.zipCommentPresentCheck());
            if (Utils.isStringNotBlank(this.diagnosticData.getZipComment())) {
                item = item.setNextItem(this.acceptableZipCommentCheck());
            }
            item = item.setNextItem(this.mimetypeFilePresentCheck());
            if (this.diagnosticData.isMimetypeFilePresent()) {
                item = item.setNextItem(this.mimetypeFileContentCheck());
            }
            item = item.setNextItem(this.manifestFilePresentCheck());
            item = item.setNextItem(this.signedFilesPresentCheck());
            item = item.setNextItem(this.allFilesSignedCheck());
        }
    }

    private ChainItem<XmlFC> formatCheck() {
        MultiValuesConstraint constraint = this.policy.getSignatureFormatConstraint(this.context);
        return new FormatCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> signatureDuplicateCheck() {
        LevelConstraint constraint = this.policy.getSignatureDuplicatedConstraint(this.context);
        return new SignatureNotAmbiguousCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> referenceDuplicateCheck() {
        return new ReferencesNotAmbiguousCheck(this.i18nProvider, (XmlFC)this.result, this.signature, this.getFailLevelConstraint());
    }

    private ChainItem<XmlFC> fullScopeCheck() {
        LevelConstraint constraint = this.policy.getFullScopeConstraint();
        return new FullScopeCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> signerInformationStoreCheck() {
        LevelConstraint constraint = this.policy.getSignerInformationStoreConstraint(this.context);
        return new SignerInformationStoreCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> pdfPageDifferenceCheck() {
        LevelConstraint constraint = this.policy.getPdfPageDifferenceConstraint(this.context);
        return new PdfPageDifferenceCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> pdfAnnotationOverlapCheck() {
        LevelConstraint constraint = this.policy.getPdfAnnotationOverlapConstraint(this.context);
        return new PdfAnnotationOverlapCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> pdfVisualDifferenceCheck() {
        LevelConstraint constraint = this.policy.getPdfVisualDifferenceConstraint(this.context);
        return new PdfVisualDifferenceCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> docMDPCheck() {
        LevelConstraint constraint = this.policy.getDocMDPConstraint(this.context);
        return new DocMDPCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> fieldMDPCheck() {
        LevelConstraint constraint = this.policy.getFieldMDPConstraint(this.context);
        return new FieldMDPCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> sigFieldLockCheck() {
        LevelConstraint constraint = this.policy.getSigFieldLockConstraint(this.context);
        return new SigFieldLockCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> undefinedChangesCheck() {
        LevelConstraint constraint = this.policy.getUndefinedChangesConstraint(this.context);
        return new UndefinedChangesCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> ellipticCurveKeySizeCheck() {
        LevelConstraint constraint = this.policy.getEllipticCurveKeySizeConstraint(this.context);
        return new EllipticCurveKeySizeCheck(this.i18nProvider, (XmlFC)this.result, this.signature, constraint);
    }

    private ChainItem<XmlFC> containerTypeCheck() {
        MultiValuesConstraint constraint = this.policy.getAcceptedContainerTypesConstraint();
        return new ContainerTypeCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getContainerType(), constraint);
    }

    private ChainItem<XmlFC> zipCommentPresentCheck() {
        LevelConstraint constraint = this.policy.getZipCommentPresentConstraint();
        return new ZipCommentPresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getZipComment(), constraint);
    }

    private ChainItem<XmlFC> acceptableZipCommentCheck() {
        MultiValuesConstraint constraint = this.policy.getAcceptedZipCommentsConstraint();
        return new AcceptableZipCommentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getZipComment(), constraint);
    }

    private ChainItem<XmlFC> mimetypeFilePresentCheck() {
        LevelConstraint constraint = this.policy.getMimeTypeFilePresentConstraint();
        return new MimeTypeFilePresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.isMimetypeFilePresent(), constraint);
    }

    private ChainItem<XmlFC> mimetypeFileContentCheck() {
        MultiValuesConstraint constraint = this.policy.getAcceptedMimeTypeContentsConstraint();
        return new AcceptableMimetypeFileContentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getMimetypeFileContent(), constraint);
    }

    private ChainItem<XmlFC> manifestFilePresentCheck() {
        LevelConstraint constraint = this.policy.getManifestFilePresentConstraint();
        return new ManifestFilePresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getContainerInfo(), constraint);
    }

    private ChainItem<XmlFC> signedFilesPresentCheck() {
        LevelConstraint constraint = this.policy.getSignedFilesPresentConstraint();
        return new SignedFilesPresentCheck(this.i18nProvider, (XmlFC)this.result, this.diagnosticData.getContainerInfo(), constraint);
    }

    private ChainItem<XmlFC> allFilesSignedCheck() {
        LevelConstraint constraint = this.policy.getAllFilesSignedConstraint();
        return new AllFilesSignedCheck(this.i18nProvider, (XmlFC)this.result, this.signature, this.diagnosticData.getContainerInfo(), constraint);
    }
}

