/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class ValidationProcessUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String URN_OID_PREFIX = "urn:oid:";

    private ValidationProcessUtils() {
    }

    public static boolean isRevocationCheckRequired(CertificateWrapper certificate) {
        return !certificate.isTrusted() && !certificate.isSelfSigned() && !certificate.isIdPkixOcspNoCheck();
    }

    public static boolean isAllowedBasicSignatureValidation(XmlConclusion conclusion) {
        return Indication.PASSED.equals(conclusion.getIndication()) || Indication.INDETERMINATE.equals(conclusion.getIndication()) && (SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOKED_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.TRY_LATER.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals(conclusion.getSubIndication()));
    }

    public static boolean isAllowedBasicRevocationDataValidation(XmlConclusion conclusion) {
        return conclusion != null && (Indication.PASSED.equals(conclusion.getIndication()) || Indication.INDETERMINATE.equals(conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals(conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals(conclusion.getSubIndication())));
    }

    public static boolean isAllowedBasicTimestampValidation(XmlConclusion conclusion) {
        return Indication.PASSED.equals(conclusion.getIndication()) || Indication.INDETERMINATE.equals(conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals(conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals(conclusion.getSubIndication()));
    }

    public static boolean isAllowedValidationWithLongTermData(XmlConclusion conclusion) {
        return Indication.PASSED.equals(conclusion.getIndication()) || Indication.INDETERMINATE.equals(conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals(conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals(conclusion.getSubIndication()));
    }

    public static CertificateRevocationWrapper getLatestAcceptableRevocationData(TokenProxy token, CertificateWrapper certificate, Collection<CertificateRevocationWrapper> revocationData, Date controlTime, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe) {
        CertificateRevocationWrapper latestRevocationData = null;
        if (poe.isPOEExists(certificate.getId(), controlTime)) {
            for (CertificateRevocationWrapper revocationWrapper : revocationData) {
                XmlBasicBuildingBlocks revocationBBB = bbbs.get(revocationWrapper.getId());
                if (!ValidationProcessUtils.isAllowedBasicRevocationDataValidation(revocationBBB.getConclusion()) || !ValidationProcessUtils.isRevocationDataAcceptable(bbbs.get(token.getId()), certificate, revocationWrapper) || revocationWrapper.getThisUpdate() == null || !revocationWrapper.getThisUpdate().before(controlTime) || !poe.isPOEExists(revocationWrapper.getId(), controlTime) || latestRevocationData != null && (revocationWrapper.getProductionDate() == null || !latestRevocationData.getProductionDate().before(revocationWrapper.getProductionDate()))) continue;
                latestRevocationData = revocationWrapper;
            }
        }
        return latestRevocationData;
    }

    public static List<CertificateRevocationWrapper> getAcceptableRevocationDataForPSVIfExistOrReturnAll(TokenProxy token, CertificateWrapper certificate, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe) {
        List<CertificateRevocationWrapper> revocationWrappers = ValidationProcessUtils.filterRevocationDataForPastSignatureValidation(token, certificate, bbbs, poe);
        if (Utils.isCollectionNotEmpty(revocationWrappers)) {
            return revocationWrappers;
        }
        return certificate.getCertificateRevocationData();
    }

    private static List<CertificateRevocationWrapper> filterRevocationDataForPastSignatureValidation(TokenProxy token, CertificateWrapper certificate, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe) {
        ArrayList<CertificateRevocationWrapper> certificateRevocations = new ArrayList<CertificateRevocationWrapper>();
        for (CertificateRevocationWrapper certificateRevocation : certificate.getCertificateRevocationData()) {
            XmlBasicBuildingBlocks revocationBBB = bbbs.get(certificateRevocation.getId());
            CertificateWrapper revocationIssuer = certificateRevocation.getSigningCertificate();
            if (!ValidationProcessUtils.isAllowedBasicRevocationDataValidation(revocationBBB.getConclusion()) || !ValidationProcessUtils.isRevocationDataAcceptable(bbbs.get(token.getId()), certificate, certificateRevocation) || revocationIssuer == null || !revocationIssuer.isTrusted() && !poe.isPOEExistInRange(revocationIssuer.getId(), revocationIssuer.getNotBefore(), revocationIssuer.getNotAfter())) continue;
            certificateRevocations.add(certificateRevocation);
        }
        return certificateRevocations;
    }

    public static boolean isRevocationDataAcceptable(XmlBasicBuildingBlocks bbb, CertificateWrapper certificate, RevocationWrapper revocationData) {
        XmlRAC xmlRAC = ValidationProcessUtils.getRevocationAcceptanceCheckerResult(bbb, certificate.getId(), revocationData.getId());
        return xmlRAC != null && xmlRAC.getConclusion() != null && Indication.PASSED.equals(xmlRAC.getConclusion().getIndication());
    }

    public static XmlRAC getRevocationAcceptanceCheckerResult(XmlBasicBuildingBlocks bbb, String certificateId, String revocationDataId) {
        List<XmlRAC> racs;
        XmlRAC rac;
        XmlCRS crs;
        XmlSubXCV subXCV;
        XmlXCV xcv;
        if (bbb != null && (xcv = bbb.getXCV()) != null && (subXCV = ValidationProcessUtils.getXmlSubXCVForId(xcv.getSubXCV(), certificateId)) != null && (crs = subXCV.getCRS()) != null && (rac = ValidationProcessUtils.getXmlRACForId(racs = crs.getRAC(), revocationDataId)) != null) {
            return rac;
        }
        return null;
    }

    private static XmlSubXCV getXmlSubXCVForId(List<XmlSubXCV> subXCVs, String tokenId) {
        for (XmlSubXCV subXCV : subXCVs) {
            if (!tokenId.equals(subXCV.getId())) continue;
            return subXCV;
        }
        return null;
    }

    private static XmlRAC getXmlRACForId(List<XmlRAC> racs, String tokenId) {
        if (Utils.isCollectionNotEmpty(racs)) {
            for (XmlRAC rac : racs) {
                if (!tokenId.equals(rac.getId())) continue;
                return rac;
            }
        }
        return null;
    }

    public static String getFormattedDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public static String buildStringMessage(I18nProvider i18nProvider, MessageTag messageTag, Object ... args) {
        if (messageTag != null) {
            return i18nProvider.getMessage(messageTag, args);
        }
        return null;
    }

    public static MessageTag getCryptoPosition(Context context) {
        switch (context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.ACCM_POS_SIG_SIG;
            }
            case TIMESTAMP: {
                return MessageTag.ACCM_POS_TST_SIG;
            }
            case REVOCATION: {
                return MessageTag.ACCM_POS_REVOC_SIG;
            }
            case CERTIFICATE: {
                return MessageTag.ACCM_POS_CERT_CHAIN;
            }
        }
        throw new IllegalArgumentException("Unsupported context " + (Object)((Object)context));
    }

    public static MessageTag getCertificateChainCryptoPosition(Context context) {
        switch (context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.ACCM_POS_CERT_CHAIN_SIG;
            }
            case TIMESTAMP: {
                return MessageTag.ACCM_POS_CERT_CHAIN_TST;
            }
            case REVOCATION: {
                return MessageTag.ACCM_POS_CERT_CHAIN_REVOC;
            }
            case CERTIFICATE: {
                return MessageTag.ACCM_POS_CERT_CHAIN;
            }
        }
        throw new IllegalArgumentException("Unsupported context " + (Object)((Object)context));
    }

    public static MessageTag getDigestMatcherCryptoPosition(XmlDigestMatcher digestMatcher) {
        switch (digestMatcher.getType()) {
            case OBJECT: 
            case REFERENCE: 
            case XPOINTER: {
                return MessageTag.ACCM_POS_REF;
            }
            case MANIFEST: {
                return MessageTag.ACCM_POS_MAN;
            }
            case MANIFEST_ENTRY: {
                return MessageTag.ACCM_POS_MAN_ENT;
            }
            case SIGNED_PROPERTIES: {
                return MessageTag.ACCM_POS_SIGND_PRT;
            }
            case KEY_INFO: {
                return MessageTag.ACCM_POS_KEY;
            }
            case SIGNATURE_PROPERTIES: {
                return MessageTag.ACCM_POS_SIGNTR_PRT;
            }
            case COUNTER_SIGNATURE: 
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return MessageTag.ACCM_POS_CNTR_SIG;
            }
            case MESSAGE_DIGEST: {
                return MessageTag.ACCM_POS_MES_DIG;
            }
            case CONTENT_DIGEST: {
                return MessageTag.ACCM_POS_CON_DIG;
            }
            case JWS_SIGNING_INPUT_DIGEST: {
                return MessageTag.ACCM_POS_JWS;
            }
            case SIG_D_ENTRY: {
                return MessageTag.ACCM_POS_SIG_D_ENT;
            }
            case MESSAGE_IMPRINT: {
                return MessageTag.ACCM_POS_MESS_IMP;
            }
        }
        throw new IllegalArgumentException(String.format("The provided DigestMatcherType '%s' is not supported!", new Object[]{digestMatcher.getType()}));
    }

    public static MessageTag getTimestampTypeMessageTag(TimestampType timestampType) {
        if (timestampType.isContentTimestamp()) {
            return MessageTag.TST_TYPE_CONTENT_TST;
        }
        if (timestampType.isSignatureTimestamp()) {
            return MessageTag.TST_TYPE_SIGNATURE_TST;
        }
        if (timestampType.isValidationDataTimestamp()) {
            return MessageTag.TST_TYPE_VD_TST;
        }
        if (timestampType.isDocumentTimestamp()) {
            return MessageTag.TST_TYPE_DOC_TST;
        }
        if (timestampType.isArchivalTimestamp()) {
            return MessageTag.TST_TYPE_ARCHIVE_TST;
        }
        throw new IllegalArgumentException(String.format("The TimestampType '%s' is not supported!", new Object[]{timestampType}));
    }

    public static String toUrnOid(String oid) {
        if (oid == null) {
            return null;
        }
        return URN_OID_PREFIX + oid;
    }
}

