/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlMRACertificateMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlMRATrustServiceMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOriginalThirdCountryQcStatementsMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOriginalThirdCountryTrustedServiceMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcStatements;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedServiceProvider;
import eu.europa.esig.dss.enumerations.AdditionalServiceInformation;
import eu.europa.esig.dss.enumerations.MRAEquivalenceContext;
import eu.europa.esig.dss.enumerations.MRAStatus;
import eu.europa.esig.dss.enumerations.QCType;
import eu.europa.esig.dss.enumerations.QCTypeEnum;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.QcStatementUtils;
import eu.europa.esig.dss.spi.tsl.CertificateContentEquivalence;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.dss.spi.tsl.ConditionForQualifiers;
import eu.europa.esig.dss.spi.tsl.MRA;
import eu.europa.esig.dss.spi.tsl.QCStatementOids;
import eu.europa.esig.dss.spi.tsl.ServiceEquivalence;
import eu.europa.esig.dss.spi.tsl.ServiceTypeASi;
import eu.europa.esig.dss.spi.tsl.TLInfo;
import eu.europa.esig.dss.spi.tsl.TrustProperties;
import eu.europa.esig.dss.spi.tsl.TrustServiceProvider;
import eu.europa.esig.dss.spi.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.spi.util.TimeDependentValues;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.XmlQcStatementsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlTrustedServiceProviderBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XmlTrustedServiceProviderBuilder.class);
    private final Map<String, XmlCertificate> xmlCertsMap;
    private final Map<String, XmlTrustedList> xmlTrustedListsMap;
    private final Map<String, TLInfo> tlInfoMap;
    private final XmlQcStatementsBuilder qcStatementsBuilder = new XmlQcStatementsBuilder();

    public XmlTrustedServiceProviderBuilder(Map<String, XmlCertificate> xmlCertsMap, Map<String, XmlTrustedList> xmlTrustedListsMap, Map<String, TLInfo> tlInfoMap) {
        this.xmlCertsMap = xmlCertsMap;
        this.xmlTrustedListsMap = xmlTrustedListsMap;
        this.tlInfoMap = tlInfoMap;
    }

    public List<XmlTrustedServiceProvider> build(CertificateToken certificateToken, Map<CertificateToken, List<TrustProperties>> relatedTrustServices) {
        ArrayList<XmlTrustedServiceProvider> result = new ArrayList<XmlTrustedServiceProvider>();
        for (Map.Entry<CertificateToken, List<TrustProperties>> entry : relatedTrustServices.entrySet()) {
            CertificateToken trustedCert = entry.getKey();
            List<TrustProperties> services = entry.getValue();
            Map<TrustServiceProvider, List<TrustProperties>> servicesByProviders = this.classifyByServiceProvider(services);
            for (Map.Entry<TrustServiceProvider, List<TrustProperties>> servicesByProvider : servicesByProviders.entrySet()) {
                List<TrustProperties> trustServices = servicesByProvider.getValue();
                if (!Utils.isCollectionNotEmpty(trustServices)) continue;
                result.add(this.getXmlTrustedServiceProvider(certificateToken, trustServices, trustedCert));
            }
        }
        return Collections.unmodifiableList(result);
    }

    private Map<TrustServiceProvider, List<TrustProperties>> classifyByServiceProvider(List<TrustProperties> trustPropertiesList) {
        HashMap<TrustServiceProvider, List<TrustProperties>> servicesByProviders = new HashMap<TrustServiceProvider, List<TrustProperties>>();
        if (Utils.isCollectionNotEmpty(trustPropertiesList)) {
            for (TrustProperties trustProperties : trustPropertiesList) {
                TrustServiceProvider currentTrustServiceProvider = trustProperties.getTrustServiceProvider();
                List list = servicesByProviders.computeIfAbsent(currentTrustServiceProvider, k -> new ArrayList());
                list.add(trustProperties);
            }
        }
        return servicesByProviders;
    }

    private XmlTrustedServiceProvider getXmlTrustedServiceProvider(CertificateToken certificateToken, List<TrustProperties> trustServices, CertificateToken trustAnchor) {
        TrustProperties trustProperties = trustServices.iterator().next();
        XmlTrustedServiceProvider result = new XmlTrustedServiceProvider();
        if (trustProperties.getLOTLIdentifier() != null) {
            result.setLOTL(this.xmlTrustedListsMap.get(trustProperties.getLOTLIdentifier().asXmlId()));
        }
        if (trustProperties.getTLIdentifier() != null) {
            result.setTL(this.xmlTrustedListsMap.get(trustProperties.getTLIdentifier().asXmlId()));
        }
        TrustServiceProvider tsp = trustProperties.getTrustServiceProvider();
        result.setTSPNames(this.getLangAndValues(tsp.getNames()));
        result.setTSPTradeNames(this.getLangAndValues(tsp.getTradeNames()));
        result.setTSPRegistrationIdentifiers(tsp.getRegistrationIdentifiers());
        result.setTrustedServices(this.buildXmlTrustedServicesList(certificateToken, trustServices, trustAnchor));
        return result;
    }

    private List<XmlLangAndValue> getLangAndValues(Map<String, List<String>> map) {
        if (Utils.isMapNotEmpty(map)) {
            ArrayList<XmlLangAndValue> result = new ArrayList<XmlLangAndValue>();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String lang = entry.getKey();
                for (String value : entry.getValue()) {
                    XmlLangAndValue langAndValue = new XmlLangAndValue();
                    langAndValue.setLang(lang);
                    langAndValue.setValue(value);
                    result.add(langAndValue);
                }
            }
            return result;
        }
        return null;
    }

    private List<XmlTrustedService> buildXmlTrustedServicesList(CertificateToken certToken, List<TrustProperties> trustServices, CertificateToken trustAnchor) {
        ArrayList<XmlTrustedService> result = new ArrayList<XmlTrustedService>();
        for (TrustProperties trustProperties : trustServices) {
            TimeDependentValues<TrustServiceStatusAndInformationExtensions> trustService = trustProperties.getTrustService();
            List<TrustServiceStatusAndInformationExtensions> serviceStatusAfterOfEqualsCertIssuance = trustService.getAfter(certToken.getNotBefore());
            if (!Utils.isCollectionNotEmpty(serviceStatusAfterOfEqualsCertIssuance)) continue;
            for (TrustServiceStatusAndInformationExtensions serviceInfoStatus : serviceStatusAfterOfEqualsCertIssuance) {
                MRA mra = this.getMRA(trustProperties);
                if (mra != null) {
                    result.addAll(this.buildXmlTrustedServicesWithMRA(serviceInfoStatus, certToken, trustAnchor, mra));
                    continue;
                }
                result.add(this.getXmlTrustedService(serviceInfoStatus, certToken, trustAnchor));
            }
        }
        return Collections.unmodifiableList(result);
    }

    private MRA getMRA(TrustProperties trustProperties) {
        TLInfo tlInfo;
        if (trustProperties.getTLIdentifier() != null && (tlInfo = this.tlInfoMap.get(trustProperties.getTLIdentifier().asXmlId())) != null) {
            return tlInfo.getMra();
        }
        return null;
    }

    private XmlTrustedService getXmlTrustedService(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken, CertificateToken trustAnchor) {
        List<String> serviceSupplyPoints;
        List<String> additionalServiceInfoUris;
        XmlTrustedService trustedService = new XmlTrustedService();
        trustedService.setServiceDigitalIdentifier(this.xmlCertsMap.get(trustAnchor.getDSSIdAsString()));
        trustedService.setServiceNames(this.getLangAndValues(serviceInfoStatus.getNames()));
        trustedService.setServiceType(serviceInfoStatus.getType());
        trustedService.setStatus(serviceInfoStatus.getStatus());
        trustedService.setStartDate(serviceInfoStatus.getStartDate());
        trustedService.setEndDate(serviceInfoStatus.getEndDate());
        List<String> qualifiers = this.getQualifiers(serviceInfoStatus, certToken);
        if (Utils.isCollectionNotEmpty(qualifiers)) {
            trustedService.setCapturedQualifiers(qualifiers);
        }
        if (Utils.isCollectionNotEmpty(additionalServiceInfoUris = serviceInfoStatus.getAdditionalServiceInfoUris())) {
            trustedService.setAdditionalServiceInfoUris(additionalServiceInfoUris);
        }
        if (Utils.isCollectionNotEmpty(serviceSupplyPoints = serviceInfoStatus.getServiceSupplyPoints())) {
            trustedService.setServiceSupplyPoints(serviceSupplyPoints);
        }
        trustedService.setExpiredCertsRevocationInfo(serviceInfoStatus.getExpiredCertsRevocationInfo());
        return trustedService;
    }

    private List<String> getQualifiers(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certificateToken) {
        LOG.trace("--> GET_QUALIFIERS()");
        ArrayList<String> list = new ArrayList<String>();
        List<ConditionForQualifiers> conditionsForQualifiers = serviceInfoStatus.getConditionsForQualifiers();
        if (Utils.isCollectionNotEmpty(conditionsForQualifiers)) {
            for (ConditionForQualifiers conditionForQualifiers : conditionsForQualifiers) {
                Condition condition = conditionForQualifiers.getCondition();
                if (!condition.check(certificateToken)) continue;
                list.addAll(conditionForQualifiers.getQualifiers());
            }
        }
        return list;
    }

    private List<XmlTrustedService> buildXmlTrustedServicesWithMRA(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken, CertificateToken trustAnchor, MRA mra) {
        if (Utils.isCollectionNotEmpty(serviceInfoStatus.getAdditionalServiceInfoUris())) {
            ArrayList<XmlTrustedService> result = new ArrayList<XmlTrustedService>();
            for (String aSI : serviceInfoStatus.getAdditionalServiceInfoUris()) {
                TrustServiceStatusAndInformationExtensions serviceInfoStatusCopy = new TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder(serviceInfoStatus).setAdditionalServiceInfoUris(Collections.singletonList(aSI)).build();
                result.add(this.getXmlTrustedServiceForMRA(serviceInfoStatusCopy, certToken, trustAnchor, mra));
            }
            return result;
        }
        return Collections.singletonList(this.getXmlTrustedServiceForMRA(serviceInfoStatus, certToken, trustAnchor, mra));
    }

    private XmlTrustedService getXmlTrustedServiceForMRA(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken, CertificateToken trustAnchor, MRA mra) {
        XmlMRATrustServiceMapping xmlMRATrustServiceMapping = null;
        List<ServiceEquivalence> mraEquivalences = this.getMRAServiceEquivalences(serviceInfoStatus, mra);
        boolean enactedMra = Utils.isCollectionNotEmpty(mraEquivalences);
        if (enactedMra) {
            if (mraEquivalences.size() == 1) {
                ServiceEquivalence serviceEquivalence = mraEquivalences.iterator().next();
                LOG.info("MRA equivalence is applied for a Trusted Service : '{}'", (Object)serviceEquivalence.getLegalInfoIdentifier());
                xmlMRATrustServiceMapping = this.getXmlMRATrustServiceMapping(serviceInfoStatus, serviceEquivalence, certToken);
                serviceInfoStatus = this.translate(serviceInfoStatus, certToken, serviceEquivalence);
            } else {
                LOG.warn("More than one MRA equivalence found for a Trusted Service!");
            }
        }
        XmlTrustedService xmlTrustedService = this.getXmlTrustedService(serviceInfoStatus, certToken, trustAnchor);
        xmlTrustedService.setMRATrustServiceMapping(xmlMRATrustServiceMapping);
        if (xmlMRATrustServiceMapping != null) {
            xmlTrustedService.setEnactedMRA(true);
        }
        return xmlTrustedService;
    }

    private List<ServiceEquivalence> getMRAServiceEquivalences(TrustServiceStatusAndInformationExtensions serviceInfoStatus, MRA mra) {
        LOG.debug("MRA");
        ArrayList<ServiceEquivalence> equivalences = new ArrayList<ServiceEquivalence>();
        for (ServiceEquivalence serviceEquivalence : mra.getServiceEquivalence()) {
            if (MRAStatus.ENACTED != serviceEquivalence.getStatus() || !this.check(serviceInfoStatus, serviceEquivalence)) continue;
            equivalences.add(serviceEquivalence);
        }
        return equivalences;
    }

    private boolean check(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence) {
        if (!this.checkServiceTypeAsiEquivalence(serviceInfoStatus, serviceEquivalence.getTypeAsiEquivalence())) {
            return false;
        }
        Map<List<String>, List<String>> statusEquivalence = serviceEquivalence.getStatusEquivalence();
        return this.checkStatusEquivalence(serviceInfoStatus, statusEquivalence);
    }

    private boolean checkServiceTypeAsiEquivalence(TrustServiceStatusAndInformationExtensions serviceInfoStatus, Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalenceMap) {
        for (ServiceTypeASi typeAsiEquivalence : typeAsiEquivalenceMap.keySet()) {
            if (!this.checkServiceTypeASi(serviceInfoStatus, typeAsiEquivalence)) continue;
            return true;
        }
        return false;
    }

    private boolean checkServiceTypeASi(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceTypeASi serviceTypeASi) {
        return serviceInfoStatus.getType().equals(serviceTypeASi.getType()) && (serviceTypeASi.getAsi() == null || serviceInfoStatus.getAdditionalServiceInfoUris().contains(serviceTypeASi.getAsi()));
    }

    private boolean checkCertTypeAsiEquivalence(CertificateToken certToken, Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalenceMap) {
        XmlCertificate xmlCertificate = this.xmlCertsMap.get(certToken.getDSSIdAsString());
        if (xmlCertificate == null) {
            throw new IllegalStateException(String.format("XML certificate with Id '%s' is not yet created!", certToken.getDSSIdAsString()));
        }
        CertificateWrapper certificateWrapper = new CertificateWrapper(xmlCertificate);
        boolean qcCompliance = certificateWrapper.isQcCompliance();
        List<QCType> qcTypes = certificateWrapper.getQcTypes();
        for (ServiceTypeASi serviceTypeASi : typeAsiEquivalenceMap.values()) {
            if (serviceTypeASi.getAsi() == null) {
                return true;
            }
            if (Utils.isCollectionNotEmpty(qcTypes)) {
                for (QCType qcType : qcTypes) {
                    if (!this.isQcTypeMatch(qcType, serviceTypeASi)) continue;
                    return true;
                }
                continue;
            }
            if (qcCompliance) {
                if (!this.isQcTypeMatch(QCTypeEnum.QCT_ESIGN, serviceTypeASi)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isQcTypeMatch(QCType qcType, ServiceTypeASi serviceTypeASi) {
        String asi = serviceTypeASi.getAsi();
        if (QCTypeEnum.QCT_ESIGN.equals(qcType)) {
            return AdditionalServiceInformation.isForeSignatures(asi);
        }
        if (QCTypeEnum.QCT_ESEAL.equals(qcType)) {
            return AdditionalServiceInformation.isForeSeals(asi);
        }
        if (QCTypeEnum.QCT_WEB.equals(qcType)) {
            return AdditionalServiceInformation.isForWebAuth(asi);
        }
        return false;
    }

    private boolean checkStatusEquivalence(TrustServiceStatusAndInformationExtensions serviceInfoStatus, Map<List<String>, List<String>> statusEquivalenceMap) {
        for (Map.Entry<List<String>, List<String>> statusEquivalence : statusEquivalenceMap.entrySet()) {
            if (!statusEquivalence.getKey().contains(serviceInfoStatus.getStatus())) continue;
            return true;
        }
        return false;
    }

    private XmlMRATrustServiceMapping getXmlMRATrustServiceMapping(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence, CertificateToken certToken) {
        XmlMRATrustServiceMapping mraTrustServiceMapping = new XmlMRATrustServiceMapping();
        mraTrustServiceMapping.setTrustServiceLegalIdentifier(serviceEquivalence.getLegalInfoIdentifier());
        mraTrustServiceMapping.setEquivalenceStatusStartingTime(serviceEquivalence.getStartDate());
        mraTrustServiceMapping.setOriginalThirdCountryMapping(this.getXmlOriginalThirdCountryTrustedServiceMapping(serviceInfoStatus, certToken));
        return mraTrustServiceMapping;
    }

    private XmlOriginalThirdCountryTrustedServiceMapping getXmlOriginalThirdCountryTrustedServiceMapping(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken) {
        List<String> additionalServiceInfoUris;
        XmlOriginalThirdCountryTrustedServiceMapping originalThirdCountryMapping = new XmlOriginalThirdCountryTrustedServiceMapping();
        originalThirdCountryMapping.setServiceType(serviceInfoStatus.getType());
        originalThirdCountryMapping.setStatus(serviceInfoStatus.getStatus());
        List<String> qualifiers = this.getQualifiers(serviceInfoStatus, certToken);
        if (Utils.isCollectionNotEmpty(qualifiers)) {
            originalThirdCountryMapping.setCapturedQualifiers(qualifiers);
        }
        if (Utils.isCollectionNotEmpty(additionalServiceInfoUris = serviceInfoStatus.getAdditionalServiceInfoUris())) {
            originalThirdCountryMapping.setAdditionalServiceInfoUris(additionalServiceInfoUris);
        }
        return originalThirdCountryMapping;
    }

    private TrustServiceStatusAndInformationExtensions translate(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken, ServiceEquivalence serviceEquivalence) {
        TrustServiceStatusAndInformationExtensions equivalent = this.getEquivalent(serviceInfoStatus, serviceEquivalence);
        if (this.check(certToken, serviceEquivalence)) {
            LOG.info("MRA equivalence is applied for a certificate with Id '{}' : '{}'", (Object)certToken.getDSSIdAsString(), (Object)serviceEquivalence.getLegalInfoIdentifier());
            this.overrideCertContent(certToken, serviceEquivalence);
        } else {
            LOG.debug("MRA equivalence was not applied for a certificate with Id '{}' : '{}'", (Object)certToken.getDSSIdAsString(), (Object)serviceEquivalence.getLegalInfoIdentifier());
        }
        return equivalent;
    }

    private boolean check(CertificateToken certificateToken, ServiceEquivalence serviceEquivalence) {
        Date certIssuance = certificateToken.getNotBefore();
        if (certIssuance.before(serviceEquivalence.getStartDate())) {
            return false;
        }
        return this.checkCertTypeAsiEquivalence(certificateToken, serviceEquivalence.getTypeAsiEquivalence());
    }

    private TrustServiceStatusAndInformationExtensions getEquivalent(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence) {
        ServiceTypeASi typeASiSubstitution = this.getTypeASiSubstitution(serviceInfoStatus, serviceEquivalence);
        String status = this.getStatusSubstitution(serviceInfoStatus, serviceEquivalence);
        List<ConditionForQualifiers> qualifiersSubstitution = this.getQualifiersSubstitution(serviceInfoStatus, serviceEquivalence);
        TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder builder = new TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder();
        if (typeASiSubstitution != null) {
            builder.setType(typeASiSubstitution.getType());
            if (typeASiSubstitution.getAsi() != null) {
                builder.setAdditionalServiceInfoUris(Collections.singletonList(typeASiSubstitution.getAsi()));
            }
        }
        builder.setStatus(status);
        builder.setConditionsForQualifiers(qualifiersSubstitution);
        builder.setStartDate(serviceInfoStatus.getStartDate());
        builder.setEndDate(serviceInfoStatus.getEndDate());
        builder.setNames(serviceInfoStatus.getNames());
        builder.setExpiredCertsRevocationInfo(serviceInfoStatus.getExpiredCertsRevocationInfo());
        builder.setServiceSupplyPoints(serviceInfoStatus.getServiceSupplyPoints());
        return new TrustServiceStatusAndInformationExtensions(builder);
    }

    private ServiceTypeASi getTypeASiSubstitution(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence) {
        for (Map.Entry<ServiceTypeASi, ServiceTypeASi> expectedSubstitution : serviceEquivalence.getTypeAsiEquivalence().entrySet()) {
            ServiceTypeASi expected = expectedSubstitution.getKey();
            if (!this.checkServiceTypeASi(serviceInfoStatus, expected)) continue;
            return this.substituteTypeASi(serviceInfoStatus, expected, expectedSubstitution.getValue());
        }
        return null;
    }

    private ServiceTypeASi substituteTypeASi(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceTypeASi pointed, ServiceTypeASi pointing) {
        String asiResult;
        ServiceTypeASi serviceTypeASi = new ServiceTypeASi();
        serviceTypeASi.setType(pointing.getType());
        if (Utils.isCollectionNotEmpty(serviceInfoStatus.getAdditionalServiceInfoUris())) {
            asiResult = serviceInfoStatus.getAdditionalServiceInfoUris().iterator().next();
            if (asiResult.equals(pointed.getAsi())) {
                asiResult = pointing.getAsi();
            }
        } else {
            asiResult = pointing.getAsi();
        }
        serviceTypeASi.setAsi(asiResult);
        return serviceTypeASi;
    }

    private String getStatusSubstitution(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence) {
        Map<List<String>, List<String>> statusEquivalence = serviceEquivalence.getStatusEquivalence();
        for (Map.Entry<List<String>, List<String>> equivalence : statusEquivalence.entrySet()) {
            List<String> expected = equivalence.getKey();
            if (!expected.contains(serviceInfoStatus.getStatus())) continue;
            return equivalence.getValue().iterator().next();
        }
        return null;
    }

    private List<ConditionForQualifiers> getQualifiersSubstitution(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence) {
        ArrayList<ConditionForQualifiers> result = new ArrayList<ConditionForQualifiers>();
        Map<String, String> qualifierEquivalence = serviceEquivalence.getQualifierEquivalence();
        for (ConditionForQualifiers qualifierCondition : serviceInfoStatus.getConditionsForQualifiers()) {
            ArrayList<String> qualifiers = new ArrayList<String>();
            for (String qualifier : qualifierCondition.getQualifiers()) {
                String pointingQualifier = qualifierEquivalence.get(qualifier);
                if (Utils.isStringNotEmpty(pointingQualifier)) {
                    qualifier = pointingQualifier;
                }
                qualifiers.add(qualifier);
            }
            result.add(new ConditionForQualifiers(qualifierCondition.getCondition(), qualifiers));
        }
        return result;
    }

    private void overrideCertContent(CertificateToken certToken, ServiceEquivalence serviceEquivalence) {
        Map<MRAEquivalenceContext, CertificateContentEquivalence> certificateContentEquivalences = serviceEquivalence.getCertificateContentEquivalences();
        if (Utils.isMapEmpty(certificateContentEquivalences)) {
            LOG.debug("No MRA equivalence is defined for certificate content.");
            return;
        }
        XmlCertificate xmlCertificate = this.xmlCertsMap.get(certToken.getDSSIdAsString());
        if (xmlCertificate == null) {
            throw new IllegalStateException(String.format("XmlCertificate with Id '%s' is not yet created!", certToken.getDSSIdAsString()));
        }
        XmlQcStatements qcStatements = xmlCertificate.getQcStatements();
        if (qcStatements == null) {
            qcStatements = new XmlQcStatements();
            xmlCertificate.setQcStatements(qcStatements);
        }
        block5: for (Map.Entry<MRAEquivalenceContext, CertificateContentEquivalence> equivalence : certificateContentEquivalences.entrySet()) {
            MRAEquivalenceContext equivalenceContext = equivalence.getKey();
            CertificateContentEquivalence certificateContentEquivalence = equivalence.getValue();
            Condition condition = certificateContentEquivalence.getCondition();
            if (!condition.check(certToken)) continue;
            LOG.info("MRA condition match ({})", (Object)equivalenceContext);
            if (qcStatements.getMRACertificateMapping() == null) {
                qcStatements.setMRACertificateMapping(this.getXmlMRACertificateMapping(qcStatements, serviceEquivalence));
                qcStatements.setEnactedMRA(true);
            }
            QCStatementOids contentReplacement = certificateContentEquivalence.getContentReplacement();
            switch (equivalenceContext) {
                case QC_COMPLIANCE: {
                    this.replaceCompliance(qcStatements, contentReplacement);
                    continue block5;
                }
                case QC_TYPE: {
                    this.replaceType(qcStatements, contentReplacement);
                    continue block5;
                }
                case QC_QSCD: {
                    this.replaceQSCD(qcStatements, contentReplacement);
                    continue block5;
                }
            }
            LOG.warn("Unsupported equivalence context {}", (Object)equivalence.getKey());
        }
    }

    private XmlMRACertificateMapping getXmlMRACertificateMapping(XmlQcStatements qcStatements, ServiceEquivalence serviceEquivalence) {
        XmlMRACertificateMapping xmlMRACertificateMapping = new XmlMRACertificateMapping();
        xmlMRACertificateMapping.setEnactedTrustServiceLegalIdentifier(serviceEquivalence.getLegalInfoIdentifier());
        xmlMRACertificateMapping.setOriginalThirdCountryMapping(this.getXmlOriginalThirdCountryQcStatementsMapping(qcStatements));
        return xmlMRACertificateMapping;
    }

    private XmlOriginalThirdCountryQcStatementsMapping getXmlOriginalThirdCountryQcStatementsMapping(XmlQcStatements qcStatements) {
        List<XmlOID> otherOIDs;
        List<String> qcCClegislations;
        List<XmlOID> originalQcTypes;
        XmlOriginalThirdCountryQcStatementsMapping originalQcStatements = new XmlOriginalThirdCountryQcStatementsMapping();
        if (qcStatements.getQcCompliance() != null) {
            originalQcStatements.setQcCompliance(this.qcStatementsBuilder.buildXmlQcCompliance(qcStatements.getQcCompliance().isPresent()));
        }
        if (qcStatements.getQcSSCD() != null) {
            originalQcStatements.setQcSSCD(this.qcStatementsBuilder.buildXmlQcSSCD(qcStatements.getQcSSCD().isPresent()));
        }
        if (Utils.isCollectionNotEmpty(originalQcTypes = qcStatements.getQcTypes())) {
            originalQcStatements.setQcTypes(new ArrayList<XmlOID>(originalQcTypes));
        }
        if (Utils.isCollectionNotEmpty(qcCClegislations = qcStatements.getQcCClegislation())) {
            originalQcStatements.setQcCClegislation(new ArrayList<String>(qcCClegislations));
        }
        if (Utils.isCollectionNotEmpty(otherOIDs = qcStatements.getOtherOIDs())) {
            originalQcStatements.setOtherOIDs(new ArrayList<XmlOID>(otherOIDs));
        }
        return originalQcStatements;
    }

    private void replaceCompliance(XmlQcStatements qcStatements, QCStatementOids contentReplacement) {
        boolean isQcCompliance = false;
        List<String> qcCClegislations = qcStatements.getQcCClegislation();
        for (String oid : contentReplacement.getQcStatementIds()) {
            if (!QcStatementUtils.isQcCompliance(oid)) continue;
            isQcCompliance = true;
        }
        if (Utils.isCollectionNotEmpty(contentReplacement.getQcCClegislations())) {
            qcCClegislations = contentReplacement.getQcCClegislations();
        }
        for (String oid : contentReplacement.getQcStatementIdsToRemove()) {
            if (QcStatementUtils.isQcCompliance(oid)) {
                isQcCompliance = false;
            }
            if (!QcStatementUtils.isQcCClegislation(oid)) continue;
            if (Utils.isCollectionNotEmpty(contentReplacement.getQcCClegislationsToRemove())) {
                qcCClegislations.removeAll(contentReplacement.getQcCClegislationsToRemove());
                continue;
            }
            qcCClegislations.clear();
        }
        qcStatements.setQcCompliance(this.qcStatementsBuilder.buildXmlQcCompliance(isQcCompliance));
        qcStatements.setQcCClegislation(qcCClegislations);
    }

    private void replaceType(XmlQcStatements qcStatements, QCStatementOids contentReplacement) {
        List<XmlOID> originalQcTypes = qcStatements.getQcTypes();
        List<String> qcTypesIds = originalQcTypes.stream().map(XmlOID::getValue).collect(Collectors.toList());
        if (Utils.isCollectionNotEmpty(contentReplacement.getQcTypeIds())) {
            qcTypesIds = contentReplacement.getQcTypeIds();
        }
        for (String oid : contentReplacement.getQcStatementIdsToRemove()) {
            if (!QcStatementUtils.isQcType(oid)) continue;
            if (Utils.isCollectionNotEmpty(contentReplacement.getQcTypeIdsToRemove())) {
                qcTypesIds.removeAll(contentReplacement.getQcTypeIdsToRemove());
                continue;
            }
            qcTypesIds.clear();
        }
        List<QCType> qcTypes = QcStatementUtils.getQcTypes(qcTypesIds);
        qcStatements.setQcTypes(this.qcStatementsBuilder.buildXmlQcTypes(qcTypes));
    }

    private void replaceQSCD(XmlQcStatements qcStatements, QCStatementOids contentReplacement) {
        boolean isQcSSCD = false;
        for (String oid : contentReplacement.getQcStatementIds()) {
            if (!QcStatementUtils.isQcSSCD(oid)) continue;
            isQcSSCD = true;
        }
        for (String oid : contentReplacement.getQcStatementIdsToRemove()) {
            if (!QcStatementUtils.isQcSSCD(oid)) continue;
            isQcSSCD = false;
        }
        qcStatements.getQcSSCD().setPresent(isQcSSCD);
    }
}

